/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.dialogs;

import AIspace.deduction.DeductionCanvas;
import AIspace.deduction.dialogs.ProofFrame;
import AIspace.deduction.elements.DeductionNode;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;

public class ProofCanvas
extends DeductionCanvas {
    public ProofCanvas(Container parent, boolean inline) {
        super(parent, inline);
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return ((ProofFrame)this.parent).isAntiAliasingEnabled();
    }

    @Override
    public void autoscale() {
        this.zoom(this.maximizingScale());
        this.zoom(this.maximizingScale());
        this.zoom(this.maximizingScale());
        this.moveToTopMiddle();
    }

    @Override
    public void moveToTopMiddle() {
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return;
        }
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float middleX = ((ProofFrame)this.parent).canvas.getWidth() / 2;
        this.graph.translateAll(middleX - midX, -min.y);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.mDraggedPos.move(p);
        if (e.getModifiers() != 4) {
            this.mDraggedSelect();
        }
    }

    @Override
    protected float maximizingScale() {
        Point[] bounds = this.graph.getBound();
        Point min = bounds[0];
        Point max = bounds[1];
        if (min.equals(0.0f, 0.0f) || max.equals(0.0f, 0.0f)) {
            return 0.0f;
        }
        if (min.equals(max)) {
            return -1.0f;
        }
        float visibleWidth = ((ProofFrame)this.parent).canvas.getWidth();
        float visibleHeight = ((ProofFrame)this.parent).canvas.getHeight();
        float graphWidth = max.x - min.x;
        float graphHeight = max.y - min.y;
        float widthRatio = visibleWidth / graphWidth;
        float heightRatio = visibleHeight / graphHeight;
        float ratio = Math.min(widthRatio, heightRatio);
        return ratio *= this.graph.getScale();
    }

    protected void setEndNodesColor(Color color) {
        for (Node n : this.graph.nodes) {
            if (((DeductionNode)n).getAllDescendents().size() != 0) continue;
            n.setColor(color);
        }
    }

    @Override
    protected void popupCanvas(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("View Options"));
        JMenuItem autoscale = new JMenuItem("Autoscale");
        autoscale.addActionListener(this);
        this.pop.add(autoscale);
        this.pop.show(this, x, y);
    }

    @Override
    public void setPromptLabel(String s) {
    }

    @Override
    public String getPromptLabel() {
        return null;
    }
}

