/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.dialogs;

import AIspace.deduction.DeductionGraph;
import AIspace.deduction.dialogs.ProofCanvas;
import AIspace.deduction.elements.DeductionNode;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.dialogs.BasicFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProofFrame
extends BasicFrame
implements ActionListener {
    protected ProofCanvas canvas;
    private DeductionGraph oldGraph;
    private DeductionNode endNode;
    private boolean isAntiAlias;

    public ProofFrame(DeductionGraph graph, DeductionNode node, int fontSize) {
        this.setTitle("Viewing Proof Tree");
        this.setSize(500, 500);
        this.setBackground(GraphConsts.bg);
        this.setForeground(GraphConsts.fg);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ProofFrame.this.canvas.disposeWindows();
                ProofFrame.this.dispose();
                ProofFrame.this.setVisible(false);
            }
        });
        this.oldGraph = graph;
        this.endNode = node;
        this.isAntiAlias = graph.canvas.isAntiAliasingEnabled();
        this.construct();
        this.centerWindow();
        this.setVisible(true);
        this.buildDeduction();
        this.canvas.changeFont(fontSize);
        this.canvas.graph.setLineWidth(graph.getLineWidth());
        this.canvas.changeLineWidth();
        this.canvas.setEndNodesColor(Color.MAGENTA);
        this.canvas.repaint();
    }

    private void construct() {
        this.canvas = new ProofCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(400, 600));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("North", this.constructTopPanel());
        this.getContentPane().add("Center", this.canvas);
        this.getContentPane().add("South", this.constructBottomPanel());
    }

    private JPanel constructTopPanel() {
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setPreferredSize(new Dimension(550, 50));
        topPanel.setBackground(Color.white);
        JLabel messageLabel = new JLabel("  Proof tree for:\t\t" + this.endNode.getFullLabel());
        messageLabel.setFont(new Font("arial", 1, 15));
        messageLabel.setMinimumSize(new Dimension(550, 100));
        topPanel.add((Component)messageLabel, "Center");
        return topPanel;
    }

    private JPanel constructBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBackground(GraphConsts.bg);
        bottomPanel.setLayout(new BorderLayout());
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(this);
        JPanel okPanel = new JPanel();
        okPanel.add(okButton);
        bottomPanel.add((Component)okPanel, "Center");
        return bottomPanel;
    }

    public boolean isAntiAliasingEnabled() {
        return this.isAntiAlias;
    }

    private void buildDeduction() {
        ((DeductionGraph)this.canvas.graph).buildProofDeduction(this.endNode, this.oldGraph);
        this.canvas.autoscale();
        this.repaint();
    }

    @Override
    protected boolean actionOK() {
        this.canvas.repaint();
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.canvas.pause) {
            return;
        }
        super.actionPerformed(e);
    }
}

