/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.dialogs;

import AIspace.deduction.DeductionGraph;
import AIspace.deduction.DeductionWindow;
import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ShowResultDialog
extends BasicDialog
implements CaretListener {
    private JComboBox choiceYesNo;
    private JTextField textNumSteps;
    private JTextField textDepth;
    private JComboBox goalChoice;
    private JLabel labelError;
    public boolean isCancelled = true;

    public ShowResultDialog(DeductionWindow w) {
        super((JFrame)w, "Search Options", true);
        DeductionGraph graph = (DeductionGraph)w.returnCanvas().graph;
        this.choiceYesNo = new JComboBox();
        this.choiceYesNo.addItem("Yes");
        this.choiceYesNo.addItem("No");
        if (graph.getStopAtGoal()) {
            this.choiceYesNo.setSelectedItem("Yes");
        } else {
            this.choiceYesNo.setSelectedItem("No");
        }
        this.textNumSteps = new JTextField(String.valueOf(graph.getMaxNumSteps()));
        this.textNumSteps.addCaretListener(this);
        this.textDepth = new JTextField(String.valueOf(graph.getDepth()));
        this.textDepth.addCaretListener(this);
        this.goalChoice = new JComboBox();
        this.goalChoice.addItem("First Atom");
        this.goalChoice.addItem("Random Atom");
        this.goalChoice.addItem("Atom with fewest variables");
        this.goalChoice.addItem("Atom with fewest matching rules");
        if (graph.getGoalSelectHeuristic() == 550) {
            this.goalChoice.setSelectedItem("Random Atom");
        } else if (graph.getGoalSelectHeuristic() == 551) {
            this.goalChoice.setSelectedItem("First Atom");
        } else if (graph.getGoalSelectHeuristic() == 553) {
            this.goalChoice.setSelectedItem("Atom with fewest variables");
        } else {
            this.goalChoice.setSelectedItem("Atom with fewest matching rules");
        }
        JPanel p1 = new JPanel();
        p1.add(new JLabel("Stop searching when an answer is found?"));
        p1.add(this.choiceYesNo);
        JPanel p2 = new JPanel();
        p2.add(new JLabel("Maximum number of search steps:"));
        p2.add(this.textNumSteps);
        JPanel p2a = new JPanel();
        p2a.add(new JLabel("Search tree depth bound:"));
        p2a.add(this.textDepth);
        JPanel p3 = new JPanel();
        p3.add(new JLabel("Atom selection heuristic:"));
        p3.add(this.goalChoice);
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(4, 1));
        top.add(p1);
        top.add(p2);
        top.add(p2a);
        top.add(p3);
        JPanel middle = new JPanel();
        JButton button = new JButton("OK");
        button.addActionListener(this);
        middle.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        middle.add(button);
        this.labelError = new JLabel("Error: Number of Steps must be a positive integer!");
        this.labelError.setVisible(false);
        JPanel bottom = new JPanel();
        bottom.add(this.labelError);
        this.getContentPane().add("North", top);
        this.getContentPane().add("Center", middle);
        this.getContentPane().add("South", this.labelError);
        this.pack();
    }

    public void open() {
        this.isCancelled = true;
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setValues() {
        try {
            DeductionGraph graph = (DeductionGraph)((DeductionWindow)this.getParent()).returnCanvas().graph;
            graph.setMaxNumSteps(Integer.parseInt(this.textNumSteps.getText()));
            graph.setDepth(Integer.parseInt(this.textDepth.getText()));
            graph.setStopAtGoal(this.choiceYesNo.getSelectedItem().equals("Yes"));
            if (this.goalChoice.getSelectedItem().equals("First Atom")) {
                graph.setGoalSelectHeuristic(551);
            } else if (this.goalChoice.getSelectedItem().equals("Random Atom")) {
                graph.setGoalSelectHeuristic(550);
            } else if (this.goalChoice.getSelectedItem().equals("Atom with fewest variables")) {
                graph.setGoalSelectHeuristic(553);
            } else {
                graph.setGoalSelectHeuristic(552);
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setVisible(true);
            this.pack();
            return false;
        }
    }

    @Override
    protected boolean actionOK() {
        if (this.setValues()) {
            this.isCancelled = false;
            return true;
        }
        return false;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        try {
            Integer.parseInt(this.textNumSteps.getText());
            Integer.parseInt(this.textDepth.getText());
            this.labelError.setVisible(false);
        }
        catch (Exception ex) {
            this.labelError.setVisible(true);
        }
        this.pack();
    }
}

