/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.dialogs;

import AIspace.deduction.DeductionGraph;
import AIspace.deduction.elements.DeductionNode;
import AIspace.graphToolKit.dialogs.BasicFrame;
import AIspace.prolog.Goal;
import AIspace.prolog.Rule;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UserSearchFrame
extends BasicFrame {
    private DeductionGraph graph;
    private DeductionNode node;
    private JComboBox goalChoice;
    private JComboBox ruleChoice;
    private ArrayList<Goal> theGoals;
    private ArrayList<Rule> theRules;
    private JLabel instruct1;

    public UserSearchFrame(DeductionGraph graph, DeductionNode node) {
        super("Atom and Clause selection");
        this.node = node;
        this.graph = graph;
        this.theGoals = node.getGoals();
        this.goalChoice = new JComboBox();
        int i = 0;
        while (i < this.theGoals.size()) {
            this.goalChoice.addItem(this.theGoals.get(i).toString());
            ++i;
        }
        if (node.getGoalChosen() != null) {
            this.goalChoice.setSelectedIndex(this.theGoals.indexOf(node.getGoalChosen()));
        }
        this.goalChoice.addActionListener(this);
        Goal g = this.theGoals.get(this.goalChoice.getSelectedIndex());
        JPanel top = new JPanel();
        top.add(new JLabel("Select an atom"));
        top.add(this.goalChoice);
        this.ruleChoice = new JComboBox();
        this.theRules = graph.getRulesFor(g);
        this.instruct1 = new JLabel("and then choose a clause. ");
        int i2 = 0;
        while (i2 < this.theRules.size()) {
            this.ruleChoice.addItem(this.theRules.get(i2).toString());
            ++i2;
        }
        if (this.theRules.size() == 0) {
            if (g.getPredicate().builtIn() || g.neg) {
                this.instruct1.setText("Click 'OK' to try solving this atom.");
            } else {
                this.instruct1.setText("No more clauses available for this atom.");
                this.ruleChoice.setVisible(false);
            }
        }
        JPanel bottom = new JPanel();
        bottom.add("North", this.instruct1);
        bottom.add("Center", this.ruleChoice);
        JPanel p = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(this);
        p.add(okButton);
        p.add(cancelButton);
        if (this.theRules.size() == 0 && this.theGoals.size() == 1) {
            JPanel instruct = new JPanel();
            instruct.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            instruct.add(this.instruct1);
            this.getContentPane().add("Center", instruct);
        } else {
            this.getContentPane().add("North", top);
            this.getContentPane().add("Center", bottom);
            this.getContentPane().add("South", p);
        }
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    @Override
    protected boolean actionOK() {
        Goal g = this.theGoals.get(this.goalChoice.getSelectedIndex());
        if (this.ruleChoice.getSelectedIndex() >= 0) {
            this.graph.applyRule(this.theRules.get(this.ruleChoice.getSelectedIndex()), this.theGoals.get(this.goalChoice.getSelectedIndex()), this.node);
        } else if (g.getPredicate().builtIn() || g.neg) {
            this.graph.applyRule(null, g, this.node);
        } else if (this.ruleChoice.getItemCount() == 0) {
            this.graph.createFailureNode(this.node);
        }
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.goalChoice) {
            if (this.ruleChoice != null && this.ruleChoice.getItemCount() > 0) {
                this.ruleChoice.removeAllItems();
            }
            Goal g = this.theGoals.get(this.goalChoice.getSelectedIndex());
            this.theRules = this.graph.getRulesFor(g);
            int i = 0;
            while (i < this.theRules.size()) {
                this.ruleChoice.addItem(this.theRules.get(i).toString());
                ++i;
            }
            if (this.theRules.size() == 0) {
                this.ruleChoice.setVisible(false);
                if (g.neg || g.getPredicate().builtIn()) {
                    this.instruct1.setText("Click 'Ok' to try solving this atom.");
                } else {
                    this.instruct1.setText("No more clauses available for this atom.");
                }
            } else {
                this.instruct1.setText("and then choose a clause. ");
                this.ruleChoice.setVisible(true);
            }
            this.pack();
            this.validate();
        }
    }
}

