/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.elements;

import AIspace.deduction.DeductionGraph;
import AIspace.deduction.elements.DeductionNode;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.prolog.Substitution;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class DeductionEdge
extends Edge {
    protected ArrayList<Substitution> substitutions;
    protected ArrayList<Substitution> extraSubs;
    protected boolean isHidden;

    public DeductionEdge(DeductionGraph graph, Node tail, Node head) {
        super(graph, tail, head);
        this.edgeType = 5551;
        ((DeductionNode)this.start).setChild((DeductionNode)this.end);
        this.isHidden = false;
    }

    public void setSubs(ArrayList<Substitution> v1, ArrayList<Substitution> v2, int detail) {
        this.substitutions = v1;
        this.extraSubs = v2;
        this.setLabel(detail);
    }

    @Override
    public String getLabel() {
        return this.label[0];
    }

    public ArrayList getSubstitutions() {
        return this.substitutions;
    }

    public String getFullLabel() {
        int index;
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this.substitutions.size()) {
            str.append(this.substitutions.get(i).toString()).append(", ");
            ++i;
        }
        if (((DeductionGraph)this.graph).showFullSubs) {
            i = 0;
            while (i < this.extraSubs.size()) {
                str.append(this.extraSubs.get(i).toString()).append(", ");
                ++i;
            }
        }
        if ((index = str.lastIndexOf(",")) != -1) {
            return str.substring(0, index);
        }
        return str.toString();
    }

    public void setLabel(int detail) {
        if (this.isHidden) {
            return;
        }
        switch (detail) {
            case 41: {
                this.setLabelFull();
                break;
            }
            case 42: {
                this.setLabelPlace();
                break;
            }
            default: {
                this.setLabelBlank();
            }
        }
    }

    public void setLabelFull() {
        if (this.substitutions == null || this.substitutions.size() == 0 && (this.extraSubs.size() == 0 || !((DeductionGraph)this.graph).showFullSubs)) {
            super.setLabel("");
            return;
        }
        super.setLabel(this.getFullLabel());
    }

    public void setLabelPlace() {
        if (this.substitutions == null || this.substitutions.size() == 0 && (this.extraSubs.size() == 0 || !((DeductionGraph)this.graph).showFullSubs)) {
            super.setLabel("");
            return;
        }
        super.setLabel("X");
    }

    public void setLabelBlank() {
        super.setLabel("");
    }

    public void setHidden(boolean bool, int detail) {
        this.isHidden = bool;
        if (this.isHidden) {
            this.setLabelBlank();
        } else {
            this.color = Color.black;
            this.setLabel(detail);
        }
    }

    @Override
    public void draw(Graphics offscreen, boolean moving) {
        if (this.isHidden) {
            return;
        }
        super.draw(offscreen, moving);
    }
}

