/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.elements;

import AIspace.deduction.DeductionCanvas;
import AIspace.deduction.DeductionGraph;
import AIspace.deduction.elements.DeductionEdge;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import AIspace.prolog.Goal;
import AIspace.prolog.Program;
import AIspace.prolog.Rule;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class DeductionNode
extends Node {
    public static final int REGULAR_NODE = 0;
    public static final int START_NODE = 1;
    public static final int GOAL_NODE = 2;
    public static final int CURRENT_NODE = 3;
    public static final int FRONTIER_NODE = 4;
    public static final int CHILDREN_NODE = 5;
    public static final int NON_CURRENT_NODE = 6;
    public static final int FAILURE_NODE = 7;
    public ArrayList<DeductionNode> neighbours;
    protected DeductionNode parent;
    protected int nodeType;
    protected int nodeSearchType;
    protected int currNeighbour;
    protected StringBuffer searchOrder;
    protected boolean drawOrdering;
    protected String justLabel;
    protected String fullLabel;
    protected boolean pathFound;
    protected ArrayList<Goal> goals;
    protected ArrayList usedRules;
    protected Rule derivedFrom;
    protected Goal derivedFromGoal;
    protected Goal yesClause;
    protected Goal goalChosen;
    protected int depth;
    protected int branchWidth;
    protected int branchDepth;
    protected boolean isHovered;
    protected boolean isHidden;
    protected boolean failure;

    public DeductionNode(DeductionGraph graph, ArrayList<Goal> theGoals, int detail, Goal yClause) {
        super(graph);
        this.depth = 0;
        this.branchDepth = 0;
        this.neighbours = new ArrayList();
        this.nodeType = 0;
        this.nodeSearchType = 6;
        this.searchOrder = new StringBuffer();
        this.drawOrdering = false;
        this.justLabel = this.getLabel();
        this.pathFound = false;
        this.wPad = 20;
        this.hPad = 20;
        this.updateSize();
        this.goals = theGoals;
        this.yesClause = yClause;
        this.isHovered = false;
        this.isHidden = false;
        this.fullLabel = this.goals.size() > 0 ? new String(String.valueOf(this.yesClause.toString()) + " <- " + this.goals.toString() + ".") : new String(String.valueOf(this.yesClause.toString()) + ".");
        this.setLabel(detail);
    }

    public int getBranchDepth() {
        return this.branchDepth;
    }

    public void setBranchDepth(int newDepth) {
        this.branchDepth = newDepth;
    }

    public DeductionNode(DeductionGraph graph, ArrayList<Goal> theGoals) {
        super(graph);
        this.neighbours = new ArrayList();
        this.nodeType = 0;
        this.nodeSearchType = 6;
        this.searchOrder = new StringBuffer();
        this.drawOrdering = false;
        this.justLabel = this.getLabel();
        this.pathFound = false;
        this.wPad = 20;
        this.hPad = 20;
        this.updateSize();
        this.goals = theGoals;
        this.setLabelGoals();
        this.isHovered = false;
    }

    public void setLabelYes() {
        if (this.nodeType != 2 && this.nodeType != 7) {
            Rule r = new Rule(this.yesClause, this.goals);
            String str = r.toString();
            if (str.length() > 25 && this.nodeType != 1 && !this.isHovered) {
                str = str.substring(0, 22);
                str = String.valueOf(str) + "...";
            }
            this.setJustLabel(str);
        } else if (this.nodeType == 2) {
            this.setJustLabel(this.yesClause.toString());
        } else {
            this.setJustLabel("false");
        }
        this.updateSize();
    }

    public void setLabelGoals() {
        if (this.goals.size() > 0) {
            String str = this.goals.toString();
            if (str.length() > 25 && this.nodeType != 1 && !this.isHovered) {
                str = str.substring(0, 22);
                str = String.valueOf(str) + "...";
            }
            this.setJustLabel(str);
        } else if (this.nodeType == 2) {
            this.setJustLabel("true");
        } else if (this.nodeType == 7) {
            this.setJustLabel("false");
        }
        this.updateSize();
    }

    public void setLabelShort() {
        if (this.index == -1) {
            this.setJustLabel("N" + this.graph.getNextIndex());
        } else {
            this.setJustLabel("N" + this.index);
        }
        this.updateSize();
    }

    public void setNoLabel() {
        this.setJustLabel("");
        this.updateSize();
    }

    public void setLabel(int detail) {
        if (detail == 41) {
            this.setLabelYes();
        } else if (detail == 42) {
            this.setLabelGoals();
        } else if (detail == 39) {
            this.setNoLabel();
        } else {
            this.setLabelShort();
        }
    }

    public String getFullLabel() {
        return this.fullLabel;
    }

    public void reset() {
        this.drawOrdering = false;
        this.neighbours = new ArrayList();
        int i = 0;
        while (i < this.goals.size()) {
            this.goals.get(i).reset();
            ++i;
        }
    }

    public String getName() {
        return this.goals.toString();
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(int type) {
        this.nodeType = type;
        if (type == 7) {
            this.fullLabel = "Unification failed.";
        }
    }

    public int getNodeSearchType() {
        return this.nodeSearchType;
    }

    public void setNodeSearchType(int type) {
        this.nodeSearchType = type;
    }

    public ArrayList<Goal> getGoals() {
        return this.goals;
    }

    public Goal getGoalChosen() {
        return this.goalChosen;
    }

    public void setGoalChosen(Goal goal) {
        this.goalChosen = goal;
    }

    public DeductionNode getParent() {
        return this.parent;
    }

    public Goal getYesClause() {
        return this.yesClause;
    }

    public void setParent(DeductionNode parent) {
        this.parent = parent;
    }

    public boolean getPathFound() {
        return this.pathFound;
    }

    public void setPathFound(boolean value) {
        this.pathFound = value;
    }

    public int getHeuristics() {
        return this.goals.size();
    }

    private boolean stillValidGoals() {
        boolean all = false;
        int i = 0;
        while (i < this.goals.size()) {
            if (!this.goals.get(i).needsDelaying()) {
                all = true;
                break;
            }
            ++i;
        }
        return all;
    }

    protected Goal nextGoal() {
        if (!this.stillValidGoals()) {
            return null;
        }
        switch (((DeductionGraph)this.graph).getGoalSelectHeuristic()) {
            case 550: {
                int index = (int)Math.floor(Math.random() * (double)this.goals.size());
                Goal g = this.goals.get(index);
                while (g.needsDelaying()) {
                    index = (int)Math.floor(Math.random() * (double)this.goals.size());
                    g = this.goals.get(index);
                }
                return g;
            }
            case 551: {
                return this.goals.get(0);
            }
            case 552: {
                int[] lengths = new int[this.goals.size()];
                int i = 0;
                while (i < this.goals.size()) {
                    Goal g1 = this.goals.get(i);
                    lengths[i] = g1.getPredicate().builtIn() ? (g1.needsDelaying() ? -1 : 0) : ((DeductionGraph)this.graph).getRulesFor(g1).size();
                    ++i;
                }
                int min = 0;
                int minIndex = 0;
                int i2 = 0;
                while (i2 < lengths.length) {
                    if (lengths[i2] != -1 && lengths[i2] < min) {
                        minIndex = i2;
                    }
                    ++i2;
                }
                return this.goals.get(minIndex);
            }
            case 553: {
                int[] numVars = new int[this.goals.size()];
                int i = 0;
                while (i < this.goals.size()) {
                    Goal g1 = this.goals.get(i);
                    numVars[i] = g1.needsDelaying() ? -1 : g1.getUniqueVariables().size();
                    ++i;
                }
                int min1 = 0;
                int minIndex1 = 0;
                int i3 = 0;
                while (i3 < numVars.length) {
                    if (numVars[i3] != -1 && numVars[i3] < min1) {
                        minIndex1 = i3;
                    }
                    ++i3;
                }
                return this.goals.get(minIndex1);
            }
        }
        return null;
    }

    public int numNeighbours() {
        return this.neighbours.size();
    }

    @Override
    public ArrayList<Node> getNeighbours() {
        if (this.nodeType == 2) {
            return new ArrayList<Node>();
        }
        if (!this.failure && this.nextGoal() != null) {
            ((DeductionGraph)this.graph).expandNode(this, this.nextGoal());
            ArrayList<Node> neigh = new ArrayList<Node>(this.neighbours.size());
            int i = 0;
            while (i < this.neighbours.size()) {
                neigh.add(this.neighbours.get(i));
                ++i;
            }
            return neigh;
        }
        return new ArrayList<Node>();
    }

    public void setChild(DeductionNode ch) {
        if (!this.neighbours.contains(ch)) {
            this.neighbours.add(ch);
        }
        ch.parent = this;
    }

    protected void setBranchWidth() {
        if (this.neighbours.size() == 0) {
            this.branchWidth = this.width;
            return;
        }
        int i = 0;
        while (i < this.neighbours.size()) {
            this.neighbours.get(i).setBranchWidth();
            ++i;
        }
        this.branchWidth = 0;
        i = 0;
        while (i < this.neighbours.size()) {
            DeductionNode child = this.neighbours.get(i);
            this.branchWidth += Math.max(child.branchWidth, child.width);
            ++i;
        }
    }

    public int getBranchWidth() {
        return this.branchWidth;
    }

    public void adjustChildren() {
        if (this.neighbours.size() == 0) {
            return;
        }
        if (this.neighbours.size() == 1) {
            DeductionNode node = this.neighbours.get(0);
            node.pos.x = this.pos.x;
            node.updateSize();
            this.graph.updateNodeSize(node);
            node.adjustChildren();
        } else {
            this.setBranchWidth();
            int columnSize = ((DeductionCanvas)this.graph.canvas).returnWindow().scrollPanel.getWidth() / (this.branchDepth + 1);
            if (this.branchWidth > columnSize) {
                this.branchWidth = columnSize;
            }
            int leftPosition = (int)(this.pos.x - (float)(columnSize / 2));
            int rightPosition = (int)(this.pos.x + (float)(columnSize / 2));
            float emptySpace = rightPosition - leftPosition - this.branchWidth;
            int interval = (int)(emptySpace / (float)(this.neighbours.size() + 1));
            int currPos = leftPosition + interval;
            int i = 0;
            while (i < this.neighbours.size()) {
                DeductionNode node = this.neighbours.get(i);
                node.pos = new Point(currPos + this.branchWidth / this.neighbours.size() / 2, node.pos.y);
                currPos += this.branchWidth / this.neighbours.size() + interval;
                node.updateSize();
                this.graph.updateNodeSize(node);
                node.adjustChildren();
                ++i;
            }
        }
    }

    public void adjustChildren(boolean bool) {
        if (this.neighbours.size() == 0) {
            return;
        }
        if (this.neighbours.size() == 1) {
            DeductionNode node = this.neighbours.get(0);
            node.pos.x = this.pos.x;
            node.pos.y += 20.0f;
            node.updateSize();
            this.graph.updateNodeSize(node);
            node.adjustChildren(bool);
        } else {
            this.setBranchWidth();
            int columnSize = this.graph.canvas.getSize().width / (this.branchDepth + 1);
            if (this.branchWidth > columnSize) {
                this.branchWidth = columnSize;
            }
            float leftPosition = this.pos.x - (float)(columnSize / 2);
            float rightPosition = this.pos.x + (float)(columnSize / 2);
            float emptySpace = rightPosition - leftPosition - (float)this.branchWidth;
            float interval = emptySpace / (float)(this.neighbours.size() + 1);
            int currPos = (int)leftPosition;
            currPos += (int)interval;
            int i = 0;
            while (i < this.neighbours.size()) {
                DeductionNode node = this.neighbours.get(i);
                node.pos = new Point(currPos + this.branchWidth / this.neighbours.size() / 2, node.pos.y);
                currPos += this.branchWidth / this.neighbours.size() + (int)interval;
                node.updateSize();
                this.graph.updateNodeSize(node);
                node.adjustChildren(bool);
                ++i;
            }
        }
    }

    public ArrayList<DeductionNode> getAllDescendents() {
        ArrayList<DeductionNode> v = new ArrayList<DeductionNode>();
        if (this.neighbours != null && this.neighbours.size() > 0) {
            Program p = new Program();
            int i = 0;
            while (i < this.neighbours.size()) {
                DeductionNode node = this.neighbours.get(i);
                v.add(node);
                p.append(v, node.getAllDescendents());
                ++i;
            }
        }
        return v;
    }

    public void clearChild(Node child) {
        this.neighbours.remove(child);
    }

    public DeductionEdge getEdgeIn() {
        if (this.edgesIn.size() > 0) {
            return (DeductionEdge)this.edgesIn.get(0);
        }
        return null;
    }

    @Override
    public void removeEdgesOut(Edge e) {
        this.edgesOut.remove(e);
        this.clearChild(e.end);
    }

    public ArrayList<Edge> getEdgesOut() {
        return this.edgesOut;
    }

    public void setSearchOrder(int order) {
        if (!this.searchOrder.toString().equals("")) {
            this.searchOrder.append(", ");
        }
        this.searchOrder.append(order);
    }

    public void resetSearchOrder() {
        this.searchOrder = new StringBuffer();
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setDrawOrdering(boolean value) {
        this.drawOrdering = value;
    }

    public boolean getDrawOrdering() {
        return this.drawOrdering;
    }

    public Rule getDerivedFrom() {
        return this.derivedFrom;
    }

    public void setDerivedFrom(Rule rule) {
        this.derivedFrom = rule;
    }

    public Goal getDerivedFromGoal() {
        return this.derivedFromGoal;
    }

    public void setDerivedFromGoal(Goal goal) {
        this.derivedFromGoal = goal;
    }

    public boolean getHovered() {
        return this.isHovered;
    }

    public void setHovered(boolean hovered) {
        this.isHovered = hovered;
    }

    public String getJustLabel() {
        return this.justLabel;
    }

    public void setJustLabel(String l) {
        this.label[0] = this.justLabel = new String(l);
    }

    public void setNodeAppearance(int type) {
        switch (type) {
            case 1: {
                this.shape = 1110;
                this.setHeavy(false);
                break;
            }
            case 2: {
                this.shape = 1112;
                this.setHeavy(false);
                break;
            }
            case 0: {
                this.shape = 1111;
                this.setHeavy(false);
                break;
            }
            case 7: {
                this.shape = 1111;
                this.setHeavy(false);
                break;
            }
            case 3: {
                this.setHeavy(true);
                this.color = Color.red;
                break;
            }
            case 4: {
                this.setHeavy(true);
                this.color = Color.green;
                break;
            }
            case 5: {
                this.setHeavy(true);
                this.color = Color.blue;
                break;
            }
            case 6: {
                this.setHeavy(false);
                this.color = Color.black;
                break;
            }
            default: {
                this.shape = 1111;
                this.color = Color.black;
                this.setHeavy(false);
            }
        }
    }

    @Override
    public void draw(Graphics offscreen, boolean moving) {
        if (this.isHidden) {
            return;
        }
        if (this.drawOrdering && this.color.equals(Color.black)) {
            this.xw = 2;
            this.color = Color.gray;
        }
        super.draw(offscreen, moving);
        if (this.drawOrdering && ((DeductionGraph)this.graph).getShowNum()) {
            double lx = (double)this.pos.x + (double)this.width / 2.0;
            double ly = (double)this.pos.y - (double)this.height / 2.0 - 2.0;
            offscreen.setColor(Color.red);
            offscreen.drawString(this.searchOrder.toString(), (int)lx, (int)(ly -= (double)offscreen.getFontMetrics().getDescent()));
        }
    }

    @Override
    public void drawStructure(Graphics offscreen, boolean moving) {
        if (this.isHidden) {
            return;
        }
        super.drawStructure(offscreen, moving);
    }

    @Override
    protected void drawLabel(Graphics offscreen) {
        if (this.isHidden) {
            return;
        }
        super.drawLabel(offscreen);
    }

    public int getType() {
        return this.nodeType;
    }

    public void setIsHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    @Override
    public String toString() {
        if (this.goals == null || this.goals.size() > 0) {
            return this.goals.toString();
        }
        if (this.nodeType == 2) {
            return "true";
        }
        return "false";
    }
}

