/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.searchTypes;

import AIspace.deduction.DeductionCanvas;
import AIspace.deduction.DeductionGraph;
import AIspace.deduction.elements.DeductionEdge;
import AIspace.deduction.elements.DeductionNode;
import AIspace.deduction.searchTypes.AutoSearch;
import AIspace.deduction.searchTypes.SearchObject;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class Search {
    public static final int SEARCH_ROUGH = 101;
    public static final int SEARCH_STEP = 102;
    public static final int SEARCH_FINE = 103;
    public static final int SEARCH_TEST = 104;
    public static final int DEPTH_FIRST = 201;
    public static final int BREADTH_FIRST = 202;
    public static final int LOWEST_COST_FIRST = 203;
    public static final int BEST_FIRST = 204;
    public static final int HEURISTIC_DEPTH_FIRST = 205;
    public static final int A_STAR = 206;
    public static final int USER_DEFINED = 209;
    public static final int MULT_PATH_PRUNING = 301;
    public static final int LOOP_DETECTION = 302;
    public static final int NO_PRUNING = 303;
    protected DeductionGraph graph;
    protected ArrayList<SearchObject> frontier;
    protected ArrayList<Integer> shorterFrontier;
    protected ArrayList<SearchObject> neighbours;
    protected ArrayList<Node> startNodes;
    protected ArrayList<Integer> goalNodeIndex;
    protected int searchRate;
    protected SearchObject currObject;
    protected SearchObject previousObject;
    protected int current;
    protected int nodeCount;
    protected boolean resultsShown;
    protected boolean quizzed;
    protected boolean answerCorrect;
    protected StringBuffer pathString;
    protected int previousIndex;
    protected boolean testDone;
    protected DeductionNode selectedNode;
    protected boolean goalReached;
    protected AutoSearch auto;
    public static int dt = 100;
    protected ArrayList<SearchObject> backup;

    public Search() {
        this.graph = null;
        this.frontier = new ArrayList();
        this.shorterFrontier = new ArrayList();
        this.neighbours = new ArrayList();
        this.startNodes = new ArrayList();
        this.goalNodeIndex = new ArrayList();
        this.currObject = null;
        this.current = 0;
        this.resultsShown = false;
        this.quizzed = false;
        this.answerCorrect = false;
        this.previousObject = null;
        this.nodeCount = 1;
        this.pathString = new StringBuffer();
        this.previousIndex = -1;
        this.testDone = false;
        this.goalReached = false;
    }

    public Search(DeductionGraph sg) {
        this.graph = sg;
        this.frontier = new ArrayList();
        this.shorterFrontier = new ArrayList();
        this.neighbours = new ArrayList();
        this.currObject = null;
        this.startNodes = new ArrayList(1);
        if (sg.getStartNode() != null) {
            this.startNodes.add(sg.getStartNode());
        }
        this.goalNodeIndex = sg.getGoalNodeIndex();
        this.searchRate = sg.getSearchRate();
        this.current = 0;
        this.resultsShown = false;
        this.quizzed = false;
        this.answerCorrect = false;
        this.previousObject = null;
        this.nodeCount = 1;
        this.pathString = new StringBuffer();
        this.previousIndex = -1;
        this.testDone = false;
        this.goalReached = false;
        this.stepInit();
    }

    public void setSelectedNode(DeductionNode node) {
        this.selectedNode = node;
    }

    public void repaint() {
        this.graph.repaint();
    }

    public DeductionNode getStartNode() {
        if (this.startNodes.size() > 0) {
            int currIndex = this.startNodes.get(0).getIndex();
            return (DeductionNode)this.graph.nodeFromIndex(currIndex);
        }
        return null;
    }

    protected void stepInit() {
        if (this.startNodes.size() > 0) {
            int currIndex = this.startNodes.get(0).getIndex();
            DeductionNode currNode = (DeductionNode)this.graph.nodeFromIndex(currIndex);
            currNode.setSearchOrder(1);
            currNode.setDrawOrdering(true);
            currNode.setPathFound(true);
            currNode.setNodeAppearance(3);
            if (this.startNodes.size() > 1) {
                ArrayList<SearchObject> startNodeCollection = new ArrayList<SearchObject>();
                int i = 1;
                while (i < this.startNodes.size()) {
                    int nextStart = this.startNodes.get(i).getIndex();
                    this.shorterFrontier.add(new Integer(nextStart));
                    startNodeCollection.add(new SearchObject(-1, nextStart, null, this.graph));
                    ++i;
                }
                this.mergeWithFrontier(startNodeCollection);
            }
            this.paintNodes(this.frontier, 4);
            ArrayList<Node> children = new ArrayList<Node>(((DeductionNode)this.graph.nodeFromIndex(currIndex)).getNeighbours());
            int numNeigh = children.size();
            int i = 0;
            while (i < numNeigh) {
                this.neighbours.add(new SearchObject(currNode.getIndex(), children.get((int)0).index, null, this.graph));
                children.remove(0);
                ++i;
            }
        }
    }

    public void step() {
        switch (this.searchRate) {
            case 102: {
                this.doSearchStep();
                break;
            }
            case 103: {
                this.doSearchFine();
                break;
            }
            case 101: {
                this.startAutoSearch();
                break;
            }
            default: {
                System.out.println("Error in Search " + this.searchRate);
            }
        }
    }

    protected void doSearchStep() {
        if (this.previousObject != null) {
            this.currObject = (SearchObject)this.previousObject.clone();
        }
        this.doSearchFine();
        while (this.current != 3) {
            this.doSearchFine();
        }
    }

    protected void doSearchFine() {
        switch (this.current) {
            case 0: {
                if (this.neighbours.size() > 0) {
                    this.paintNodes(this.neighbours, 5);
                }
                this.current = 1;
                this.backup = new ArrayList<SearchObject>(this.frontier);
                this.mergeWithFrontier(this.neighbours);
                break;
            }
            case 1: {
                this.resetPrevious(this.currObject);
                this.resetEdges();
                this.stepOne();
                this.current = 2;
                break;
            }
            case 2: {
                this.stepTwo();
                this.current = 3;
                break;
            }
            case 3: {
                this.stepThree();
                this.current = 1;
                break;
            }
            default: {
                System.out.println("error");
            }
        }
    }

    public void resetAutoSearch() {
        this.stopAutoSearch();
        this.auto = null;
    }

    public void startAutoSearch() {
        this.auto = new AutoSearch(this, dt);
        this.auto.start();
    }

    public void stopAutoSearch() {
        if (this.auto == null) {
            return;
        }
        if (this.auto.isAlive()) {
            this.auto.quit();
        }
    }

    public void pauseAuto(boolean pause) {
        if (this.auto == null) {
            return;
        }
        this.auto.pause = pause;
    }

    public boolean autoSearchContinue(int count) {
        if (count == 0) {
            return true;
        }
        if (this.frontier.size() <= 0 && this.currObject == null) {
            this.graph.showMessage("Search Done", "No more paths to search");
            return false;
        }
        if (count >= this.graph.getMaxNumSteps()) {
            this.graph.showMessage("Search Incomplete", "Auto Search incomplete after " + this.graph.getMaxNumSteps() + " steps.");
            this.graph.setButtonsAfterSearchComplete();
            return false;
        }
        return !this.graph.getStopAtGoal() || !this.goalReached;
    }

    public void autoSearchStep() {
        if (this.previousObject != null) {
            this.currObject = (SearchObject)this.previousObject.clone();
        }
        this.doSearchFine();
        while (this.current != 3) {
            this.doSearchFine();
        }
    }

    public void autoSearchEnd() {
        this.goalReached = false;
        this.stopAutoSearch();
        this.graph.disableStopButton();
    }

    public void setSearchRate(int rate) {
        this.searchRate = rate;
    }

    public int getSearchRate() {
        return this.searchRate;
    }

    protected void stepOne() {
        if (this.backup != null) {
            this.frontier = this.backup;
        }
        if (this.neighbours != null && this.neighbours.size() > 0) {
            int i = 0;
            while (i < this.neighbours.size()) {
                this.shorterFrontier.add(new Integer(this.neighbours.get(i).getToNode()));
                ++i;
            }
            this.mergeWithFrontier(this.neighbours);
            this.neighbours.clear();
            this.paintNodes(this.frontier, 4);
        }
    }

    protected void stepTwo() {
        this.resetPrevious(this.currObject);
        if (this.frontier.size() > 0) {
            this.currObject = (SearchObject)this.frontier.get(0).clone();
            int currIndex = this.currObject.getToNode();
            DeductionNode node = (DeductionNode)this.graph.nodeFromIndex(currIndex);
            if (node.getType() != 1) {
                node.getEdgeIn().setHidden(false, this.graph.edgeDetail);
            }
            node.setIsHidden(false);
            node.setNodeAppearance(3);
            node.setSearchOrder(this.nodeCount++ + 1);
            node.setDrawOrdering(true);
            this.paintPath(this.currObject, true);
            this.checkGoal(currIndex);
            DeductionNode tmpNode = (DeductionNode)this.graph.nodeFromIndex(currIndex);
            tmpNode.setPathFound(true);
            this.frontier.remove(0);
            this.shorterFrontier.remove(new Integer(currIndex));
        } else {
            this.completed();
        }
    }

    protected void stepThree() {
        this.neighbours = new ArrayList();
        if (this.currObject != null) {
            int currIndex = this.currObject.getToNode();
            DeductionNode node = (DeductionNode)this.graph.nodeFromIndex(this.currObject.getToNode());
            ((DeductionCanvas)this.graph.canvas).centerOverNode(node);
            int numNeigh = 0;
            ArrayList<Node> children = new ArrayList<Node>(((DeductionNode)this.graph.nodeFromIndex(currIndex)).getNeighbours());
            if (children != null) {
                numNeigh = children.size();
            }
            int i = 0;
            while (i < numNeigh) {
                this.neighbours.add(new SearchObject(currIndex, children.get((int)0).index, this.currObject.getPath(), this.graph));
                children.remove(0);
                ++i;
            }
            if (this.neighbours.size() > 0) {
                this.paintNodes(this.neighbours, 5);
                this.paintPath(this.currObject, true);
            }
        }
        this.backup = new ArrayList<SearchObject>(this.frontier);
        this.mergeWithFrontier(this.neighbours);
    }

    protected void checkGoal(int currIndex) {
        if (((DeductionNode)this.graph.nodeFromIndex(currIndex)).getType() == 2) {
            this.goalReached = true;
            this.graph.repaint();
            this.graph.setPromptSticky(true);
            this.graph.setPromptLabel(" Goal node reached!  \nClick again to find next goal node or Reset Query to start query over.");
            this.graph.showMessage("Goal Node Reached", this.getPathString(this.currObject));
        }
    }

    protected void completed() {
        if (this.currObject != null) {
            this.paintPath(this.currObject, false);
            this.currObject = null;
        }
        int i = 0;
        while (i < this.graph.numNodes()) {
            DeductionNode tmpNode = (DeductionNode)this.graph.nodeAt(i);
            tmpNode.setNodeAppearance(6);
            this.graph.setPromptSticky(true);
            this.graph.setPromptLabel(" Search Completed.\nClick on the Reset Search button to reset the graph.");
            ++i;
        }
    }

    public void paintNodes(ArrayList f, int what) {
        int i = 0;
        while (i < f.size()) {
            int index = ((SearchObject)f.get(i)).getToNode();
            ((DeductionNode)this.graph.nodeFromIndex(index)).setNodeAppearance(what);
            ++i;
        }
    }

    protected void paintPath(SearchObject so, boolean currPath) {
        if (so == null) {
            return;
        }
        ArrayList<Integer[]> path = new ArrayList<Integer[]>(so.getPath());
        int max = path.size();
        int i = 0;
        while (i < max) {
            DeductionEdge edge;
            Integer[] edgeNode = path.get(0);
            path.remove(0);
            if (edgeNode[0] != -1 && (edge = (DeductionEdge)this.graph.getEdge(edgeNode[0], edgeNode[1])) != null) {
                if (currPath) {
                    edge.xw = 2;
                    edge.color = Color.red;
                } else {
                    edge.xw = 0;
                    edge.color = Color.black;
                }
            }
            ++i;
        }
    }

    public String getPathString(SearchObject currObj) {
        if (currObj != null) {
            String tmpLabel;
            DeductionNode tmpNode;
            ArrayList<Integer[]> path = currObj.getPath();
            this.pathString = new StringBuffer();
            int i = 0;
            while (i < path.size()) {
                if (path.get(i)[0] != -1) {
                    tmpNode = (DeductionNode)this.graph.nodeFromIndex(path.get(i)[0]);
                    tmpLabel = tmpNode.getFullLabel();
                    if (tmpLabel.equals("")) {
                        tmpLabel = new String("Node " + tmpNode.index);
                    }
                    this.pathString.append(tmpLabel).append(" \n");
                }
                ++i;
            }
            tmpNode = (DeductionNode)this.graph.nodeFromIndex(path.get(path.size() - 1)[1]);
            tmpLabel = tmpNode.getFullLabel();
            if (tmpLabel.equals("")) {
                tmpLabel = new String("Node " + tmpNode.getIndex());
            }
            if (this.goalNodeIndex.contains(tmpNode)) {
                tmpLabel = String.valueOf(tmpLabel) + " (Goal)";
            }
            this.pathString.append(tmpLabel);
        }
        return this.pathString.toString();
    }

    protected void resetPrevious(SearchObject tmpcurrObject) {
        if (tmpcurrObject != null) {
            int currIndex = tmpcurrObject.getToNode();
            if (this.shorterFrontier.contains(new Integer(currIndex))) {
                ((DeductionNode)this.graph.nodeFromIndex(currIndex)).setNodeAppearance(4);
                return;
            }
            ((DeductionNode)this.graph.nodeFromIndex(currIndex)).setNodeAppearance(6);
        } else {
            int index = this.startNodes.get(0).getIndex();
            if (this.shorterFrontier.contains(new Integer(index))) {
                return;
            }
            ((DeductionNode)this.graph.nodeFromIndex(index)).setNodeAppearance(6);
        }
    }

    protected void resetEdges() {
        Iterator<Edge> itr = this.graph.getEdges();
        while (itr.hasNext()) {
            DeductionEdge edge = (DeductionEdge)itr.next();
            edge.xw = 0;
            edge.color = Color.black;
        }
    }

    protected void resetNodes() {
        int i = 0;
        while (i < this.graph.numNodes()) {
            DeductionNode tmpNode = (DeductionNode)this.graph.nodeAt(i);
            if (tmpNode.getDrawOrdering()) {
                tmpNode.setNodeAppearance(6);
            }
            ++i;
        }
    }

    protected void clearOrdering() {
        int i = 0;
        while (i < this.graph.numNodes()) {
            DeductionNode tmpNode = (DeductionNode)this.graph.nodeAt(i);
            if (tmpNode.getDrawOrdering()) {
                tmpNode.resetSearchOrder();
            }
            ++i;
        }
    }

    public ArrayList getFrontier() {
        return this.frontier;
    }

    public ArrayList getNeighbours() {
        return this.neighbours;
    }

    public boolean getAnswerCorrect() {
        return this.answerCorrect;
    }

    protected abstract void mergeWithFrontier(ArrayList<SearchObject> var1);
}

