/*
 * Decompiled with CFR 0.152.
 */
package AIspace.deduction.searchTypes;

import AIspace.deduction.DeductionGraph;
import java.util.ArrayList;

public class SearchObject
implements Cloneable {
    protected DeductionGraph graph;
    protected Integer[] edgeNodes;
    protected ArrayList<Integer[]> path;

    public SearchObject() {
        this.graph = null;
        this.edgeNodes = new Integer[2];
        this.edgeNodes[0] = new Integer(-1);
        this.edgeNodes[1] = new Integer(-1);
        this.path = new ArrayList();
    }

    public SearchObject(int from, int to, ArrayList<Integer[]> prev, DeductionGraph g) {
        this.graph = g;
        this.edgeNodes = new Integer[2];
        this.edgeNodes[0] = new Integer(from);
        this.edgeNodes[1] = new Integer(to);
        this.path = prev != null ? new ArrayList<Integer[]>(prev) : new ArrayList();
        this.path.add(this.edgeNodes);
    }

    public int getFromNode() {
        return this.edgeNodes[0];
    }

    public void setFromNode(int from) {
        this.edgeNodes[0] = new Integer(from);
    }

    public int getToNode() {
        return this.edgeNodes[1];
    }

    public void setToNode(int to) {
        this.edgeNodes[1] = new Integer(to);
    }

    public ArrayList<Integer[]> getPath() {
        return this.path;
    }

    public boolean checkNodeOnPath(int next) {
        int i = 0;
        while (i < this.path.size()) {
            if (this.path.get(i)[0] == next) {
                return true;
            }
            ++i;
        }
        return this.path.get(this.path.size() - 1)[1] == next;
    }

    public Object clone() {
        SearchObject copy = new SearchObject();
        copy.edgeNodes[0] = this.edgeNodes[0];
        copy.edgeNodes[1] = this.edgeNodes[1];
        copy.path = new ArrayList<Integer[]>(this.path);
        return copy;
    }
}

