/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit.dialogs;

import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.dialogs.MessageDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ProblemDialog
extends BasicDialog
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    protected GraphWindow window;
    protected LinkedHashMap<String, String> problemNameToFileName;
    protected LinkedHashMap<String, String> sampleProblemDescription;
    protected JList list;
    protected boolean errorOccurredOnLoad = false;
    protected String myDesc;
    protected boolean longDesc = false;
    protected MessageDialog md;
    protected BufferedReader in;

    public ProblemDialog(GraphWindow window) {
        super((JFrame)window, "Load Sample Problem", true);
        super.setOKString("Load");
        this.window = window;
        this.getContentPane().add((Component)this.constructTopPanel(), "North");
        this.getContentPane().add((Component)this.constructCenterPanel(), "Center");
        this.getContentPane().add((Component)this.constructBottomPanel(), "South");
        this.pack();
        this.setPreferredSize(new Dimension(400, 600));
        this.centerWindow();
    }

    public void open() {
        if (!this.errorOccurredOnLoad) {
            this.setVisible(true);
        }
    }

    protected JPanel constructTopPanel() {
        JPanel top = new JPanel();
        top.add((Component)new JLabel("Select a sample problem"), "Center");
        return top;
    }

    protected JPanel constructCenterPanel() {
        this.problemNameToFileName = new LinkedHashMap();
        this.sampleProblemDescription = new LinkedHashMap();
        JPanel middle = new JPanel();
        this.displayList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        this.list.setLayoutOrientation(0);
        this.list.setSelectedIndex(0);
        JScrollPane sPane = new JScrollPane(this.list);
        sPane.setPreferredSize(new Dimension(250, 200));
        sPane.setHorizontalScrollBarPolicy(31);
        middle.add((Component)sPane, "Center");
        return middle;
    }

    protected JPanel constructBottomPanel() {
        JPanel bottom = new JPanel();
        JButton button = new JButton("Load");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        bottom.add(button);
        button = new JButton("Cancel");
        button.setActionCommand(button.getText());
        button.addActionListener(this);
        bottom.add(button);
        return bottom;
    }

    protected boolean getProblemList() {
        try {
            String text;
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/SampleProblems.txt")));
            while ((text = in.readLine()) != null) {
                if ((text = text.trim()).length() <= 0 || text.substring(0, 2).equals("//")) continue;
                int p1 = text.indexOf(",");
                int p2 = text.indexOf(",", p1 + 1);
                this.problemNameToFileName.put(text.substring(0, p1), text.substring(p1 + 1, p2).trim());
                if (text.endsWith(".")) {
                    this.sampleProblemDescription.put(text.substring(0, p1), text.substring(p2 + 1, text.length()).trim());
                    continue;
                }
                this.sampleProblemDescription.put(text.substring(0, p1), "");
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.window.showMessage("Error", "Error loading problem list: " + e.getLocalizedMessage() + ".");
            return false;
        }
    }

    protected void displayList() {
        if (!this.getProblemList()) {
            this.errorOccurredOnLoad = true;
            return;
        }
        Object[] fileNameList = new String[this.problemNameToFileName.size()];
        Iterator<String> itr = this.problemNameToFileName.keySet().iterator();
        int i = 0;
        while (i < this.problemNameToFileName.size()) {
            fileNameList[i] = itr.next();
            ++i;
        }
        this.list = new JList(fileNameList){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                int index = ProblemDialog.this.list.locationToIndex(e.getPoint());
                Object item = this.getModel().getElementAt(index);
                Iterator<String> itr = ProblemDialog.this.sampleProblemDescription.keySet().iterator();
                String desc = null;
                while (itr.hasNext()) {
                    String cur = itr.next();
                    if (!cur.equalsIgnoreCase(item.toString())) continue;
                    desc = ProblemDialog.this.formatString(ProblemDialog.this.sampleProblemDescription.get(cur));
                    desc = "<html>" + desc.replaceAll("\r\n|\n|\r", "<br>") + "</html>";
                    break;
                }
                return desc;
            }
        };
    }

    protected void loadProblem() {
        if (this.list.getSelectedValue() != null) {
            this.window.setFileName(this.problemNameToFileName.get(this.list.getSelectedValue()));
            this.window.load(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/saves/" + this.problemNameToFileName.get(this.list.getSelectedValue())))));
        } else {
            this.window.showMessage("Error", "Error loading file.");
        }
    }

    protected String formatString(String s) {
        String formatedDesc = new String();
        int size = 50;
        if (s.length() >= size) {
            String tmp = s;
            int num = s.length() / size;
            int p2 = 0;
            while (num >= 0 && !tmp.equals("")) {
                p2 = tmp.indexOf(" ", size);
                if (tmp.length() <= size || p2 < 0) {
                    p2 = tmp.length() - 1;
                }
                formatedDesc = formatedDesc.concat(tmp.substring(0, p2).trim());
                if (!(tmp = tmp.substring(p2 + 1, tmp.length()).trim()).trim().equals("")) {
                    formatedDesc = String.valueOf(formatedDesc) + "\n";
                }
                --num;
            }
            formatedDesc = String.valueOf(formatedDesc) + ".";
        } else {
            formatedDesc = s;
        }
        return formatedDesc;
    }

    protected boolean actionOK() {
        this.loadProblem();
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }

    public void showMessage(String title, String msg) {
        this.md = new MessageDialog(this.window);
        this.md.addActionListener(this);
        this.md.open(title, msg);
    }

    public void valueChanged(ListSelectionEvent e) {
    }
}

