/*
 * Decompiled with CFR 0.152.
 */
package AIspace.prolog;

import AIspace.prolog.Functor;
import AIspace.prolog.Predicate;
import AIspace.prolog.Rule;
import AIspace.prolog.Substitution;
import AIspace.prolog.Term;
import java.util.ArrayList;

public class Goal {
    protected Term[] terms;
    protected Predicate pred;
    public boolean neg = false;
    public ArrayList substitutions;
    public ArrayList extraSubs;
    public ArrayList usedRules;
    public Rule derivedFrom;
    public boolean isLast = false;
    public boolean indent = false;

    public Goal(Predicate p) {
        this.pred = p;
        this.terms = this.makeTerms(p.getArity());
        this.usedRules = new ArrayList();
    }

    public Goal(Predicate p, Term[] newTerms) {
        this.pred = p;
        this.terms = newTerms;
        this.usedRules = new ArrayList();
    }

    public Goal(String name, Term[] newTerms) {
        this.terms = newTerms;
        this.pred = this.makePredicate(name, newTerms.length);
        this.usedRules = new ArrayList();
    }

    public Goal(int builtIn, Term[] newTerms) {
        Predicate p = this.makePredicate();
        this.pred = newTerms.length != 2 ? p.getPred(builtIn, newTerms.length) : p.getPred(builtIn);
        this.terms = newTerms;
        this.usedRules = new ArrayList();
    }

    public Goal(Goal g) {
        this.pred = g.pred;
        this.terms = this.makeTerms(this.pred.getArity());
        int i = 0;
        while (i < g.terms.length) {
            this.terms[i] = this.makeTerm(g.terms[i]);
            ++i;
        }
        this.usedRules = new ArrayList();
        this.neg = g.neg;
    }

    protected Goal makeGoal(Predicate p) {
        return new Goal(p);
    }

    protected Goal makeGoal(Predicate p, Term[] newTerms) {
        return new Goal(p, newTerms);
    }

    protected Goal makeGoal(String name, Term[] newTerms) {
        return new Goal(name, newTerms);
    }

    protected Goal makeGoal(int builtin, Term[] newTerms) {
        return new Goal(builtin, newTerms);
    }

    protected Goal makeGoal(Goal g) {
        return new Goal(g);
    }

    protected Predicate makePredicate(String name, int arity) {
        return new Predicate(name, arity);
    }

    protected Predicate makePredicate() {
        return new Predicate();
    }

    protected Term[] makeTerms(int arity) {
        return new Term[arity];
    }

    protected Term makeTerm(Term t) {
        return new Term(t);
    }

    protected Term makeTerm(Functor f, Term[] terms) {
        return new Term(f, terms);
    }

    protected Term makeTerm(String s) {
        return new Term(s);
    }

    protected Term goalToTerm() {
        if (this.pred.builtIn()) {
            return this.makeTerm(new Functor(this.pred.getType()), this.terms);
        }
        return this.makeTerm(new Functor(this.pred.getName(), this.pred.getArity()), this.terms);
    }

    public void reset() {
        this.usedRules = new ArrayList();
    }

    public void setPredicate(Predicate p) {
        this.pred = p;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    public ArrayList<Term> getVariables() {
        ArrayList<Term> vars = new ArrayList<Term>(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            ArrayList<Term> termvars = this.terms[i].getVariables();
            int j = 0;
            while (j < termvars.size()) {
                vars.add(termvars.get(j));
                ++j;
            }
            ++i;
        }
        return vars;
    }

    public ArrayList<Term> getUniqueVariables() {
        ArrayList<Term> vars = new ArrayList<Term>(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            ArrayList<Term> temp = this.terms[i].getVariables();
            int j = 0;
            while (j < temp.size()) {
                if (!vars.contains(temp.get(j))) {
                    vars.add(temp.get(j));
                }
                ++j;
            }
            ++i;
        }
        return vars;
    }

    public int putVariables(ArrayList<Term> v, int index) {
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i].getType() != 2) {
                this.terms[i] = v.get(index);
                ++index;
            } else {
                index = this.terms[i].putVariables(v, index);
            }
            ++i;
        }
        return index;
    }

    public Term[] getTerms() {
        return this.terms;
    }

    public Term[] copyTerms() {
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.makeTerm(this.terms[i]);
            ++i;
        }
        return newTerms;
    }

    public Term[] copyTerms2() {
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.makeTerm(this.terms[i]);
            newTerms[i].setUnifiedWith(this.terms[i].getUnifiedWith());
            ++i;
        }
        return newTerms;
    }

    public Goal unify(Goal g, boolean occursCheck) {
        if (!g.pred.equals(this.pred)) {
            return null;
        }
        Term[] newTerms = this.makeTerms(this.pred.getArity());
        int i = 0;
        while (i < this.terms.length) {
            Term newTerm = this.terms[i].lastUnified().unify(g.terms[i].lastUnified(), occursCheck);
            if (newTerm == null) {
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].lastUnified();
            ++i;
        }
        return this.makeGoal(this.pred, newTerms);
    }

    public boolean canunify(Goal g, boolean occursCheck) {
        if (!g.pred.equals(this.pred)) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].lastUnified().canunify(g.terms[i].lastUnified(), occursCheck)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean needsDelaying() {
        int i;
        ArrayList<Term> vars;
        if (!this.pred.builtIn()) {
            return false;
        }
        if (this.pred.getType() != 556) {
            vars = this.terms[0].getVariables();
            i = 0;
            while (i < vars.size()) {
                if (vars.get(i).getType() == 0) {
                    return true;
                }
                ++i;
            }
        }
        vars = this.terms[1].getVariables();
        i = 0;
        while (i < vars.size()) {
            if (vars.get(i).getType() == 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Goal solve() {
        if (!this.pred.builtIn()) {
            return null;
        }
        if (this.pred.getType() == 555) {
            Term t1 = this.terms[0].lastUnified();
            Term t2 = this.terms[1].lastUnified();
            if (t1.getType() == 0 || t2.getType() == 0) {
                return null;
            }
            if (!t1.equals(t2)) {
                return this;
            }
            return null;
        }
        if (this.pred.getType() == 556) {
            Term t1 = this.terms[0].lastUnified();
            Double ans = this.terms[1].solveArithmetic();
            if (ans == null) {
                return null;
            }
            Term newTerm = t1.unify(this.makeTerm(ans.toString()), true);
            if (newTerm != null) {
                Goal newGoal = this.makeGoal(this);
                newGoal.terms[0] = newTerm;
                return newGoal;
            }
            return null;
        }
        if (this.pred.getType() == 557) {
            if (this.terms[0].lastUnified().equals(this.terms[1].lastUnified())) {
                return this;
            }
            return null;
        }
        if (this.terms[0].getType() == 0 || this.terms[1].getType() == 0) {
            return this.makeGoal(this);
        }
        Double left1 = this.terms[0].solveArithmetic();
        Double right1 = this.terms[1].solveArithmetic();
        if (left1 == null || right1 == null) {
            return null;
        }
        double left = left1;
        double right = right1;
        switch (this.pred.getType()) {
            case 550: {
                if (!(left <= right)) break;
                return this;
            }
            case 551: {
                if (!(left >= right)) break;
                return this;
            }
            case 552: {
                if (!(left < right)) break;
                return this;
            }
            case 553: {
                if (!(left > right)) break;
                return this;
            }
            case 554: {
                if (left == right) break;
                return this;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Goal fixTerms() {
        ArrayList<Term> vars = this.getVariables();
        ArrayList<Term> newVars = new ArrayList<Term>(vars.size());
        int i = 0;
        while (i < vars.size()) {
            newVars.add(vars.get(i).lastUnified());
            ++i;
        }
        Goal g = this.makeGoal(this.pred, this.copyTerms());
        g.putVariables(newVars, 0);
        g.derivedFrom = this.derivedFrom;
        g.neg = this.neg;
        return g;
    }

    public Goal fixTerms2() {
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].fixTerms2();
            ++i;
        }
        Goal g = this.makeGoal(this.pred, newTerms);
        g.derivedFrom = this.derivedFrom;
        g.neg = this.neg;
        return g;
    }

    public Goal applySubs(ArrayList<Substitution> subs) {
        if (subs.size() == 0) {
            return this.makeGoal(this.pred, this.copyTerms());
        }
        ArrayList<Term> newTerms = new ArrayList<Term>(this.getVariables().size());
        ArrayList<Term> vars = this.getVariables();
        int i = 0;
        while (i < vars.size()) {
            Term t = vars.get(i);
            int j = 0;
            while (j < subs.size()) {
                Substitution s = subs.get(j);
                if (s.first.getName().equals(t.getName())) {
                    t = t.applySubs(s.second, subs);
                }
                ++j;
            }
            newTerms.add(t);
            ++i;
        }
        Goal g = this.makeGoal(this.pred, this.copyTerms());
        g.putVariables(newTerms, 0);
        g.neg = this.neg;
        return g;
    }

    public Goal applySubs2(ArrayList subs) {
        if (subs.size() == 0) {
            return this.makeGoal(this.pred, this.copyTerms());
        }
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].applySubs(subs, false);
            ++i;
        }
        Goal g = this.makeGoal(this.pred, newTerms);
        g.neg = this.neg;
        return g;
    }

    public boolean isGround() {
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void clearUnified() {
        int i = 0;
        while (i < this.terms.length) {
            this.terms[i].clearUnified();
            ++i;
        }
    }

    protected boolean equals(Goal g) {
        if (!g.pred.equals(this.pred)) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].equals(g.terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        if (this.pred.builtIn()) {
            String middle;
            switch (this.pred.getType()) {
                case 550: {
                    middle = "=<";
                    break;
                }
                case 551: {
                    middle = ">=";
                    break;
                }
                case 552: {
                    middle = "<";
                    break;
                }
                case 553: {
                    middle = ">";
                    break;
                }
                case 554: {
                    middle = "=\\=";
                    break;
                }
                case 555: {
                    middle = "\\=";
                    break;
                }
                case 556: {
                    middle = " is ";
                    break;
                }
                case 557: {
                    middle = "=";
                    break;
                }
                default: {
                    middle = "";
                }
            }
            StringBuffer str = new StringBuffer(this.terms[0].toString());
            if (this.neg) {
                str.insert(0, '~');
            }
            str.append(middle).append(this.terms[1].toString());
            return str.toString();
        }
        StringBuffer str = new StringBuffer(this.pred.getName());
        if (this.neg) {
            str.insert(0, '~');
        }
        if (this.terms.length > 0) {
            str.append("(").append(this.terms[0].toString());
            int i = 1;
            while (i < this.terms.length) {
                str.append(", ").append(this.terms[i].toString());
                ++i;
            }
            str.append(")");
        }
        return str.toString();
    }

    public String printString() {
        if (this.pred.builtIn()) {
            String middle;
            switch (this.pred.getType()) {
                case 550: {
                    middle = "=<";
                    break;
                }
                case 551: {
                    middle = ">=";
                    break;
                }
                case 552: {
                    middle = "<";
                    break;
                }
                case 553: {
                    middle = ">";
                    break;
                }
                case 554: {
                    middle = "=\\=";
                    break;
                }
                case 555: {
                    middle = "\\=";
                    break;
                }
                case 556: {
                    middle = " is ";
                    break;
                }
                case 557: {
                    middle = "=";
                    break;
                }
                default: {
                    middle = "";
                }
            }
            String str = new String(this.terms[0].printString());
            if (this.neg) {
                str = "~" + str;
            }
            str = String.valueOf(str) + middle;
            str = String.valueOf(str) + this.terms[1].printString();
            return str;
        }
        StringBuffer str = new StringBuffer(this.pred.getName());
        if (this.neg) {
            str.insert(0, '~');
        }
        if (this.terms.length > 0) {
            str.append("(");
            str.append(this.terms[0].printString());
            int i = 1;
            while (i < this.terms.length) {
                str.append(", ");
                str.append(this.terms[i].printString());
                ++i;
            }
            str.append(")");
        }
        return str.toString();
    }
}

