/*
 * Decompiled with CFR 0.152.
 */
package AIspace.prolog;

import AIspace.prolog.Functor;
import AIspace.prolog.Goal;
import AIspace.prolog.Predicate;
import AIspace.prolog.Rule;
import AIspace.prolog.Substitution;
import AIspace.prolog.Term;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Program {
    protected ArrayList<Predicate> builtin_predicates;
    protected ArrayList<Predicate> predicates = new ArrayList();
    public ArrayList usedTerms;
    public boolean occursCheck = true;
    protected ArrayList<String> kbConstants;

    public Program() {
        this.builtin_predicates = new ArrayList();
        this.usedTerms = new ArrayList();
        this.kbConstants = new ArrayList();
    }

    public void reset() {
        this.usedTerms = new ArrayList();
        this.kbConstants = new ArrayList();
        Iterator<Predicate> itr = this.predicates.iterator();
        while (itr.hasNext()) {
            itr.next().resetRules();
        }
        itr = this.builtin_predicates.iterator();
        while (itr.hasNext()) {
            itr.next().resetRules();
        }
    }

    public Predicate predContains(String name, int arity) {
        for (Predicate curPred : this.predicates) {
            if (!curPred.getName().equals(name) || curPred.getArity() != arity) continue;
            return curPred;
        }
        return null;
    }

    public Predicate builtInPredContains(String name, int arity) {
        for (Predicate curPred : this.builtin_predicates) {
            if (!curPred.getName().equals(name) || curPred.getArity() != arity) continue;
            return curPred;
        }
        return null;
    }

    public boolean repeatName(Predicate pred) {
        for (Predicate curPred : this.predicates) {
            if (curPred == pred || !curPred.getName().equals(pred.getName())) continue;
            return true;
        }
        for (Predicate curPred : this.builtin_predicates) {
            if (curPred == pred || !curPred.getName().equals(pred.getName())) continue;
            return true;
        }
        return false;
    }

    public void addPredicate(Predicate p) {
        if (!this.predicates.contains(p)) {
            this.predicates.add(p);
        }
    }

    public ArrayList<Predicate> getPredicates() {
        return new ArrayList<Predicate>(this.predicates);
    }

    public void addBuiltInPredicate(Predicate p) {
        if (!this.builtin_predicates.contains(p)) {
            this.builtin_predicates.add(p);
        }
    }

    public ArrayList getBuiltInPredicates() {
        return (ArrayList)this.builtin_predicates.clone();
    }

    public ArrayList<String> getConstants() {
        return new ArrayList<String>(this.kbConstants);
    }

    public void setOccursCheck(boolean bool) {
        this.occursCheck = bool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String parse(String text) {
        String errorMessage = new String("");
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        if (this.usedTerms == null) {
            this.usedTerms = new ArrayList();
        }
        if (this.predicates == null) {
            this.predicates = new ArrayList();
        }
        if (this.builtin_predicates == null) {
            this.builtin_predicates = new ArrayList();
        }
        int lineCount = 0;
        try {
            while (tokenizer.hasMoreTokens()) {
                String inString = tokenizer.nextToken().trim();
                if (inString.length() <= 0 || inString.charAt(0) == '%') continue;
                int commentIndex = inString.indexOf(37);
                if (commentIndex != -1) {
                    inString = inString.substring(0, commentIndex).trim();
                }
                while (inString.charAt(inString.length() - 1) != '.') {
                    if (!tokenizer.hasMoreTokens()) {
                        return "Unexpected end of file";
                    }
                    String nextString = tokenizer.nextToken().trim();
                    if (nextString.charAt(0) == '%') continue;
                    commentIndex = nextString.indexOf(37);
                    if (commentIndex != -1) {
                        nextString = nextString.substring(0, commentIndex).trim();
                    }
                    inString = String.valueOf(inString) + nextString;
                }
                errorMessage = this.parseRule(inString);
                ++lineCount;
                if (errorMessage.length() <= 0) continue;
                System.out.println(String.valueOf(errorMessage) + " at " + inString);
                return String.valueOf(errorMessage) + " at " + inString;
            }
            return errorMessage;
        }
        catch (Exception e) {
            if (errorMessage.length() > 0) {
                return "Error at line " + (lineCount + 1) + " -- " + errorMessage;
            }
            return "Error at line " + (lineCount + 1) + " -- " + e.toString();
        }
    }

    public String parseRule(String str) {
        if (!this.matchBrackets(str)) {
            return "Mismatched parentheses";
        }
        int i = str.indexOf(":-");
        if (i == -1) {
            i = str.indexOf("<-");
        }
        if (i == -1) {
            i = str.lastIndexOf(".");
        }
        if (i != -1) {
            Goal g;
            String nextGoal;
            Predicate old;
            Goal head = this.parseGoal(str.substring(0, i).trim());
            if (head == null) {
                return "Invalid rule definition";
            }
            Predicate p = head.getPredicate();
            if (!p.builtIn) {
                old = this.predContains(p.getName(), p.getArity());
                if (old != null) {
                    head.pred = old;
                } else {
                    this.predicates.add(p);
                }
            } else {
                old = this.builtInPredContains(p.getName(), p.getArity());
                if (old != null) {
                    head.pred = old;
                } else {
                    this.builtin_predicates.add(p);
                }
            }
            int end = str.lastIndexOf(".");
            i = str.indexOf("<-") + 2;
            if (i == 1) {
                i = str.indexOf(":-") + 2;
            }
            int j = str.indexOf("&");
            ArrayList<Goal> goals = new ArrayList<Goal>();
            boolean onemore = false;
            while (j != -1) {
                onemore = true;
                nextGoal = str.substring(i, j).trim();
                g = this.parseGoal(nextGoal);
                if (g == null) {
                    return "Error parsing goal";
                }
                p = g.getPredicate();
                if (!p.builtIn()) {
                    old = this.predContains(p.getName(), p.getArity());
                    if (old != null) {
                        g.pred = old;
                    } else {
                        this.predicates.add(p);
                    }
                } else {
                    old = this.builtInPredContains(p.getName(), p.getArity());
                    if (old != null) {
                        g.pred = old;
                    } else {
                        this.builtin_predicates.add(p);
                    }
                }
                goals.add(g);
                i = j + 1;
                j = str.indexOf("&", i);
            }
            if (onemore || i != 1) {
                nextGoal = str.substring(i, end).trim();
                g = this.parseGoal(nextGoal);
                if (g == null) {
                    return "Error parsing goal";
                }
                p = g.getPredicate();
                if (!p.builtIn()) {
                    old = this.predContains(p.getName(), p.getArity());
                    if (old != null) {
                        g.pred = old;
                    } else {
                        this.predicates.add(p);
                    }
                } else {
                    old = this.builtInPredContains(p.getName(), p.getArity());
                    if (old != null) {
                        g.pred = old;
                    } else {
                        this.builtin_predicates.add(p);
                    }
                }
                goals.add(g);
            }
            head.getPredicate().addRule(this.makeRule(head, goals));
            return "";
        }
        return "Missing period";
    }

    protected Rule makeRule(Goal head, ArrayList goals) {
        return new Rule(head, goals);
    }

    protected Goal makeGoal(Predicate p) {
        return new Goal(p);
    }

    protected Goal makeGoal(String name, Term[] newTerms) {
        return new Goal(name, newTerms);
    }

    protected Goal makeGoal(int builtin, Term[] newTerms) {
        return new Goal(builtin, newTerms);
    }

    protected Goal makeGoal(Goal g) {
        return new Goal(g);
    }

    protected Term makeTerm(String str) {
        return new Term(str);
    }

    protected Term makeTerm(Functor f, Term[] newTerms) {
        return new Term(f, newTerms);
    }

    protected Term makeTerm(Term t) {
        return new Term(t);
    }

    protected Term[] makeTerms(int arity) {
        return new Term[arity];
    }

    protected ArrayList parseList(String str) {
        if (str.substring(1, str.length()).trim().equals("")) {
            return new ArrayList();
        }
        int nextComma = str.indexOf(",");
        ArrayList<Goal> v = new ArrayList<Goal>();
        int last = 1;
        while (nextComma != -1) {
            Predicate old;
            int compound = str.indexOf("(");
            int builtIn = str.indexOf("=");
            int nextLeft = 0;
            if (builtIn == -1 || compound < builtIn && compound != -1) {
                nextLeft = this.findNextRight(compound, str) + 1;
            } else if (compound == -1 || builtIn < compound && builtIn != -1) {
                nextLeft = nextComma;
            }
            if (nextLeft <= 0) {
                return null;
            }
            Goal g = this.parseGoal(str.substring(last, nextLeft));
            if (g == null) {
                return null;
            }
            Predicate p = g.getPredicate();
            if (!p.builtIn()) {
                old = this.predContains(p.getName(), p.getArity());
                if (old != null) {
                    g.pred = old;
                } else {
                    this.predicates.add(p);
                }
            } else {
                old = this.builtInPredContains(p.getName(), p.getArity());
                if (old != null) {
                    g.pred = old;
                } else {
                    this.builtin_predicates.add(p);
                }
            }
            v.add(g);
            last = nextLeft + 1;
            nextComma = str.indexOf(",", last);
        }
        Goal g = this.parseGoal(str.substring(last, str.length() - 1));
        if (g == null) {
            return null;
        }
        Predicate p = g.getPredicate();
        if (!p.builtIn()) {
            Predicate old = this.predContains(p.getName(), p.getArity());
            if (old != null) {
                g.pred = old;
            } else {
                this.predicates.add(p);
            }
        } else {
            Predicate old = this.builtInPredContains(p.getName(), p.getArity());
            if (old != null) {
                g.pred = old;
            } else {
                this.builtin_predicates.add(p);
            }
        }
        v.add(g);
        return v;
    }

    public Goal parseGoal(String str) {
        Goal g;
        if (!this.matchBrackets(str)) {
            return null;
        }
        boolean neg = false;
        if (str.startsWith("~")) {
            neg = true;
            str = str.substring(1).trim();
        }
        if ((g = this.parseBuiltInGoal(str)) != null) {
            g.neg = neg;
            return g;
        }
        return this.parseNonBuiltInGoal(str, neg);
    }

    protected Goal parseNonBuiltInGoal(String str, boolean neg) {
        int next;
        int i = str.indexOf("(");
        if (i == -1) {
            Goal g = this.makeGoal(str, this.makeTerms(0));
            g.neg = neg;
            return g;
        }
        String name = str.substring(0, i).trim();
        int compound = str.indexOf("(", i + 1);
        int compound2 = str.indexOf("[", i + 1);
        int j = str.indexOf(",");
        int end = str.length() - 1;
        if (end == -1) {
            return null;
        }
        if (compound > -1 && compound < j && (compound2 == -1 || compound < compound2)) {
            next = this.findNextRight(compound, str);
            if (next == -1) {
                return null;
            }
            j = next + 1;
        } else if (compound2 > -1 && compound2 < j) {
            next = this.findNextRightSquare(compound2, str);
            if (next == -1) {
                return null;
            }
            j = next + 1;
        }
        ArrayList<Term> terms = new ArrayList<Term>();
        ++i;
        while (j > 0) {
            String nextTerm = str.substring(i, j).trim();
            if (!this.matchBrackets(nextTerm)) {
                return null;
            }
            i = j + 1;
            terms.add(this.makeTerm(nextTerm));
            compound = str.indexOf("(", j);
            compound2 = str.indexOf("[", j);
            int nextComma = str.indexOf(",", i);
            j = compound != -1 && compound < nextComma && (compound2 == -1 || compound < compound2) ? this.findNextRight(compound, str) + 1 : (compound2 > -1 && compound2 < nextComma ? this.findNextRightSquare(compound2, str) + 1 : str.indexOf(",", i));
        }
        if (i < end) {
            if (!this.matchBrackets(str.substring(i, end).trim())) {
                return null;
            }
            terms.add(this.makeTerm(str.substring(i, end).trim()));
        }
        Term[] newTerms = this.makeTerms(terms.size());
        int ind = 0;
        while (ind < terms.size()) {
            newTerms[ind] = (Term)terms.get(ind);
            if (newTerms[ind].getType() == 1 && !this.kbConstants.contains(newTerms[ind].getName())) {
                this.kbConstants.add(newTerms[ind].getName());
            }
            ++ind;
        }
        Goal g = this.makeGoal(name, newTerms);
        g.neg = neg;
        return g;
    }

    protected Goal parseBuiltInGoal(String str) {
        int endIndex;
        int index;
        int type;
        if (!this.matchBrackets(str)) {
            return null;
        }
        if (str.indexOf("=<") != -1) {
            type = 550;
            index = str.indexOf("=<");
            endIndex = index + 1;
        } else if (str.indexOf(">=") != -1) {
            type = 551;
            index = str.indexOf(">=");
            endIndex = index + 1;
        } else if (str.indexOf("<") != -1) {
            type = 552;
            endIndex = index = str.indexOf("<");
        } else if (str.indexOf(">") != -1) {
            type = 553;
            endIndex = index = str.indexOf(">");
        } else if (str.indexOf("=\\=") != -1) {
            type = 554;
            index = str.indexOf("=\\=");
            endIndex = index + 2;
        } else {
            if (str.indexOf("\\=") != -1) {
                int type2 = 555;
                int index2 = str.indexOf("\\=");
                int endIndex2 = index2 + 1;
                String first = str.substring(0, index2).trim();
                if (!this.matchBrackets(first)) {
                    return null;
                }
                Term firstTerm = this.makeTerm(first);
                if (firstTerm.getType() == 2) {
                    return null;
                }
                String second = str.substring(endIndex2 + 1).trim();
                if (!this.matchBrackets(second)) {
                    return null;
                }
                Term secondTerm = this.makeTerm(second);
                if (secondTerm.getType() == 2) {
                    return null;
                }
                Term[] terms = this.makeTerms(2);
                terms[0] = firstTerm;
                terms[1] = secondTerm;
                return this.makeGoal(type2, terms);
            }
            if (str.indexOf("=") != -1) {
                type = 557;
                endIndex = index = str.indexOf("=");
            } else {
                if (str.indexOf(" is ") != -1) {
                    int type3 = 556;
                    int index3 = str.indexOf(" is ");
                    int endIndex3 = index3 + 2;
                    String first = str.substring(0, index3).trim();
                    if (!this.matchBrackets(first)) {
                        return null;
                    }
                    Term firstTerm = this.makeTerm(first);
                    if (firstTerm.getType() == 2) {
                        return null;
                    }
                    String second = str.substring(endIndex3 + 1).trim();
                    if (!this.matchBrackets(second)) {
                        return null;
                    }
                    Term secondTerm = this.parseArithmetic(second);
                    if (secondTerm == null) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(2);
                    terms[0] = firstTerm;
                    terms[1] = secondTerm;
                    return this.makeGoal(type3, terms);
                }
                return null;
            }
        }
        String first = str.substring(0, index).trim();
        if (!this.matchBrackets(first)) {
            return null;
        }
        Term firstTerm = this.parseArithmetic(first);
        if (firstTerm == null) {
            return null;
        }
        String second = str.substring(endIndex + 1).trim();
        if (!this.matchBrackets(second)) {
            return null;
        }
        Term secondTerm = this.parseArithmetic(second);
        Term[] terms = this.makeTerms(2);
        terms[0] = firstTerm;
        terms[1] = secondTerm;
        return this.makeGoal(type, terms);
    }

    protected Term parseArithmetic(String str) {
        int indexTimes = str.indexOf("*");
        int indexPlus = str.indexOf("+");
        int indexMinus = str.indexOf("-");
        int indexDiv = str.indexOf("/");
        int indexMod = str.indexOf(" mod ");
        int bracket = str.indexOf("(");
        if (indexTimes == -1 && indexPlus == -1 && indexMod == -1 && indexMinus == -1 && indexDiv == -1 && bracket == -1) {
            return this.makeTerm(str.trim());
        }
        if (!(bracket == -1 || bracket >= indexPlus && indexPlus != -1 || bracket >= indexTimes && indexTimes != -1 || bracket >= indexMod && indexMod != -1 || bracket >= indexMinus && indexMinus != -1 || bracket >= indexDiv && indexDiv != -1)) {
            int nextbracket = this.findNextRight(bracket, str);
            if (nextbracket == -1) {
                return null;
            }
            String afterterm = str.substring(nextbracket + 1).trim();
            if (afterterm != null && !afterterm.equals("") && !afterterm.startsWith(")")) {
                if (afterterm.startsWith("*")) {
                    int opindex = afterterm.indexOf("*");
                    String first = str.substring(0, nextbracket + 1 + opindex).trim();
                    String second = afterterm.substring(opindex + 1).trim();
                    if (!this.matchBrackets(first) || !this.matchBrackets(second)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(2);
                    terms[0] = this.parseArithmetic(first);
                    terms[1] = this.parseArithmetic(second);
                    if (terms[0] == null || terms[1] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(770), terms);
                }
                if (afterterm.startsWith("/")) {
                    int opindex = afterterm.indexOf("/");
                    String first = str.substring(0, nextbracket + 1 + opindex).trim();
                    String second = afterterm.substring(opindex + 1).trim();
                    if (!this.matchBrackets(first) || !this.matchBrackets(second)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(2);
                    terms[0] = this.parseArithmetic(first);
                    terms[1] = this.parseArithmetic(second);
                    if (terms[0] == null || terms[1] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(775), terms);
                }
                if (afterterm.startsWith("+")) {
                    int opindex = afterterm.indexOf("+");
                    String first = str.substring(0, nextbracket + 1 + opindex).trim();
                    String second = afterterm.substring(opindex + 1).trim();
                    if (!this.matchBrackets(first) || !this.matchBrackets(second)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(2);
                    terms[0] = this.parseArithmetic(first);
                    terms[1] = this.parseArithmetic(second);
                    if (terms[0] == null || terms[1] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(771), terms);
                }
                if (afterterm.startsWith("-")) {
                    int opindex = afterterm.indexOf("-");
                    String first = str.substring(0, nextbracket + 1 + opindex).trim();
                    String second = afterterm.substring(opindex + 1).trim();
                    if (!this.matchBrackets(first) || !this.matchBrackets(second)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(2);
                    terms[0] = this.parseArithmetic(first);
                    terms[1] = this.parseArithmetic(second);
                    if (terms[0] == null || terms[1] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(774), terms);
                }
                if (afterterm.startsWith("mod")) {
                    int opindex = afterterm.indexOf("mod");
                    String first = str.substring(0, nextbracket + 1 + opindex).trim();
                    String second = afterterm.substring(opindex + 4).trim();
                    if (!this.matchBrackets(first) || !this.matchBrackets(second)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(2);
                    terms[0] = this.parseArithmetic(first);
                    terms[1] = this.parseArithmetic(second);
                    if (terms[0] == null || terms[1] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(773), terms);
                }
                return null;
            }
            String functionName = str.substring(0, bracket).trim();
            if (!functionName.equals("")) {
                if (functionName.equals("acos")) {
                    String parameter = str.substring(bracket + 1, nextbracket);
                    if (!this.matchBrackets(parameter)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(1);
                    terms[0] = this.parseArithmetic(parameter);
                    if (terms[0] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(776), terms);
                }
                if (functionName.equals("cos")) {
                    String parameter = str.substring(bracket + 1, nextbracket);
                    if (!this.matchBrackets(parameter)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(1);
                    terms[0] = this.parseArithmetic(parameter);
                    if (terms[0] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(780), terms);
                }
                if (functionName.equals("sin")) {
                    String parameter = str.substring(bracket + 1, nextbracket);
                    if (!this.matchBrackets(parameter)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(1);
                    terms[0] = this.parseArithmetic(parameter);
                    if (terms[0] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(781), terms);
                }
                if (functionName.equals("abs")) {
                    String parameter = str.substring(bracket + 1, nextbracket);
                    if (!this.matchBrackets(parameter)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(1);
                    terms[0] = this.parseArithmetic(parameter);
                    if (terms[0] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(779), terms);
                }
                if (functionName.equals("sqrt")) {
                    String parameter = str.substring(bracket + 1, nextbracket);
                    if (!this.matchBrackets(parameter)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(1);
                    terms[0] = this.parseArithmetic(parameter);
                    if (terms[0] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(777), terms);
                }
                if (functionName.equals("square")) {
                    String parameter = str.substring(bracket + 1, nextbracket);
                    if (!this.matchBrackets(parameter)) {
                        return null;
                    }
                    Term[] terms = this.makeTerms(1);
                    terms[0] = this.parseArithmetic(parameter);
                    if (terms[0] == null) {
                        return null;
                    }
                    return this.makeTerm(new Functor(778), terms);
                }
                return null;
            }
            int nextRight = this.findNextRight(bracket, str);
            if (nextRight == -1) {
                return null;
            }
            String first = str.substring(bracket + 1, nextRight);
            String second = str.substring(nextRight + 1);
            if (!this.matchBrackets(first) || !this.matchBrackets(second)) {
                return null;
            }
            Term t = this.parseArithmetic(first);
            if (second.trim().equals("")) {
                return t;
            }
            Term t1 = this.parseArithmetic("0" + second);
            if (t == null || t1 == null) {
                return null;
            }
            t1.getTerms()[0] = t;
            return t1;
        }
        if (indexPlus != -1 && this.matchBrackets(str.substring(0, indexPlus).trim()) && this.matchBrackets(str.substring(indexPlus + 1).trim())) {
            String first = str.substring(0, indexPlus).trim();
            String second = str.substring(indexPlus + 1).trim();
            Term[] terms = this.makeTerms(2);
            terms[0] = this.parseArithmetic(first);
            terms[1] = this.parseArithmetic(second);
            if (terms[0] == null || terms[1] == null) {
                return null;
            }
            return this.makeTerm(new Functor(771), terms);
        }
        if (indexMinus != -1 && this.matchBrackets(str.substring(0, indexMinus).trim()) && this.matchBrackets(str.substring(indexMinus + 1).trim())) {
            String first = str.substring(0, indexMinus).trim();
            String second = str.substring(indexMinus + 1).trim();
            Term[] terms = this.makeTerms(2);
            if (first.equals("")) {
                first = "0";
            }
            terms[0] = this.parseArithmetic(first);
            terms[1] = this.parseArithmetic(second);
            if (terms[0] == null || terms[1] == null) {
                return null;
            }
            return this.makeTerm(new Functor(774), terms);
        }
        if (indexMod != -1 && this.matchBrackets(str.substring(0, indexMod).trim()) && this.matchBrackets(str.substring(indexMod + 4).trim())) {
            String first = str.substring(0, indexMod).trim();
            String second = str.substring(indexMod + 4).trim();
            Term[] terms = this.makeTerms(2);
            terms[0] = this.parseArithmetic(first);
            terms[1] = this.parseArithmetic(second);
            if (terms[0] == null || terms[1] == null) {
                return null;
            }
            return this.makeTerm(new Functor(773), terms);
        }
        if (indexTimes != -1 && this.matchBrackets(str.substring(0, indexTimes).trim()) && this.matchBrackets(str.substring(indexTimes + 1).trim())) {
            String first = str.substring(0, indexTimes).trim();
            String second = str.substring(indexTimes + 1).trim();
            Term[] terms = this.makeTerms(2);
            terms[0] = this.parseArithmetic(first);
            terms[1] = this.parseArithmetic(second);
            if (terms[0] == null || terms[1] == null) {
                return null;
            }
            return this.makeTerm(new Functor(770), terms);
        }
        if (indexDiv != -1 && this.matchBrackets(str.substring(0, indexDiv).trim()) && this.matchBrackets(str.substring(indexDiv + 1).trim())) {
            String first = str.substring(0, indexDiv).trim();
            String second = str.substring(indexDiv + 1).trim();
            Term[] terms = this.makeTerms(2);
            terms[0] = this.parseArithmetic(first);
            terms[1] = this.parseArithmetic(second);
            if (terms[0] == null || terms[1] == null) {
                return null;
            }
            return this.makeTerm(new Functor(775), terms);
        }
        return null;
    }

    public boolean matchBrackets(String str) {
        int count = 0;
        int count2 = 0;
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '(': {
                    ++count;
                    break;
                }
                case ')': {
                    --count;
                    break;
                }
                case '[': {
                    ++count2;
                    break;
                }
                case ']': {
                    --count2;
                }
            }
            if (count < 0 || count2 < 0) {
                return false;
            }
            ++i;
        }
        return count == 0 && count2 == 0;
    }

    public String textRep() {
        StringBuffer text = new StringBuffer();
        Iterator<Predicate> predItr = this.predicates.iterator();
        while (predItr.hasNext()) {
            for (Rule curRule : predItr.next().getRules()) {
                text.append(curRule.head.toString());
                if (curRule.body.size() > 0) {
                    Iterator<Goal> goalItr = curRule.body.iterator();
                    text.append(" <- ").append(goalItr.next().toString());
                    while (goalItr.hasNext()) {
                        text.append(" & ").append(goalItr.next().toString());
                    }
                }
                text.append(".\n");
            }
        }
        return text.toString();
    }

    public void setGoals(ArrayList theGoals) {
        if (theGoals.size() == 0) {
            return;
        }
        ArrayList<Term> terms = new ArrayList<Term>(theGoals.size() * 3);
        int i = 0;
        while (i < theGoals.size()) {
            Predicate old;
            Goal g = (Goal)theGoals.get(i);
            Predicate p = g.getPredicate();
            if (!p.builtIn()) {
                old = this.predContains(p.getName(), p.getArity());
                if (old != null) {
                    g.pred = old;
                } else {
                    this.predicates.add(p);
                }
            } else {
                old = this.builtInPredContains(p.getName(), p.getArity());
                if (old != null) {
                    g.pred = old;
                } else {
                    this.builtin_predicates.add(p);
                }
            }
            this.append(terms, g.getVariables());
            ++i;
        }
        i = 0;
        while (i < terms.size()) {
            Term t = (Term)terms.get(i);
            if (!this.usedTerms.contains(t.getName())) {
                this.usedTerms.add(t.getName());
            }
            int j = 0;
            while (j < terms.size()) {
                Term t1 = terms.get(j);
                if (t1 != t && t1.getName().equals(t.getName())) {
                    terms.set(i, t1);
                }
                ++j;
            }
            ++i;
        }
        int index = ((Goal)theGoals.get(0)).putVariables(terms, 0);
        int i2 = 1;
        while (i2 < theGoals.size()) {
            index = ((Goal)theGoals.get(i2)).putVariables(terms, index);
            ++i2;
        }
    }

    public ArrayList getRules(Goal g, boolean all) {
        Predicate old = this.predContains(g.pred.getName(), g.pred.getArity());
        if (old == null) {
            return new ArrayList();
        }
        g.pred = old;
        if (g.pred.builtIn() || g.neg) {
            return new ArrayList();
        }
        ArrayList<Rule> rules = new ArrayList<Rule>(g.pred.getRules().size());
        if (all) {
            int i = 0;
            while (i < g.pred.getRules().size()) {
                if (!g.usedRules.contains(g.pred.getRules().get(i))) {
                    rules.add(g.pred.getRules().get(i));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < g.pred.getRules().size()) {
                if (!g.usedRules.contains(g.pred.getRules().get(i))) {
                    Rule r = g.pred.getRules().get(i);
                    g.clearUnified();
                    r.head.clearUnified();
                    if (g.unify(r.head, this.occursCheck) != null) {
                        rules.add(r);
                    }
                    r.head.clearUnified();
                    g.clearUnified();
                }
                ++i;
            }
        }
        return rules;
    }

    public void printQuery(ArrayList<Goal> goals) {
        ArrayList<Term> originalTerms = new ArrayList<Term>(goals.size());
        int i = 0;
        while (i < goals.size()) {
            originalTerms.addAll(goals.get(i).getVariables());
            ++i;
        }
        ArrayList printTerms = new ArrayList(originalTerms.size());
        int i2 = 0;
        while (i2 < originalTerms.size()) {
            if (!printTerms.contains(originalTerms.get(i2))) {
                printTerms.add(originalTerms.get(i2));
            }
            ++i2;
        }
        if (this.queryList(goals, 50)) {
            System.out.println("true");
            i2 = 0;
            while (i2 < printTerms.size()) {
                Term t = (Term)printTerms.get(i2);
                if (t.getType() == 0) {
                    System.out.println(String.valueOf(t.toString()) + " = " + t.fixTerms2());
                }
                ++i2;
            }
        } else {
            System.out.println("false");
        }
    }

    protected void clearGoals(ArrayList goals) {
        int i = 0;
        while (i < goals.size()) {
            ((Goal)goals.get(i)).clearUnified();
            ++i;
        }
    }

    public ArrayList<Goal> solveGoal(Goal g, ArrayList<Goal> goals) {
        if (!g.getPredicate().builtIn()) {
            return null;
        }
        this.clearGoals(goals);
        Goal solved = g.solve();
        if (solved != null) {
            ArrayList<Goal> resolvent = new ArrayList<Goal>(goals.size() - 1);
            if (g.getPredicate().getType() == 556) {
                int i = 0;
                while (i < goals.size()) {
                    Goal g1 = goals.get(i);
                    if (g1 != null && g1 != g) {
                        resolvent.add(g1.fixTerms2());
                    }
                    ++i;
                }
                ArrayList<Term> vars = g.getUniqueVariables();
                ArrayList<Substitution> subs = new ArrayList<Substitution>();
                int j = 0;
                while (j < vars.size()) {
                    Term t = vars.get(j);
                    if (t.getType() == 0 && t.lastUnified() != null && !t.getName().equals(t.lastUnified().getName())) {
                        subs.add(new Substitution(t, t.lastUnified()));
                    }
                    ++j;
                }
                g.substitutions = subs;
                g.extraSubs = new ArrayList();
            } else {
                int i = 0;
                while (i < goals.size()) {
                    Goal g1 = goals.get(i);
                    if (g1 != null && g1 != g) {
                        resolvent.add(g1);
                    }
                    ++i;
                }
                g.substitutions = new ArrayList();
                g.extraSubs = new ArrayList();
            }
            g.derivedFrom = this.makeRule(g, new ArrayList());
            return resolvent;
        }
        return null;
    }

    public ArrayList<Goal> applyRule(Rule r, Goal g, ArrayList<Goal> goals) {
        g.usedRules.add(r);
        ArrayList<Term> allVars = this.getUniqueVariables(goals);
        int i = 0;
        while (i < allVars.size()) {
            Term t = allVars.get(i);
            t.clearUnified();
            if (!this.usedTerms.contains(t.getName())) {
                this.usedTerms.add(t.getName());
            }
            ++i;
        }
        Rule r1 = r.rename(this.usedTerms);
        Goal unified = g.unify(r1.ruleHead(), this.occursCheck);
        if (unified != null) {
            ++r.varCounter;
            ArrayList<Goal> resolvent = new ArrayList<Goal>(goals.size());
            int j = 0;
            while (j < goals.size()) {
                if (goals.get(j) != null && !resolvent.contains(goals.get(j))) {
                    resolvent.add(goals.get(j));
                }
                ++j;
            }
            int index = resolvent.indexOf(g);
            resolvent.remove(g);
            ArrayList newGoals = r1.applyUnification();
            this.insertAt(resolvent, newGoals, index);
            int j2 = 0;
            while (j2 < resolvent.size()) {
                resolvent.set(j2, ((Goal)resolvent.get(j2)).fixTerms2());
                ++j2;
            }
            ArrayList<Term> vars = g.getUniqueVariables();
            ArrayList<Substitution> subs = new ArrayList<Substitution>();
            int j3 = 0;
            while (j3 < vars.size()) {
                Term t = vars.get(j3);
                if (t.getType() == 0 && t.lastUnified() != null && !t.getName().equals(t.lastUnified().getName())) {
                    subs.add(new Substitution(t, t.lastUnified()));
                }
                ++j3;
            }
            ArrayList<Substitution> extraSubs = new ArrayList<Substitution>();
            vars = r1.ruleHead().getUniqueVariables();
            int j4 = 0;
            while (j4 < vars.size()) {
                Term t = vars.get(j4);
                if (t.getType() == 0 && t.lastUnified() != null && !t.getName().equals(t.lastUnified().getName())) {
                    extraSubs.add(new Substitution(t, t.lastUnified()));
                }
                ++j4;
            }
            g.extraSubs = extraSubs;
            g.substitutions = subs;
            g.derivedFrom = r1;
            return resolvent;
        }
        g.clearUnified();
        return null;
    }

    public ArrayList applyRuleShort(Rule r, Goal g, ArrayList subs) {
        g.clearUnified();
        r.clearUnified();
        g.unify(r.head, this.occursCheck);
        ArrayList newGoals = r.applyUnification();
        int i = 0;
        while (i < newGoals.size()) {
            newGoals.set(i, ((Goal)newGoals.get(i)).applySubs2(subs));
            ++i;
        }
        return newGoals;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ArrayList pruneFacts(ArrayList goals) {
        ArrayList<Goal> newGoals = new ArrayList<Goal>(goals.size());
        int i = 0;
        while (i < goals.size()) {
            Goal g = (Goal)goals.get(i);
            if (g.neg) {
                ArrayList<Goal> v = new ArrayList<Goal>(1);
                v.add(g);
                if (!this.finiteFailure(g, v, 50)) {
                    if (g.isGround()) {
                        return null;
                    }
                    newGoals.add(g);
                }
            } else if (g.getPredicate().builtIn()) {
                if (g.needsDelaying()) {
                    newGoals.add(g);
                } else {
                    Goal g1;
                    Goal solved = g.solve();
                    if (solved == null) {
                        return null;
                    }
                    int j = i + 1;
                    while (j < goals.size()) {
                        g1 = (Goal)goals.get(j);
                        goals.set(j, g1.fixTerms2());
                        ++j;
                    }
                    j = 0;
                    while (j < newGoals.size()) {
                        g1 = (Goal)newGoals.get(j);
                        newGoals.set(j, g1.fixTerms2());
                        ++j;
                    }
                }
            } else {
                ArrayList rules = this.getRules(g, false);
                if (rules.size() == 0) {
                    return null;
                }
                if (rules.size() == 1) {
                    Rule r = (Rule)rules.get(0);
                    if (r.body.size() > 0) {
                        newGoals.add(g);
                    } else {
                        Goal g1;
                        g.clearUnified();
                        r.head.clearUnified();
                        if (g.unify(r.head, this.occursCheck) == null) return null;
                        int j = i + 1;
                        while (j < goals.size()) {
                            g1 = (Goal)goals.get(j);
                            goals.set(j, g1.fixTerms2());
                            ++j;
                        }
                        j = 0;
                        while (j < newGoals.size()) {
                            g1 = (Goal)newGoals.get(j);
                            newGoals.set(j, g1.fixTerms2());
                            ++j;
                        }
                    }
                } else {
                    newGoals.add(g);
                }
            }
            ++i;
        }
        return newGoals;
    }

    public boolean finiteFailure(Goal g, ArrayList goals, int numSteps) {
        if (g.needsDelaying()) {
            return false;
        }
        g.neg = false;
        if (this.notFailure(g, goals, numSteps)) {
            g.neg = true;
            return false;
        }
        g.neg = true;
        return true;
    }

    public boolean notFailure(Goal g, ArrayList goals, int numSteps) {
        if (numSteps == 0) {
            return true;
        }
        ArrayList<Term> allVars = this.getUniqueVariables(goals);
        int i = 0;
        while (i < allVars.size()) {
            Term t = allVars.get(i);
            t.clearUnified();
            if (!this.usedTerms.contains(t.getName())) {
                this.usedTerms.add(t.getName());
            }
            ++i;
        }
        if (g.neg) {
            if (this.finiteFailure(g, goals, numSteps)) {
                ArrayList resolvent = (ArrayList)goals.clone();
                resolvent.remove(g);
                return this.queryList(resolvent, numSteps - 1);
            }
            g.clearUnified();
            return false;
        }
        Predicate pred = g.getPredicate();
        if (pred.builtIn()) {
            if (g.needsDelaying()) {
                return true;
            }
            if (g.solve() != null) {
                ArrayList<Goal> resolvent = new ArrayList<Goal>(goals.size());
                if (pred.getType() == 556) {
                    int j = 0;
                    while (j < goals.size()) {
                        if (goals.get(j) != null && goals.get(j) != g) {
                            resolvent.add(((Goal)goals.get(j)).fixTerms());
                        }
                        ++j;
                    }
                } else {
                    int j = 0;
                    while (j < goals.size()) {
                        if (goals.get(j) != null && goals.get(j) != g) {
                            resolvent.add((Goal)goals.get(j));
                        }
                        ++j;
                    }
                }
                if (this.queryList(resolvent, numSteps - 1)) {
                    return true;
                }
                g.clearUnified();
                g.derivedFrom = this.makeRule(g, new ArrayList());
                g.substitutions = new ArrayList();
                return false;
            }
            return false;
        }
        ArrayList rules = this.getRules(g, true);
        int i2 = 0;
        while (i2 < rules.size()) {
            Rule r = ((Rule)rules.get(i2)).rename(this.usedTerms);
            Goal head = r.ruleHead();
            Goal unified = g.unify(head, this.occursCheck);
            if (unified != null) {
                ArrayList resolvent = new ArrayList(goals.size());
                int j = 0;
                while (j < goals.size()) {
                    if (goals.get(j) != null) {
                        resolvent.add(goals.get(j));
                    }
                    ++j;
                }
                int index = resolvent.indexOf(g);
                resolvent.remove(g);
                ArrayList newGoals = r.applyUnification();
                this.insertAt(resolvent, newGoals, index);
                int j2 = 0;
                while (j2 < resolvent.size()) {
                    resolvent.set(j2, ((Goal)resolvent.get(j2)).fixTerms());
                    ++j2;
                }
                r.clearUnified();
                if (this.queryList(resolvent, numSteps - 1)) {
                    g.derivedFrom = r;
                    g.substitutions = new ArrayList();
                    return true;
                }
            }
            g.clearUnified();
            r.clearUnified();
            ++i2;
        }
        return false;
    }

    protected boolean queryList(ArrayList goals, int numSteps) {
        if (goals.size() == 0) {
            return true;
        }
        return this.notFailure(this.pickGoal(goals), goals, numSteps);
    }

    private Goal pickGoal(ArrayList goals) {
        Goal g = (Goal)goals.get(0);
        int i = 0;
        while (i < goals.size()) {
            g = (Goal)goals.get(i);
            if (!g.pred.builtIn() || !g.needsDelaying()) {
                return g;
            }
            ++i;
        }
        return g;
    }

    protected void setTerms(ArrayList goals) {
        ArrayList<Term> vars = new ArrayList<Term>(goals.size());
        int i = 0;
        while (i < goals.size()) {
            this.append(vars, ((Goal)goals.get(i)).getVariables());
            ++i;
        }
        i = 0;
        while (i < vars.size()) {
            Term t = (Term)vars.get(i);
            int j = i + 1;
            while (j < vars.size()) {
                Term t1 = (Term)vars.get(j);
                if (t1 != t && t1.getName().equals(t.getName())) {
                    vars.set(i, t1);
                    if (t.isList()) {
                        t1.setIsList(true);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.putVariables(vars, goals);
    }

    protected void putVariables(ArrayList terms, ArrayList goals) {
        int index = 0;
        int i = 0;
        while (i < goals.size()) {
            Goal g = (Goal)goals.get(i);
            index = g.putVariables(terms, index);
            ++i;
        }
    }

    public void append(ArrayList v1, ArrayList v2) {
        int i = 0;
        while (i < v2.size()) {
            if (v2.get(i) != null) {
                v1.add(v2.get(i));
            }
            ++i;
        }
    }

    public void insertAt(ArrayList v1, ArrayList v2, int index) {
        if (index >= v1.size() || index == -1) {
            this.append(v1, v2);
        } else {
            int i = v2.size() - 1;
            while (i >= 0) {
                if (v2.get(i) != null) {
                    v1.add(index, v2.get(i));
                }
                --i;
            }
        }
    }

    public ArrayList<Term> getUniqueVariables(ArrayList<Goal> goals) {
        ArrayList<Term> vars = new ArrayList<Term>(goals.size());
        int i = 0;
        while (i < goals.size()) {
            Goal g = goals.get(i);
            ArrayList<Term> temp = g.getVariables();
            int j = 0;
            while (j < temp.size()) {
                Term t = temp.get(j);
                if (t.getType() == 0 && !vars.contains(t)) {
                    vars.add(t);
                }
                ++j;
            }
            ++i;
        }
        return vars;
    }

    public int findNextRight(int start, String str) {
        int numleft = 0;
        int numright = 0;
        int i = start;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '(') {
                ++numleft;
            } else if (c == ')') {
                ++numright;
            }
            if (numright > numleft) {
                return -1;
            }
            if (numright == numleft) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int findNextRightSquare(int start, String str) {
        int numleft = 0;
        int numright = 0;
        int i = start;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '[') {
                ++numleft;
            } else if (c == ']') {
                ++numright;
            }
            if (numright > numleft) {
                return -1;
            }
            if (numright == numleft) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

