/*
 * Decompiled with CFR 0.152.
 */
package AIspace.prolog;

import AIspace.prolog.Goal;
import AIspace.prolog.Predicate;
import AIspace.prolog.Term;
import java.util.ArrayList;
import java.util.Iterator;

public class Rule {
    public Goal head;
    protected ArrayList<Goal> body;
    protected Predicate pred;
    public int varCounter;

    public Rule(Predicate p) {
        this.head = this.makeGoal(p);
        this.body = new ArrayList();
        this.pred = p;
        this.varCounter = 0;
    }

    public Rule(Goal h, ArrayList<Goal> b) {
        this.head = h;
        this.body = b;
        this.pred = h.getPredicate();
        this.varCounter = 0;
        ArrayList terms = this.getVariables();
        int i = 0;
        while (i < terms.size()) {
            Term t = (Term)terms.get(i);
            int j = 0;
            while (j < terms.size()) {
                Term t1 = (Term)terms.get(j);
                if (t1 != t && t1.getName().equals(t.getName())) {
                    terms.set(i, t1);
                    if (t.isList()) {
                        t1.setIsList(true);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.putVariables(terms);
    }

    protected Rule makeRule(Predicate p) {
        return new Rule(p);
    }

    protected Rule makeRule(Goal h, ArrayList<Goal> b) {
        return new Rule(h, b);
    }

    protected Goal makeGoal(Predicate p) {
        return new Goal(p);
    }

    protected Goal makeGoal(Goal g) {
        return new Goal(g);
    }

    public void reset() {
        this.varCounter = 0;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    public Goal ruleHead() {
        return this.head;
    }

    public ArrayList ruleBody() {
        return this.body;
    }

    public ArrayList getVariables() {
        ArrayList<Term> vars = new ArrayList<Term>();
        ArrayList<Term> headvars = this.head.getVariables();
        int i = 0;
        while (i < headvars.size()) {
            vars.add(headvars.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.body.size()) {
            Goal g = this.body.get(i2);
            ArrayList<Term> bodyvars = g.getVariables();
            int j = 0;
            while (j < bodyvars.size()) {
                vars.add(bodyvars.get(j));
                ++j;
            }
            ++i2;
        }
        return vars;
    }

    public void putVariables(ArrayList terms) {
        int index = this.head.putVariables(terms, 0);
        int i = 0;
        while (i < this.body.size()) {
            index = this.body.get(i).putVariables(terms, index);
            ++i;
        }
    }

    public ArrayList applyUnification() {
        ArrayList<Goal> newBody = new ArrayList<Goal>(this.body.size());
        int i = 0;
        while (i < this.body.size()) {
            Goal g = this.body.get(i);
            Goal g1 = g.fixTerms2();
            newBody.add(g1);
            ++i;
        }
        this.head.fixTerms2();
        i = 0;
        while (i < newBody.size()) {
            ((Goal)newBody.get((int)i)).derivedFrom = this;
            ++i;
        }
        return newBody;
    }

    public Rule rename(ArrayList v) {
        ArrayList theseTerms = this.getVariables();
        int i = 0;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.get(i);
            t.clearUnified();
            if (t.getType() == 0) {
                String name = t.getRealName();
                Integer count = new Integer(this.varCounter);
                while (v.contains(name) || this.occursLater(i, name, t)) {
                    name = String.valueOf(t.getRealName()) + "_" + count.toString();
                    count = new Integer(count + 1);
                }
                t.setName(name);
            }
            ++i;
        }
        Goal newHead = this.makeGoal(this.head);
        ArrayList<Goal> newBody = new ArrayList<Goal>(this.body.size());
        int i2 = 0;
        while (i2 < this.body.size()) {
            newBody.add(this.makeGoal(this.body.get(i2)));
            ++i2;
        }
        Rule r = this.makeRule(newHead, newBody);
        r.varCounter = this.varCounter;
        return r;
    }

    public Rule applySubs(ArrayList subs) {
        Goal newHead = this.head.applySubs(subs);
        ArrayList<Goal> newBody = new ArrayList<Goal>(this.body.size());
        int i = 0;
        while (i < this.body.size()) {
            newBody.add(this.body.get(i).applySubs(subs));
            ++i;
        }
        return this.makeRule(newHead, newBody);
    }

    private boolean occursLater(int index, String name, Term term) {
        ArrayList theseTerms = this.getVariables();
        int i = index + 1;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.get(i);
            if (t.getRealName().equals(name) && t != term) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clearUnified() {
        this.head.clearUnified();
        Iterator<Goal> itr = this.body.iterator();
        while (itr.hasNext()) {
            itr.next().clearUnified();
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.head.toString());
        Iterator<Goal> itr = this.body.iterator();
        if (itr.hasNext()) {
            str.append(" < - ").append(itr.next().toString());
        }
        while (itr.hasNext()) {
            str.append(" & ").append(itr.next().toString());
        }
        str.append(".");
        return str.toString();
    }
}

