/*
 * Decompiled with CFR 0.152.
 */
package AIspace.prolog;

import AIspace.prolog.Goal;
import AIspace.prolog.Predicate;
import AIspace.prolog.Program;
import AIspace.prolog.Rule;
import AIspace.prolog.StripsRule;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class StripsProgram
extends Program {
    public ArrayList world = new ArrayList();
    public ArrayList initWorld = new ArrayList();

    @Override
    public void reset() {
        super.reset();
        this.world = (ArrayList)this.initWorld.clone();
    }

    @Override
    public Predicate predContains(String name, int arity) {
        int i = 0;
        while (i < this.predicates.size()) {
            Predicate p = (Predicate)this.predicates.get(i);
            if (p.getName().equals(name) && p.getArity() == arity) {
                return p;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String parse(String text) {
        String errorMessage = new String("");
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        this.predicates = new ArrayList();
        int lineCount = 0;
        try {
            block2: while (true) {
                if (!tokenizer.hasMoreTokens()) {
                    return errorMessage;
                }
                String inString = tokenizer.nextToken().trim();
                if (inString.length() <= 0 || inString.charAt(0) == '%') continue;
                while (true) {
                    if (inString.charAt(inString.length() - 1) == '.') {
                        errorMessage = this.parseStripsRule(inString);
                        ++lineCount;
                        if (errorMessage.length() <= 0) continue block2;
                        System.out.println(String.valueOf(errorMessage) + " at " + (lineCount + 1));
                        continue block2;
                    }
                    if (!tokenizer.hasMoreTokens()) {
                        return "Unexpected end of file";
                    }
                    String nextString = tokenizer.nextToken();
                    inString = String.valueOf(inString) + nextString;
                }
                break;
            }
        }
        catch (Exception e) {
            if (errorMessage.length() > 0) {
                return "Error at rule " + (lineCount + 1) + " -- " + errorMessage;
            }
            return "Error at rule " + (lineCount + 1) + " -- " + e.toString();
        }
    }

    public String parseStripsRule(String str) {
        if (!this.matchBrackets(str)) {
            return "Mismatched parentheses";
        }
        int i = str.indexOf("\n");
        Goal action = this.parseGoal(str.substring(0, i).trim());
        if (action == null) {
            return "Error parsing action";
        }
        Predicate p = action.getPredicate();
        Predicate old = this.predContains(p.getName(), p.getArity());
        if (old != null && !p.builtIn()) {
            action.pred = old;
        } else if (!p.builtIn()) {
            this.predicates.add(p);
        }
        int j = str.indexOf("\n", ++i);
        String precond = str.substring(i, j).trim();
        if (!precond.startsWith("preconditions")) {
            return "Missing preconditions";
        }
        int start = precond.indexOf("[");
        if (!this.matchBrackets(precond) || start == -1) {
            return "Mismatched parentheses";
        }
        ArrayList preconditions = this.parseList(precond.substring(start).trim());
        i = j + 1;
        String add = str.substring(i, j = str.indexOf("\n", i)).trim();
        if (!add.startsWith("add list")) {
            return "Missing add list";
        }
        start = add.indexOf("[");
        if (!this.matchBrackets(add) || start == -1) {
            return "Mismatched parentheses";
        }
        ArrayList addList = this.parseList(add.substring(start).trim());
        i = j + 1;
        String del = str.substring(i, j = str.indexOf("\n", i)).trim();
        if (!del.startsWith("delete list") || start == -1) {
            return "Missing delete list";
        }
        ArrayList deleteList = this.parseList(del.substring(start).trim());
        new StripsRule(action, preconditions, addList, deleteList);
        return "";
    }

    @Override
    protected ArrayList parseList(String str) {
        if (str.substring(1, str.length()).trim().equals("")) {
            return new ArrayList();
        }
        int nextComma = str.indexOf(",");
        ArrayList<Goal> v = new ArrayList<Goal>();
        int last = 1;
        while (nextComma != -1) {
            int compound = str.indexOf("(");
            int builtIn = str.indexOf("=");
            int nextLeft = 0;
            if (builtIn == -1 || compound < builtIn && compound != -1) {
                nextLeft = this.findNextRight(compound, str) + 1;
            } else if (compound == -1 || builtIn < compound && builtIn != -1) {
                nextLeft = nextComma;
            }
            if (nextLeft <= 0) {
                return null;
            }
            Goal g = this.parseGoal(str.substring(last, nextLeft));
            if (g == null) {
                return null;
            }
            Predicate p = g.getPredicate();
            Predicate old = this.predContains(p.getName(), p.getArity());
            if (old != null && !p.builtIn()) {
                g.pred = old;
            } else if (!p.builtIn()) {
                this.predicates.add(p);
            }
            v.add(g);
            last = nextLeft + 1;
            nextComma = str.indexOf(",", last);
        }
        Goal g = this.parseGoal(str.substring(last, str.length() - 1));
        if (g == null) {
            return null;
        }
        Predicate p = g.getPredicate();
        Predicate old = this.predContains(p.getName(), p.getArity());
        if (old != null && !p.builtIn()) {
            g.pred = old;
        } else if (!p.builtIn()) {
            this.predicates.add(p);
        }
        v.add(g);
        return v;
    }

    @Override
    public String textRep() {
        String str = new String("");
        int i = 0;
        while (i < this.predicates.size()) {
            Predicate p = (Predicate)this.predicates.get(i);
            ArrayList<Rule> rules = p.getRules();
            int j = 0;
            while (j < rules.size()) {
                StripsRule r = (StripsRule)((Object)rules.get(j));
                str = String.valueOf(str) + r.toString();
                ++j;
            }
            ++i;
        }
        return str;
    }

    public boolean holds(Goal g) {
        int i = 0;
        while (i < this.world.size()) {
            if (g.equals((Goal)this.world.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList achieveGoal(Goal g, StripsRule r) {
        g.usedRules.add(r);
        Goal unified = g.unify(r.getAction(), this.occursCheck);
        if (unified != null) {
            ArrayList changes = r.applyUnification();
            this.removeWorld((ArrayList)changes.get(2));
            this.addWorld((ArrayList)changes.get(1));
            ArrayList<Goal> subs = new ArrayList<Goal>(1);
            subs.add(r.action);
            g.substitutions = subs;
            return (ArrayList)changes.get(0);
        }
        g.clearUnified();
        return null;
    }

    public void checkHolds(ArrayList v) {
        int i = v.size() - 1;
        while (i >= 0) {
            Goal g = (Goal)v.get(i);
            if (this.holds(g)) {
                v.remove(g);
            }
            --i;
        }
    }

    public boolean canHold(Goal goal) {
        int i = 0;
        while (i < this.world.size()) {
            Goal g = (Goal)this.world.get(i);
            Goal newGoal = goal.unify(g, this.occursCheck);
            if (newGoal != null) {
                return true;
            }
            g.clearUnified();
            goal.clearUnified();
            ++i;
        }
        return false;
    }

    private void removeWorld(ArrayList v) {
        int i = 0;
        while (i < v.size()) {
            Goal g = (Goal)v.get(i);
            Goal remove = this.findInWorld(g);
            if (remove != null) {
                this.world.remove(remove);
            }
            ++i;
        }
    }

    private void addWorld(ArrayList v) {
        int i = 0;
        while (i < v.size()) {
            this.world.add(v.get(i));
            ++i;
        }
    }

    private Goal findInWorld(Goal g) {
        int i = 0;
        while (i < this.world.size()) {
            if (g.equals((Goal)this.world.get(i))) {
                return (Goal)this.world.get(i);
            }
            ++i;
        }
        return null;
    }
}

