/*
 * Decompiled with CFR 0.152.
 */
package AIspace.prolog;

import AIspace.prolog.Goal;
import AIspace.prolog.Predicate;
import AIspace.prolog.Term;
import java.util.ArrayList;

public class StripsRule {
    protected Goal action;
    protected ArrayList preconditions;
    protected ArrayList addList;
    protected ArrayList deleteList;
    protected Predicate pred;
    private int varCounter;

    public StripsRule(Predicate p) {
        this.action = new Goal(p);
        this.preconditions = new ArrayList();
        this.addList = new ArrayList();
        this.deleteList = new ArrayList();
        this.pred = p;
        this.varCounter = 0;
    }

    public StripsRule(Goal h, ArrayList pre, ArrayList add, ArrayList del) {
        this.varCounter = 0;
        this.action = h;
        this.preconditions = pre;
        this.addList = add;
        this.deleteList = del;
        this.pred = h.getPredicate();
        ArrayList terms = this.getVariables();
        int i = 0;
        while (i < terms.size()) {
            Term t = (Term)terms.get(i);
            int j = 0;
            while (j < terms.size()) {
                Term t1 = (Term)terms.get(j);
                if (t1 != t && t1.getName().equals(t.getName())) {
                    terms.set(i, t1);
                    if (t.isList()) {
                        t1.setIsList(true);
                    }
                }
                ++j;
            }
            ++i;
        }
        this.putVariables(terms);
    }

    public void reset() {
        this.varCounter = 0;
    }

    public Predicate getPredicate() {
        return this.pred;
    }

    public Goal getAction() {
        return this.action;
    }

    public ArrayList getPreconditions() {
        return this.preconditions;
    }

    public ArrayList getAddList() {
        return this.addList;
    }

    public ArrayList getDeleteList() {
        return this.deleteList;
    }

    public ArrayList getVariables() {
        int j;
        Goal g;
        ArrayList<Term> vars = new ArrayList<Term>();
        int i = 0;
        while (i < this.action.getVariables().size()) {
            vars.add(this.action.getVariables().get(i));
            ++i;
        }
        i = 0;
        while (i < this.preconditions.size()) {
            g = (Goal)this.preconditions.get(i);
            j = 0;
            while (j < g.getVariables().size()) {
                vars.add(g.getVariables().get(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.addList.size()) {
            g = (Goal)this.addList.get(i);
            j = 0;
            while (j < g.getVariables().size()) {
                vars.add(g.getVariables().get(j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.deleteList.size()) {
            g = (Goal)this.deleteList.get(i);
            j = 0;
            while (j < g.getVariables().size()) {
                vars.add(g.getVariables().get(j));
                ++j;
            }
            ++i;
        }
        return vars;
    }

    public void putVariables(ArrayList terms) {
        int index = this.action.putVariables(terms, 0);
        int i = 0;
        while (i < this.preconditions.size()) {
            index = ((Goal)this.preconditions.get(i)).putVariables(terms, index);
            ++i;
        }
        i = 0;
        while (i < this.addList.size()) {
            index = ((Goal)this.preconditions.get(i)).putVariables(terms, index);
            ++i;
        }
        i = 0;
        while (i < this.deleteList.size()) {
            index = ((Goal)this.preconditions.get(i)).putVariables(terms, index);
            ++i;
        }
    }

    public ArrayList applyUnification() {
        ArrayList v = new ArrayList(3);
        ArrayList<Goal> precond = new ArrayList<Goal>(this.preconditions.size());
        int i = 0;
        while (i < this.preconditions.size()) {
            Goal g = (Goal)this.preconditions.get(i);
            Goal g1 = g.fixTerms2();
            precond.add(g1);
            ++i;
        }
        v.add(precond);
        ArrayList<Goal> add = new ArrayList<Goal>(this.addList.size());
        int i2 = 0;
        while (i2 < this.addList.size()) {
            Goal g = (Goal)this.addList.get(i2);
            Goal g1 = g.fixTerms2();
            add.add(g1);
            ++i2;
        }
        v.add(add);
        ArrayList<Goal> del = new ArrayList<Goal>(this.deleteList.size());
        int i3 = 0;
        while (i3 < this.deleteList.size()) {
            Goal g = (Goal)this.deleteList.get(i3);
            Goal g1 = g.fixTerms2();
            del.add(g1);
            ++i3;
        }
        v.add(del);
        return v;
    }

    protected StripsRule rename(ArrayList v) {
        ArrayList theseTerms = this.getVariables();
        int i = 0;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.get(i);
            t.clearUnified();
            if (t.getType() == 0) {
                String name = t.getRealName();
                Integer count = new Integer(this.varCounter);
                while (v.contains(name) || this.occursLater(i, name, t)) {
                    name = String.valueOf(t.getRealName()) + count.toString();
                    count = new Integer(count + 1);
                }
                t.setName(name);
            }
            ++i;
        }
        StripsRule r = new StripsRule(new Goal(this.action), (ArrayList)this.preconditions.clone(), (ArrayList)this.addList.clone(), (ArrayList)this.deleteList.clone());
        return r;
    }

    public StripsRule applySubs(ArrayList subs) {
        Goal newHead = this.action.applySubs(subs);
        ArrayList<Goal> newPreconds = new ArrayList<Goal>(this.preconditions.size());
        int i = 0;
        while (i < this.preconditions.size()) {
            newPreconds.add(((Goal)this.preconditions.get(i)).applySubs(subs));
            ++i;
        }
        ArrayList<Goal> newAdds = new ArrayList<Goal>(this.addList.size());
        int i2 = 0;
        while (i2 < this.addList.size()) {
            newAdds.add(((Goal)this.addList.get(i2)).applySubs(subs));
            ++i2;
        }
        ArrayList<Goal> newDels = new ArrayList<Goal>(this.preconditions.size());
        int i3 = 0;
        while (i3 < this.deleteList.size()) {
            newDels.add(((Goal)this.deleteList.get(i3)).applySubs(subs));
            ++i3;
        }
        return new StripsRule(newHead, newPreconds, newAdds, newDels);
    }

    private boolean occursLater(int index, String name, Term term) {
        ArrayList theseTerms = this.getVariables();
        int i = index + 1;
        while (i < theseTerms.size()) {
            Term t = (Term)theseTerms.get(i);
            if (t.getRealName().equals(name) && t != term) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void clearUnified() {
        Goal g;
        this.action.clearUnified();
        int i = 0;
        while (i < this.preconditions.size()) {
            g = (Goal)this.preconditions.get(i);
            g.clearUnified();
            ++i;
        }
        i = 0;
        while (i < this.addList.size()) {
            g = (Goal)this.addList.get(i);
            g.clearUnified();
            ++i;
        }
        i = 0;
        while (i < this.deleteList.size()) {
            g = (Goal)this.deleteList.get(i);
            g.clearUnified();
            ++i;
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.action.toString());
        str.append("\npreconditions: ").append(this.preconditions.toString());
        str.append("\ndelete list: ").append(this.deleteList.toString());
        str.append("\nadd list: ").append(this.addList.toString()).append(".\n");
        return str.toString();
    }
}

