/*
 * Decompiled with CFR 0.152.
 */
package AIspace.prolog;

import AIspace.prolog.Functor;
import AIspace.prolog.Goal;
import AIspace.prolog.Predicate;
import AIspace.prolog.Program;
import AIspace.prolog.Substitution;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class Term {
    public static final int C_VARIABLE = 0;
    public static final int C_CONSTANT = 1;
    public static final int C_COMPOUND = 2;
    private int type;
    private Term[] terms;
    private String name;
    private String realName;
    private boolean isList = false;
    private Functor func;
    private Term unifiedWith;

    public Term(String str) {
        this.name = "";
        this.realName = "";
        int bracket = str.indexOf("(");
        int square = str.indexOf("[");
        Program p = new Program();
        if (bracket == -1 && square == -1) {
            if (str.indexOf("=") != -1 || str.indexOf("<") != -1 || str.indexOf(">") != -1) {
                Goal g = p.parseBuiltInGoal(str);
                this.type = 2;
                this.func = new Functor(g.pred.getType());
                this.terms = g.terms;
            } else {
                this.name = str;
                this.realName = str;
                String firstLetter = str.substring(0, 1);
                this.type = firstLetter.toLowerCase().equals(firstLetter) && !str.startsWith("_") ? 1 : 0;
            }
        } else if (square != -1 && (square < bracket || bracket == -1)) {
            square = str.indexOf("[", square + 1);
            int middle = str.indexOf("|");
            int nextComma = str.indexOf(",");
            int next = -1;
            next = !(bracket == -1 || bracket >= square && square != -1 || bracket >= nextComma && nextComma != -1) ? p.findNextRight(bracket, str) + 1 : (!(square == -1 || square >= bracket && bracket != -1 || square >= nextComma && nextComma != -1) ? p.findNextRightSquare(square, str) + 1 : (nextComma != -1 ? nextComma : str.length()));
            if (next <= 0) {
                this.name = "";
                this.realName = "";
                return;
            }
            if (middle == -1 && str.indexOf(",", next) == -1 && nextComma < next) {
                if (str.substring(1, str.length() - 1).trim().equals("")) {
                    this.name = "[]";
                    this.realName = "[]";
                    this.type = 1;
                    this.isList = true;
                } else {
                    Term t = this.makeTerm(str.substring(1, str.lastIndexOf("]")).trim());
                    this.type = 2;
                    this.func = new Functor(772);
                    this.terms = this.makeTerms(2);
                    this.terms[0] = t;
                    this.terms[1] = this.makeTerm("[]");
                    this.isList = true;
                }
            } else if (middle != -1 && nextComma < next && str.indexOf(",", next) == -1) {
                this.type = 2;
                this.func = new Functor(772);
                this.isList = true;
                this.terms = this.makeTerms(2);
                this.terms[0] = this.makeTerm(str.substring(1, middle).trim());
                Term carCdr = this.makeTerm(str.substring(middle + 1, str.lastIndexOf("]")).trim());
                if (carCdr.type != 0) {
                    Term cdrCdr = this.makeTerm("[]");
                    Term[] tempTerms = this.makeTerms(2);
                    tempTerms[0] = carCdr;
                    tempTerms[1] = cdrCdr;
                    this.terms[1] = this.makeTerm(this.func, tempTerms);
                } else {
                    this.terms[1] = carCdr;
                }
                this.terms[1].isList = true;
            } else {
                int j = next;
                this.type = 2;
                this.func = new Functor(772);
                this.isList = true;
                this.terms = this.makeTerms(2);
                this.terms[0] = this.makeTerm(str.substring(1, j).trim());
                String tempString = str.substring(j + 1).trim();
                this.terms[1] = this.makeTerm("[" + tempString);
            }
        } else {
            int next;
            int i = str.indexOf("(");
            String fname = str.substring(0, i).trim();
            int compound = str.indexOf("(", i + 1);
            int compound2 = str.indexOf("[", i + 1);
            int j = str.indexOf(",");
            int end = str.length() - 1;
            if (compound > -1 && compound < j && (compound2 == -1 || compound < compound)) {
                next = p.findNextRight(compound, str);
                if (next == -1) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                j = next + 1;
            } else if (compound2 > -1 && compound2 < j) {
                next = p.findNextRightSquare(compound2, str);
                if (next == -1) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                j = next + 1;
            }
            ArrayList<Term> newTerms = new ArrayList<Term>();
            ++i;
            while (j > 0) {
                String nextTerm = str.substring(i, j).trim();
                if (!p.matchBrackets(nextTerm)) {
                    this.name = "";
                    this.realName = "";
                    return;
                }
                i = j + 1;
                newTerms.add(this.makeTerm(nextTerm));
                compound = str.indexOf("(", j);
                compound2 = str.indexOf("[", j);
                int nextComma = str.indexOf(",", i);
                j = compound != -1 && compound < nextComma && (compound2 == -1 || compound < compound2) ? p.findNextRight(compound, str) + 1 : (compound2 > -1 && compound2 < nextComma ? p.findNextRightSquare(compound2, str) + 1 : str.indexOf(",", i));
            }
            if (i < end) {
                newTerms.add(this.makeTerm(str.substring(i, end).trim()));
            }
            this.terms = this.makeTerms(newTerms.size());
            int ind = 0;
            while (ind < newTerms.size()) {
                this.terms[ind] = (Term)newTerms.get(ind);
                ++ind;
            }
            this.func = new Functor(fname, this.terms.length);
            this.type = 2;
        }
    }

    public Term(Functor f, Term[] newTerms) {
        this.name = "";
        this.realName = "";
        this.func = f;
        this.terms = newTerms;
        this.type = 2;
        if (f.getType() == 772) {
            this.isList = true;
        }
    }

    public Term(Term t) {
        this.type = t.type;
        if (this.type != 2) {
            this.name = t.name;
            this.realName = t.name;
        } else {
            this.name = "";
            this.realName = "";
            this.func = t.func;
            this.terms = this.makeTerms(t.terms.length);
            int i = 0;
            while (i < t.terms.length) {
                this.terms[i] = this.makeTerm(t.terms[i]);
                ++i;
            }
        }
        this.isList = t.isList;
    }

    protected Predicate makePredicate(String name, int arity) {
        return new Predicate(name, arity);
    }

    protected Predicate makePredicate() {
        return new Predicate();
    }

    protected Term makeTerm(String str) {
        return new Term(str);
    }

    protected Term makeTerm(Term t) {
        return new Term(t);
    }

    protected Term makeTerm(Functor f, Term[] terms) {
        return new Term(f, terms);
    }

    protected Term[] makeTerms(int size) {
        return new Term[size];
    }

    public Goal termToGoal() {
        if (this.type != 2) {
            return null;
        }
        if (this.func.isBuiltIn()) {
            Predicate p = this.makePredicate().getPred(this.func.getType());
            return new Goal(p, this.copyTerms());
        }
        Predicate p = new Predicate(this.func.getName(), this.func.getArity());
        return new Goal(p, this.cloneTerms());
    }

    public String getName() {
        return this.toString();
    }

    public String getRealName() {
        return this.realName;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public ArrayList<Term> getVariables() {
        if (this.type == 2) {
            ArrayList<Term> vars = new ArrayList<Term>(this.terms.length);
            Program p = new Program();
            int i = 0;
            while (i < this.terms.length) {
                p.append(vars, this.terms[i].getVariables());
                ++i;
            }
            return vars;
        }
        ArrayList<Term> vars = new ArrayList<Term>(1);
        vars.add(this);
        return vars;
    }

    private Term[] copyTerms() {
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.makeTerm(this.terms[i]);
            ++i;
        }
        return newTerms;
    }

    private Term[] cloneTerms() {
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i];
            ++i;
        }
        return newTerms;
    }

    public int putVariables(ArrayList v, int index) {
        if (this.type != 2) {
            return index;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i].type != 2) {
                this.terms[i] = (Term)v.get(index);
                ++index;
            } else {
                index = this.terms[i].putVariables(v, index);
            }
            ++i;
        }
        return index;
    }

    public void clearUnified() {
        this.unifiedWith = null;
        if (this.type == 2) {
            int i = 0;
            while (i < this.terms.length) {
                this.terms[i].clearUnified();
                ++i;
            }
        }
    }

    public Term[] getTerms() {
        if (this.terms != null) {
            return this.terms;
        }
        return null;
    }

    public Term lastUnified() {
        if (this.unifiedWith == null) {
            return this;
        }
        Term t = this.unifiedWith.lastUnified();
        if (t.type == 2 && !t.containsVariable(this)) {
            return t.fixTerms();
        }
        return t;
    }

    public Term fixTerms() {
        if (this.type != 2) {
            return this.makeTerm(this.lastUnified());
        }
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].lastUnified();
            ++i;
        }
        Term t = this.makeTerm(this.func, newTerms);
        t.isList = this.isList;
        return t;
    }

    public Term fixTerms2() {
        if (this.type != 2) {
            if (this.unifiedWith == null) {
                return this;
            }
            if (this.unifiedWith.containsVariable(this)) {
                return this.unifiedWith;
            }
            return this.unifiedWith.fixTerms2();
        }
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].containsVariable(this) ? this.terms[i] : this.terms[i].fixTerms2();
            ++i;
        }
        Term t = this.makeTerm(this.func, newTerms);
        t.isList = this.isList;
        return t;
    }

    protected boolean containsVariable(Term t) {
        if (this.type != 2) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (this.terms[i] == t || this.terms[i].containsVariable(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Term unify(Term t, boolean occursCheck) {
        block16: {
            if (t.name.equals("_")) {
                return this;
            }
            if (this.name.equals("_")) {
                return t;
            }
            if (!(t.type != 0 || occursCheck && this.containsVariable(t))) {
                if (this.type == 1 && !this.isList && t.isList) {
                    return null;
                }
                t.unifiedWith = this;
                if (this.unifiedWith == t) {
                    this.unifiedWith = null;
                }
                return this;
            }
            if (!(this.type != 0 || occursCheck && t.containsVariable(this))) {
                if (t.type == 1 && !t.isList && this.isList) {
                    return null;
                }
                this.unifiedWith = t;
                if (t.unifiedWith == this) {
                    t.unifiedWith = null;
                }
                return t;
            }
            if (this.type == 1 && t.type == 1) {
                if (t.name.equals(this.name)) {
                    return this;
                }
                try {
                    if (Double.parseDouble(this.name) == Double.parseDouble(t.name)) {
                        return this;
                    }
                    break block16;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (this.type == 2 && t.type == 2 && t.func.getName().equals(this.func.getName()) && t.func.getArity() == this.func.getArity() && t.isList == this.isList) {
                Term[] unified = this.makeTerms(this.terms.length);
                int i = 0;
                while (i < this.terms.length) {
                    Term newTerm = this.terms[i].lastUnified().unify(t.getTerms()[i].lastUnified(), occursCheck);
                    if (newTerm == null) {
                        return null;
                    }
                    unified[i] = newTerm;
                    unified[i].isList = this.terms[i].isList;
                    ++i;
                }
                this.unifiedWith = this.makeTerm(this.func, unified);
                this.unifiedWith.isList = this.isList;
                return this.unifiedWith;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canunify(Term t, boolean occursCheck) {
        if (t.name.equals("_")) {
            return true;
        }
        if (this.name.equals("_")) {
            return true;
        }
        if (!(t.type != 0 || occursCheck && this.containsVariable(t))) {
            return this.type != 1 || this.isList || !t.isList;
        }
        if (!(this.type != 0 || occursCheck && t.containsVariable(this))) {
            return t.type != 1 || t.isList || !this.isList;
        }
        if (this.type == 1 && t.type == 1 && t.name.equals(this.name)) {
            return true;
        }
        if (this.type == 1 && t.type == 1) {
            try {
                if (!new Double(t.name).equals(new Double(this.name))) return false;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        } else {
            if (this.type != 2 || t.type != 2 || !t.func.getName().equals(this.func.getName()) || t.func.getArity() != this.func.getArity() || t.isList != this.isList) return false;
            int i = 0;
            while (i < this.terms.length) {
                if (!this.terms[i].lastUnified().canunify(t.getTerms()[i].lastUnified(), occursCheck)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    public Double solveArithmetic() {
        block21: {
            Double left2;
            Double left1;
            block24: {
                block22: {
                    Double term1;
                    block23: {
                        try {
                            if (this.type == 1 && this.name.toUpperCase().equals(this.name)) {
                                return Double.valueOf(this.name);
                            }
                            if (this.type != 2 || this.func == null || !this.func.isBuiltIn()) break block21;
                            if (this.terms.length != 1) break block22;
                            term1 = this.terms[0].lastUnified().solveArithmetic();
                            if (term1 != null) break block23;
                            return null;
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                    double termvalue = term1;
                    switch (this.func.getType()) {
                        case 779: {
                            return new Double(Math.abs(termvalue));
                        }
                        case 776: {
                            return new Double(Math.acos(termvalue));
                        }
                        case 777: {
                            return new Double(Math.sqrt(Math.abs(termvalue)));
                        }
                        case 778: {
                            return new Double(Math.pow(termvalue, 2.0));
                        }
                        case 780: {
                            return new Double(Math.cos(termvalue));
                        }
                        case 781: {
                            return new Double(Math.sin(termvalue));
                        }
                    }
                    return null;
                }
                left1 = this.terms[0].lastUnified().solveArithmetic();
                left2 = this.terms[1].lastUnified().solveArithmetic();
                if (left1 != null && left2 != null) break block24;
                return null;
            }
            double left = left1;
            double right = left2;
            switch (this.func.getType()) {
                case 770: {
                    return new Double(left * right);
                }
                case 771: {
                    return new Double(left + right);
                }
                case 773: {
                    return new Double(left % right);
                }
                case 775: {
                    return new Double(left / right);
                }
                case 774: {
                    return new Double(left - right);
                }
            }
            return null;
        }
        return null;
    }

    public Term applySubs(Term newTerm, ArrayList subs) {
        if (newTerm.type != 2) {
            return newTerm;
        }
        ArrayList<Term> newTerms = new ArrayList<Term>(newTerm.getVariables().size());
        ArrayList<Term> vars = newTerm.getVariables();
        int i = 0;
        while (i < vars.size()) {
            Term t = vars.get(i);
            int j = 0;
            while (j < subs.size()) {
                Substitution s = (Substitution)subs.get(j);
                if (s.first.name.equals(t.name)) {
                    t = t.applySubs(s.second, subs);
                }
                ++j;
            }
            newTerms.add(t);
            ++i;
        }
        Term t1 = this.makeTerm(newTerm);
        t1.putVariables(newTerms, 0);
        return t1;
    }

    public Term applySubs(ArrayList subs, boolean recurse) {
        if (this.type != 2) {
            int i = 0;
            while (i < subs.size()) {
                Substitution s = (Substitution)subs.get(i);
                if (s.first.name.equals(this.name)) {
                    if (s.second.type != 1 && recurse && !s.second.containsVariable(this)) {
                        return s.second.applySubs(subs, true);
                    }
                    s.second.unifiedWith = null;
                    return s.second;
                }
                ++i;
            }
            return this;
        }
        Term[] newTerms = this.makeTerms(this.terms.length);
        int i = 0;
        while (i < this.terms.length) {
            newTerms[i] = this.terms[i].containsVariable(this) ? this.terms[i] : this.terms[i].applySubs(subs, recurse);
            ++i;
        }
        return this.makeTerm(this.func, newTerms);
    }

    protected boolean equals(Term t) {
        if (t.type == 1) {
            return this.name.equals(t.name);
        }
        if (t.type == 0) {
            if (this.isList != t.isList) {
                return false;
            }
            return this.name.equals(t.name);
        }
        if (!t.func.equals(this.func)) {
            return false;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].equals(t.terms[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGround() {
        if (this.type == 0) {
            return false;
        }
        if (this.type == 1) {
            return true;
        }
        int i = 0;
        while (i < this.terms.length) {
            if (!this.terms[i].isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ArrayList<Term> getElements() {
        if (this.type == 1) {
            ArrayList<Term> single = new ArrayList<Term>(1);
            single.add(this);
            return single;
        }
        if (!this.isList) {
            return new ArrayList<Term>();
        }
        if (this.type == 0) {
            ArrayList<Term> two = new ArrayList<Term>(2);
            two.add(this);
            two.add(this.makeTerm("[]"));
            return two;
        }
        ArrayList<Term> elements = new ArrayList<Term>();
        elements.add(this.terms[0]);
        Program p = new Program();
        p.append(elements, this.terms[1].getElements());
        return elements;
    }

    public int getType() {
        return this.type;
    }

    public boolean isList() {
        return this.isList;
    }

    public void setIsList(boolean isList) {
        this.isList = isList;
    }

    public Term getUnifiedWith() {
        return this.unifiedWith;
    }

    public void setUnifiedWith(Term t) {
        this.unifiedWith = t;
    }

    public String toString() {
        if (this.isList && this.type == 2) {
            StringBuffer str = new StringBuffer("[");
            ArrayList<Term> elements = this.getElements();
            str.append(elements.get(0).toString());
            int i = 1;
            while (i < elements.size() - 1) {
                Term curTerm = elements.get(i);
                if (i == elements.size() - 2 && curTerm.getType() == 0 && curTerm.isList()) {
                    str.append(" | ").append(curTerm.toString());
                } else {
                    str.append(", ").append(curTerm.toString());
                }
                ++i;
            }
            str.append("]");
            return str.toString();
        }
        if (this.type != 2) {
            try {
                DecimalFormat formatter = new DecimalFormat("0.##");
                return formatter.format(Double.valueOf(this.name));
            }
            catch (NumberFormatException e) {
                return this.name;
            }
        }
        if (!this.func.isBuiltIn()) {
            StringBuffer str = new StringBuffer(this.func.getName());
            str.append("(").append(this.terms[0].toString());
            int i = 1;
            while (i < this.terms.length) {
                str.append(", ").append(this.terms[i].toString());
                ++i;
            }
            str.append(")");
            return str.toString();
        }
        switch (this.func.getType()) {
            case 779: {
                return new String("abs(" + this.terms[0].toString() + ")");
            }
            case 776: {
                return new String("acos(" + this.terms[0].toString() + ")");
            }
            case 780: {
                return new String("cos(" + this.terms[0].toString() + ")");
            }
            case 781: {
                return new String("sin(" + this.terms[0].toString() + ")");
            }
            case 777: {
                return new String("sqrt(" + this.terms[0].toString() + ")");
            }
            case 778: {
                return new String("square(" + this.terms[0].toString() + ")");
            }
        }
        String middle = "";
        switch (this.func.getType()) {
            case 770: {
                middle = "*";
                break;
            }
            case 771: {
                middle = "+";
                break;
            }
            case 773: {
                middle = " mod ";
                break;
            }
            case 774: {
                middle = "-";
                break;
            }
            case 775: {
                middle = "/";
                break;
            }
            default: {
                return this.termToGoal().printString();
            }
        }
        String str = new String("(" + this.terms[0].toString());
        str = String.valueOf(str) + middle + this.terms[1].toString() + ")";
        return str;
    }

    public String printString() {
        if (this.isList && this.type == 2) {
            StringBuffer str = new StringBuffer("[");
            ArrayList<Term> elements = this.getElements();
            str.append(elements.get(0).printString());
            int i = 1;
            while (i < elements.size() - 1) {
                Term curTerm = elements.get(i);
                if (i == elements.size() - 2 && curTerm.getType() == 0 && curTerm.isList()) {
                    str.append(" | ").append(curTerm.printString());
                } else {
                    str.append(", ").append(curTerm.printString());
                }
                ++i;
            }
            str.append("]");
            return str.toString();
        }
        if (this.type != 2) {
            if (this.unifiedWith != null) {
                return this.lastUnified().toString();
            }
            return this.name;
        }
        if (!this.func.isBuiltIn()) {
            StringBuffer str = new StringBuffer(this.func.getName());
            str.append("(").append(this.terms[0].printString());
            int i = 1;
            while (i < this.terms.length) {
                str.append(", ").append(this.terms[i].printString());
                ++i;
            }
            str.append(")");
            return str.toString();
        }
        switch (this.func.getType()) {
            case 779: {
                return new String("abs(" + this.terms[0].printString() + ")");
            }
            case 776: {
                return new String("acos(" + this.terms[0].printString() + ")");
            }
            case 780: {
                return new String("cos(" + this.terms[0].printString() + ")");
            }
            case 781: {
                return new String("sin(" + this.terms[0].printString() + ")");
            }
            case 777: {
                return new String("sqrt(" + this.terms[0].printString() + ")");
            }
            case 778: {
                return new String("square(" + this.terms[0].printString() + ")");
            }
        }
        String middle = "";
        switch (this.func.getType()) {
            case 770: {
                middle = "*";
                break;
            }
            case 771: {
                middle = "+";
                break;
            }
            case 773: {
                middle = " mod ";
                break;
            }
            case 774: {
                middle = "-";
                break;
            }
            case 775: {
                middle = "/";
                break;
            }
            default: {
                return this.termToGoal().printString();
            }
        }
        String str = new String("(" + this.terms[0].printString());
        str = String.valueOf(str) + middle + this.terms[1].printString() + ")";
        return str;
    }
}

