/*
 * Decompiled with CFR 0.152.
 */
package CIspace.XMLReader;

import CIspace.XMLReader.XMLBlock;
import CIspace.XMLReader.XMLParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTree {
    protected XMLBlock headNode = new XMLBlock();

    public void readString(String input) throws XMLParseException {
        this.readString(this.stripComments(input), this.headNode);
    }

    public XMLBlock findNetworkTree(String tag) {
        ArrayList<XMLBlock> thisTree = new ArrayList<XMLBlock>();
        thisTree.add(this.headNode);
        return this.findNetworkTree(thisTree, tag);
    }

    private XMLBlock findNetworkTree(ArrayList<XMLBlock> currLevel, String tag) {
        int i = 0;
        while (i < currLevel.size()) {
            XMLBlock currBlock = currLevel.get(i);
            if (currBlock.getTag().equalsIgnoreCase(tag)) {
                return currBlock;
            }
            XMLBlock returnBlock = this.findNetworkTree(currBlock.childBlocks, tag);
            if (returnBlock != null) {
                return returnBlock;
            }
            ++i;
        }
        return null;
    }

    private String stripComments(String s) {
        int commentStart;
        String input = s;
        while ((commentStart = input.indexOf("<!--")) != -1) {
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(input.indexOf("-->") + 3);
        }
        while ((commentStart = input.indexOf("<?")) != -1) {
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(input.indexOf("?>") + 2);
        }
        while ((commentStart = input.indexOf("<!DOCTYPE")) != -1) {
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(input.indexOf("]>") + 2);
        }
        return input.trim();
    }

    private void readString(String input, XMLBlock currentNode) throws XMLParseException {
        int startOfTag = input.indexOf("<");
        int errorTag = input.indexOf("<-");
        while (startOfTag == errorTag) {
            if (startOfTag == -1) {
                return;
            }
            startOfTag = input.indexOf("<", errorTag);
            errorTag = input.indexOf("<-", errorTag);
        }
        int endOfTagName = input.indexOf(" ");
        endOfTagName = input.indexOf(" ") < input.indexOf(">") && input.indexOf(" ") > 0 ? input.indexOf(" ") : input.indexOf(">");
        int endOfStartTag = input.indexOf(">");
        String tag = input.substring(startOfTag + 1, endOfTagName);
        currentNode.setTag(tag);
        int endOfTag = input.indexOf("</" + tag + ">");
        if (endOfTag == -1) {
            throw new XMLParseException("End of tag \"<" + tag + ">\" not found.");
        }
        if (input.indexOf("<", endOfStartTag + 1) == endOfTag || tag.equalsIgnoreCase("logicprogram")) {
            currentNode.setText(input.substring(endOfStartTag + 1, endOfTag));
        }
        if (endOfStartTag - endOfTagName > 0) {
            StringTokenizer startTag = new StringTokenizer(input.substring(endOfTagName + 1, endOfStartTag).trim(), " \"=", true);
            String tok = startTag.nextToken();
            while (startTag.hasMoreTokens()) {
                String propertyName = "";
                String propertyValue = "";
                while (tok.equals(" ")) {
                    tok = startTag.nextToken();
                }
                propertyName = tok;
                tok = startTag.nextToken();
                while (tok.equals(" ") || tok.equals("=")) {
                    tok = startTag.nextToken();
                }
                if (!tok.equals("\"")) {
                    propertyValue = tok;
                    currentNode.addProperty(propertyName, propertyValue);
                } else {
                    propertyValue = startTag.nextToken();
                    tok = startTag.nextToken();
                    while (!tok.equals("\"")) {
                        propertyValue = String.valueOf(propertyValue) + tok;
                        tok = startTag.nextToken();
                    }
                    currentNode.addProperty(propertyName, propertyValue);
                }
                if (!startTag.hasMoreTokens()) break;
                tok = startTag.nextToken();
                while (tok.equals(" ") && startTag.hasMoreTokens()) {
                    tok = startTag.nextToken();
                }
            }
        }
        String remainingString = input.substring(endOfStartTag + 1, endOfTag);
        while (remainingString.indexOf("<") != -1) {
            int startOfNewTag = remainingString.indexOf("<");
            if (!tag.equalsIgnoreCase("logicprogram")) {
                int endOfNewTagName = startOfNewTag;
                endOfNewTagName = remainingString.indexOf(" ", startOfNewTag) < remainingString.indexOf(">", startOfNewTag) && remainingString.indexOf(" ", startOfNewTag) > 0 ? remainingString.indexOf(" ", startOfNewTag) : remainingString.indexOf(">", startOfNewTag);
                String newTag = remainingString.substring(startOfNewTag + 1, endOfNewTagName);
                int endOfNewTag = remainingString.indexOf("</" + newTag + ">");
                if (endOfNewTag == -1) {
                    throw new XMLParseException("End of tag \"<" + newTag + ">\" not found.");
                }
                XMLBlock newChildNode = new XMLBlock();
                String childString = String.valueOf(remainingString.substring(startOfNewTag, endOfNewTag)) + "</" + newTag + ">";
                remainingString = remainingString.substring(endOfNewTag + ("/" + newTag + ">").length() + 1);
                this.readString(childString, newChildNode);
                currentNode.addChild(newChildNode);
                continue;
            }
            String copyOfRemainingString = new String(remainingString).toLowerCase();
            remainingString = remainingString.substring(copyOfRemainingString.indexOf("</logicprogram>") + 15);
        }
    }

    public void print() {
        this.printAll(this.headNode, 0);
    }

    private void printAll(XMLBlock currNode, int spaces) {
        String s = "";
        int i = 0;
        while (i < spaces) {
            s = String.valueOf(s) + "\t ";
            ++i;
        }
        System.out.println(String.valueOf(s) + "node tag: " + currNode.getTag());
        i = 0;
        while (i < currNode.getProperties().size()) {
            System.out.println(String.valueOf(s) + "Property: " + currNode.getProperties().get((int)i).name);
            ++i;
        }
        System.out.println(String.valueOf(s) + "Text: " + currNode.getText());
        System.out.println(String.valueOf(s) + "Children: ");
        i = 0;
        while (i < currNode.childBlocks.size()) {
            this.printAll(currNode.childBlocks.get(i), spaces + 1);
            ++i;
        }
    }

    public XMLBlock getHead() {
        return this.headNode;
    }
}

