/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools;

import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPcanvas;
import CIspace.cspTools.elements.CSPVariable;
import CIspace.cspTools.elements.Constraint;
import CIspace.cspTools.elements.ConstraintEdge;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.elements.Edge;
import CIspace.graphToolKit.elements.Entity;
import CIspace.graphToolKit.elements.Node;
import java.util.ArrayList;

public class CSPgraph
extends Graph {
    protected CSP csp;

    public CSPgraph(CSP csp, CSPcanvas canvas) {
        super(canvas);
        this.csp = csp;
    }

    public void remove(Entity ent) {
        if (ent instanceof Node) {
            this.nodes.remove(ent);
        }
        if (ent instanceof Edge) {
            this.edges.remove(ent);
        }
    }

    public void deleteSelected() {
        for (Edge e : this.selectedEdges) {
            if (!(e instanceof ConstraintEdge)) continue;
            this.deleteConstraintEdge((ConstraintEdge)e);
        }
        for (Node n : this.selectedNodes) {
            if (n instanceof Constraint) {
                this.deleteConstraint((Constraint)n);
                continue;
            }
            if (!(n instanceof CSPVariable)) continue;
            this.deleteVariable((CSPVariable)n);
        }
        this.csp.checkEditablity();
        super.deleteSelected();
    }

    private void deleteConstraintEdge(ConstraintEdge edge) {
        CSPVariable var = edge.getVariable();
        Constraint cns = edge.getConstraint();
        if (cns != null && var != null) {
            cns.removeVariable(var);
        }
    }

    private void deleteConstraint(Constraint cns) {
        cns.delete();
        this.csp.remConstraint(cns);
    }

    private void deleteVariable(CSPVariable var) {
        ArrayList<Edge>[] varEdges = var.getAllEdges();
        int i = 0;
        while (i < 2) {
            int j = varEdges[i].size() - 1;
            while (j >= 0) {
                if (varEdges[i].get(j) instanceof ConstraintEdge) {
                    this.deleteConstraintEdge((ConstraintEdge)varEdges[i].get(j));
                }
                --j;
            }
            ++i;
        }
        this.nodes.remove(var);
        this.csp.remVariable(var);
    }
}

