/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.VE;

import CIspace.cspTools.VE.EltsIterator;
import CIspace.cspTools.VE.VE_Variable;
import java.util.Arrays;

public abstract class Factor {
    public static boolean printVarIds = false;
    private static boolean savingForTracing = false;
    private VE_Variable[] variables;
    private int thesize;

    public boolean getSavingForTracing() {
        return savingForTracing;
    }

    public void setSavingForTracing(boolean val) {
        savingForTracing = val;
    }

    public Factor(VE_Variable[] vars) {
        this.variables = vars;
        this.thesize = 1;
        int i = 0;
        while (i < this.variables.length) {
            this.thesize *= this.variables[i].getDomainSize();
            ++i;
        }
    }

    public String getName() {
        String nameString = new String("[");
        if (this.variables.length > 0) {
            nameString = String.valueOf(nameString) + this.variables[0].getName();
        }
        int i = 1;
        while (i < this.variables.length) {
            nameString = String.valueOf(nameString) + ", " + this.variables[i].getName();
            ++i;
        }
        return String.valueOf(nameString) + "]";
    }

    public VE_Variable[] getVariables() {
        return this.variables;
    }

    public abstract EltsIterator iterator();

    public int size() {
        return this.thesize;
    }

    public boolean contains(VE_Variable v) {
        return Arrays.binarySearch(this.variables, v) >= 0;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < this.variables.length) {
            output.append(this.variables[i].getName()).append("\t");
            ++i;
        }
        output.append("Value\n");
        int[] index = new int[this.variables.length];
        EltsIterator iter = this.iterator();
        while (iter.hasNext()) {
            int i2 = 0;
            while (i2 < this.variables.length) {
                output.append(this.variables[i2].getDomain()[index[i2]]).append("\t");
                ++i2;
            }
            output.append(iter.next()).append("\n");
            if (!iter.hasNext()) continue;
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.variables[i3].getDomainSize() - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < this.variables.length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        return output.toString();
    }

    public void printVariables() {
        if (this.variables.length > 0) {
            System.out.print(this.variables[0].getName());
            if (printVarIds) {
                System.out.print("(#" + this.variables[0].getId() + ")");
            }
            int i = 1;
            while (i < this.variables.length) {
                System.out.print(", " + this.variables[i].getName());
                if (printVarIds) {
                    System.out.print("(#" + this.variables[i].getId() + ")");
                }
                ++i;
            }
        }
    }

    public void print() {
        this.print("");
    }

    public void print(String indent) {
        System.out.print(indent);
        int i = 0;
        while (i < this.variables.length) {
            System.out.print(this.variables[i].getName());
            System.out.print("\t");
            ++i;
        }
        System.out.print("Value\n");
        int[] index = new int[this.variables.length];
        EltsIterator iter = this.iterator();
        while (iter.hasNext()) {
            System.out.print(indent);
            int i2 = 0;
            while (i2 < this.variables.length) {
                System.out.print(this.variables[i2].getDomain()[index[i2]]);
                System.out.print("\t");
                ++i2;
            }
            System.out.println(iter.next());
            boolean allMax = true;
            int i3 = this.variables.length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < this.variables[i3].getDomainSize() - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    allMax = false;
                } else {
                    index[i3] = 0;
                }
                --i3;
            }
        }
    }

    public boolean allOnes() {
        EltsIterator itr = this.iterator();
        while (itr.hasNext()) {
            if (itr.next() == 1.0) continue;
            return false;
        }
        return true;
    }

    public boolean isRedundant(VE_Variable var) {
        int before = 1;
        int dom = var.getDomainSize();
        int after = 1;
        int pos = 0;
        while (this.variables[pos] != var) {
            before *= this.variables[pos++].getDomainSize();
        }
        ++pos;
        while (pos < this.variables.length) {
            after *= this.variables[pos++].getDomainSize();
        }
        EltsIterator[] its = new EltsIterator[dom];
        int i = 0;
        while (i < dom) {
            its[i] = this.iterator();
            ++i;
        }
        pos = 0;
        int b = 0;
        while (b < before) {
            int i2 = 0;
            while (i2 < dom) {
                its[i2].backTo(pos);
                pos += after;
                ++i2;
            }
            int a = 0;
            while (a < after) {
                double val = its[0].next();
                int i3 = 1;
                while (i3 < dom) {
                    if (val != its[i3].next()) {
                        return false;
                    }
                    ++i3;
                }
                ++a;
            }
            ++b;
        }
        return true;
    }

    public boolean isRedundant(VE_Variable var, double threshold) {
        int before = 1;
        int dom = var.getDomainSize();
        int after = 1;
        int pos = 0;
        while (this.variables[pos] != var) {
            before *= this.variables[pos++].getDomainSize();
        }
        ++pos;
        while (pos < this.variables.length) {
            after *= this.variables[pos++].getDomainSize();
        }
        EltsIterator[] its = new EltsIterator[dom];
        int i = 0;
        while (i < dom) {
            its[i] = this.iterator();
            ++i;
        }
        pos = 0;
        int b = 0;
        while (b < before) {
            int i2 = 0;
            while (i2 < dom) {
                its[i2].backTo(pos);
                pos += after;
                ++i2;
            }
            int a = 0;
            while (a < after) {
                double min;
                double max = min = its[0].next();
                int i3 = 1;
                while (i3 < dom) {
                    double nextval = its[i3].next();
                    if (max < nextval) {
                        max = nextval;
                    } else if (min > nextval) {
                        min = nextval;
                    }
                    if (max - min > threshold) {
                        return false;
                    }
                    ++i3;
                }
                ++a;
            }
            ++b;
        }
        return true;
    }
}

