/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.dialogs;

import CIspace.cspTools.CSPWindow;
import CIspace.cspTools.Relation;
import CIspace.cspTools.dialogs.AffirmPanel;
import CIspace.cspTools.elements.Constraint;
import CIspace.cspTools.relations.RelationChooser;
import CIspace.cspTools.relations.RelationFactor;
import CIspace.cspTools.relations.ReorderDialog;
import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.graphToolKit.elements.Point;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RelationDialog
extends BasicDialog {
    private JPanel customNamePanel;
    private JTextField customNameText;
    private Relation rel;
    private AffirmPanel relPanel;
    private RelationChooser relationChooser;
    private Constraint constraint;
    public boolean isCancelled = true;
    private boolean isEditable;

    public RelationDialog(JFrame parent, Relation relation, Constraint cns, boolean edit, Point loc) {
        super(parent, "Constraint Properties", true);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.isEditable = edit;
        this.relationChooser = new RelationChooser(relation, cns, this.isEditable);
        this.relationChooser.setCnsDialog(this);
        this.constraint = cns;
        this.rel = relation;
        if (this.rel == null) {
            this.rel = RelationChooser.newObject(0, cns);
        }
        this.relPanel = this.rel.getEditPanel(edit);
        this.addComponent(this.relationChooser, this, 0, 0, 1, 1, 1.0, 0.0);
        this.customNamePanel = new JPanel();
        this.customNamePanel.setLayout(new BoxLayout(this.customNamePanel, 0));
        this.customNameText = new JTextField("");
        this.customNamePanel.add(new JLabel("Custom Name:\t\t\t "));
        this.customNamePanel.add(this.customNameText);
        if (this.rel.getTypeString().equals("Custom")) {
            this.customNameText.setText(((RelationFactor)this.rel).getLabel());
            this.addComponent(this.customNamePanel, this, 1, 0, 1, 1, 1.0, 0.0);
        } else {
            this.addComponent(new JLabel(), this, 1, 0, 1, 1, 1.0, 0.0);
        }
        this.addComponent(this.relPanel, this, 2, 0, 1, 1, 0.0, 1.0);
        JButton reorderButton = new JButton("Reorder Variables");
        this.addComponent(reorderButton, this, 3, 0, 1, 1, 1.0, 0.0);
        JPanel p = new JPanel();
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        ok.addActionListener(this);
        cancel.addActionListener(this);
        reorderButton.addActionListener(this);
        p.add(ok);
        p.add(cancel);
        this.addComponent(p, this, 4, 0, 1, 1, 0.0, 0.0);
        this.setSize(275, 275);
        this.ensureOnScreen(loc);
        if (parent != null) {
            ((CSPWindow)parent).setPromptLabel("");
        }
        this.setVisible(true);
    }

    public Relation getRelation() {
        return this.rel;
    }

    public void setRelation(Relation rel) {
        this.getContentPane().remove(this.relPanel);
        this.relPanel = rel.getEditPanel(this.isEditable);
        this.addComponent(this.relPanel, this, 2, 0, 1, 1, 0.0, 1.0);
        this.getContentPane().remove(this.customNamePanel);
        if (rel.getTypeString().equals("Custom")) {
            this.customNameText.setText(((RelationFactor)rel).getLabel());
            this.addComponent(this.customNamePanel, this, 1, 0, 1, 1, 1.0, 0.0);
        } else {
            this.addComponent(new JLabel(), this, 1, 0, 1, 1, 1.0, 0.0);
        }
        this.rel = rel;
        this.setSize(275, 275);
        this.validate();
    }

    public void reorder() {
        this.resetRelation();
    }

    public void resetRelation() {
        this.getContentPane().remove(this.relPanel);
        this.rel.reset();
        this.relPanel = this.rel.getEditPanel(this.isEditable);
        this.addComponent(this.relPanel, this, 2, 0, 1, 1, 0.0, 1.0);
        this.getContentPane().remove(this.customNamePanel);
        if (this.rel.getTypeString().equals("Custom")) {
            this.customNameText.setText(((RelationFactor)this.rel).getLabel());
            this.addComponent(this.customNamePanel, this, 1, 0, 1, 1, 1.0, 0.0);
        } else {
            this.addComponent(new JLabel(), this, 1, 0, 1, 1, 1.0, 0.0);
        }
        this.setSize(275, 275);
        this.validate();
    }

    protected boolean actionOK() {
        if (!this.relPanel.ok()) {
            return false;
        }
        if (this.rel.getTypeString().equals("Custom") && !this.customNameText.getText().equals("")) {
            ((RelationFactor)this.rel).setLabel(this.customNameText.getText());
        }
        this.constraint.setRelation(this.rel);
        this.isCancelled = false;
        return true;
    }

    protected boolean actionCancel() {
        this.relPanel.cancel();
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!e.getSource().equals(this.relationChooser) && e.getActionCommand() == "Reorder Variables") {
            new ReorderDialog(this, this.constraint);
        }
    }
}

