/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.domains;

import CIspace.cspTools.Domain;
import CIspace.cspTools.VE.VE_Variable;
import CIspace.cspTools.dialogs.AffirmPanel;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class DomainDiscrete
extends VE_Variable
implements Domain {
    protected int[] splitElements = new int[0];
    protected DomainPanel panel = new DomainPanel(this, true);

    public DomainDiscrete() {
        super("Discrete", new String[0]);
    }

    public String[] getDomain() {
        return this.domain;
    }

    public boolean contains(String l) {
        int i = 0;
        while (i < this.domain.length) {
            if (this.domain[i].equals(l)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getElementString(int i) {
        return this.domain[i];
    }

    public int getSize() {
        return this.domain.length;
    }

    public final int[] getSplitElements() {
        return this.splitElements;
    }

    public final boolean setSplitElements(int[] elements) {
        this.splitElements = elements;
        return true;
    }

    public boolean removeElement(String s) {
        int i = this.index(s);
        if (i > -1) {
            return this.removeElement(i);
        }
        return false;
    }

    public boolean removeElement(int i) {
        if (i < 0 || i >= this.domain.length) {
            return false;
        }
        String[] dom = new String[this.domain.length - 1];
        int j = 0;
        while (j < this.domain.length) {
            if (j != i) {
                if (j < i) {
                    dom[j] = this.domain[j];
                } else {
                    dom[j - 1] = this.domain[j];
                }
            }
            ++j;
        }
        this.domain = dom;
        return true;
    }

    protected boolean addElementAtEnd(String s) {
        String[] dom = new String[this.domain.length + 1];
        int i = 0;
        while (i < this.domain.length) {
            dom[i] = this.domain[i];
            ++i;
        }
        dom[dom.length - 1] = s;
        this.domain = dom;
        return true;
    }

    public int index(String s) {
        int i = 0;
        while (i < this.domain.length) {
            if (this.domain[i].equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final AffirmPanel getEditPanel(boolean edit) {
        return this.panel;
    }

    public void updateDomain() {
        this.panel.changeText(this.getTypeString());
        if (this.getTypeString() != "Boolean" || !this.getRep().equals("")) {
            this.panel.value.setText(this.getRep());
        }
    }

    public String getRep() {
        StringBuffer rep = new StringBuffer();
        if (this.domain == null || this.domain.length == 0) {
            return "";
        }
        int i = 0;
        while (i < this.domain.length - 1) {
            rep.append(this.domain[i]).append(", ");
            ++i;
        }
        rep.append(this.domain[this.domain.length - 1]);
        return rep.toString();
    }

    public String getSplitRep() {
        StringBuffer rep = new StringBuffer();
        if (this.splitElements == null || this.splitElements.length == 0) {
            return "";
        }
        int i = 0;
        while (i < this.splitElements.length - 1) {
            rep.append(this.domain[this.splitElements[i]]).append(" ");
            ++i;
        }
        rep.append(this.domain[this.splitElements[this.splitElements.length - 1]]);
        return rep.toString();
    }

    public int getVisibleDomainSize() {
        if (this.splitElements == null) {
            return 0;
        }
        return this.splitElements.length;
    }

    public final void resetSplit() {
        this.splitElements = new int[this.domain.length];
        int i = 0;
        while (i < this.splitElements.length) {
            this.splitElements[i] = i;
            ++i;
        }
    }

    public final void hide(int j) {
        int[] newSplit = new int[this.splitElements.length - 1];
        int i = 0;
        while (i < this.splitElements.length) {
            if (j > i) {
                newSplit[i] = this.splitElements[i];
            } else if (j < i) {
                newSplit[i - 1] = this.splitElements[i];
            }
            ++i;
        }
        this.splitElements = newSplit;
    }

    public boolean setRand(int j) {
        if (j < 0) {
            j = (int)Math.floor(Math.random() * (double)this.domain.length);
        }
        this.splitElements = new int[j];
        int i = 0;
        ArrayList<Integer> elements = new ArrayList<Integer>();
        while (i < j) {
            Integer element = new Integer((int)Math.floor(Math.random() * (double)this.domain.length));
            if (elements.contains(element)) continue;
            elements.add(element);
            this.splitElements[i] = element;
            ++i;
        }
        return true;
    }

    public boolean set(Object vals) {
        if (!(vals instanceof int[])) {
            return false;
        }
        int[] els = (int[])vals;
        this.setSplitElements(els);
        return true;
    }

    public void clear() {
        this.domain = new String[0];
        this.splitElements = new int[0];
    }

    public abstract boolean addElement(String var1);

    public abstract Object getObject(int var1);

    class DomainPanel
    extends AffirmPanel {
        private DomainDiscrete domain;
        public JTextField value;
        private JLabel title;
        private ArrayList<String> addedValues;
        protected String name = "discrete";
        private JLabel example;

        DomainPanel(DomainDiscrete domain, boolean edit) {
            this.domain = domain;
            this.setLayout(new BoxLayout(this, 0));
            JPanel temp = new JPanel();
            temp.setLayout(new BoxLayout(temp, 1));
            this.title = new JLabel("Domain:               ");
            this.add(this.title);
            this.add(Box.createHorizontalGlue());
            this.value = new JTextField("true, false", 10);
            temp.add(this.value);
            this.add(new JLabel());
            this.addedValues = new ArrayList();
            this.value.setEnabled(edit);
            this.example = new JLabel("Example: true, false");
            temp.add(this.example);
            this.add(temp);
        }

        public void changeText(String s) {
            if (s.equals("Integer")) {
                this.example.setText("Example: 1, 2, 3");
                this.value.setText("");
            } else if (s.equals("String")) {
                this.example.setText("Example: a, b, c");
                this.value.setText("");
            } else {
                this.example.setText("Example: true, false");
            }
            this.repaint();
        }

        public boolean ok() {
            this.addedValues.clear();
            this.addedValues.add(this.value.getText());
            String addVals = "";
            StringTokenizer st = new StringTokenizer(this.value.getText(), ",", false);
            this.domain.clear();
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken().trim();
                if (this.domain.getTypeString() == "Boolean") {
                    if (nextToken.equalsIgnoreCase("true") || nextToken.equalsIgnoreCase("false")) {
                        this.domain.addElement(nextToken);
                        addVals = String.valueOf(addVals) + " " + nextToken;
                        continue;
                    }
                    if (nextToken.equalsIgnoreCase("t")) {
                        this.domain.addElement("true");
                        addVals = String.valueOf(addVals) + " true";
                        continue;
                    }
                    if (!nextToken.equalsIgnoreCase("f")) continue;
                    this.domain.addElement("false");
                    addVals = String.valueOf(addVals) + " false";
                    continue;
                }
                if (nextToken.equals("")) continue;
                nextToken = nextToken.replace(' ', '_');
                this.domain.addElement(nextToken);
                addVals = String.valueOf(addVals) + " " + nextToken;
            }
            return !addVals.equals("");
        }

        public void cancel() {
            for (String s : this.addedValues) {
                this.domain.removeElement(s);
            }
        }
    }
}

