/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.relations;

import CIspace.cspTools.VE.EltsIterator;
import CIspace.cspTools.VE.Factor;
import CIspace.cspTools.VE.FactorUpdatable;
import CIspace.cspTools.dialogs.AffirmPanel;
import CIspace.cspTools.elements.CSPVariable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactorPanel
extends AffirmPanel
implements ActionListener {
    protected FactorUpdatable factor;
    private ArrayList<JButton> probButtons;
    protected String observationString;
    protected ArrayList<ArrayList> context;
    private JLabel headerLabels;
    private int fontSize;
    protected boolean isEditable;
    protected JTable table;
    private JScrollPane scrollPane;
    protected String[] heads;
    private String headers;
    private int[] headerSizes;
    ArrayList<CSPVariable> variables;

    public FactorPanel(FactorUpdatable f, int fSize, ArrayList<CSPVariable> variables, boolean editable) {
        this.factor = f;
        this.fontSize = fSize > 20 ? 20 : fSize;
        this.setLayout(new BorderLayout());
        this.isEditable = editable;
        this.variables = variables;
        this.setPanels();
    }

    private void setPanels() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        GridBagLayout g = new GridBagLayout();
        this.probButtons = new ArrayList(this.factor.size());
        this.context = new ArrayList();
        this.headers = "";
        this.heads = new String[this.variables.size()];
        this.headerSizes = new int[this.variables.size()];
        int i = 0;
        while (i < this.variables.size()) {
            CSPVariable v = this.variables.get(i);
            this.headers = String.valueOf(this.headers) + "         " + v.getName();
            this.headerSizes[i] = v.getName().length();
            this.heads[i] = v.getName();
            ++i;
        }
        this.headerLabels = new JLabel(this.headers);
        this.headerLabels.setFont(new Font("Courier", 0, this.fontSize));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 3.0;
        g.setConstraints(this.headerLabels, c);
        JLabel tempLabel = new JLabel("Value");
        tempLabel.setFont(new Font("Courier", 0, this.fontSize));
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        g.setConstraints(tempLabel, c);
        JPanel title = new JPanel();
        JLabel instructionLabel = this.isEditable ? new JLabel("Customize relation:") : new JLabel("Truth values:");
        instructionLabel.setForeground(Color.red);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)title, "North");
        titlePanel.add((Component)instructionLabel, "South");
        LogicalTableModel lModel = new LogicalTableModel();
        this.table = new JTable(lModel);
        this.table.setCellSelectionEnabled(false);
        this.table.setDragEnabled(false);
        this.table.setEnabled(this.isEditable);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(100, 100));
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)titlePanel, "North");
        this.add((Component)this.scrollPane, "Center");
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isEditable) {
            int i = 0;
            while (i < this.probButtons.size()) {
                if (e.getSource() == this.probButtons.get(i) && this.isEditable) {
                    JButton b = this.probButtons.get(i);
                    String s = b.getText();
                    if (s == "true") {
                        b.setText("false");
                    } else {
                        b.setText("true");
                    }
                }
                ++i;
            }
        }
    }

    public double getValueFor(ArrayList vec, Factor f) {
        EltsIterator iter = f.iterator();
        int[] index = new int[f.getVariables().length];
        while (iter.hasNext()) {
            ArrayList<String> tempVec = new ArrayList<String>(vec.size());
            int i = 0;
            while (i < f.getVariables().length) {
                tempVec.add(f.getVariables()[i].getDomain()[index[i]]);
                ++i;
            }
            boolean isSame = true;
            int i2 = 0;
            while (i2 < tempVec.size() && i2 < vec.size()) {
                if (!((String)tempVec.get(i2)).equals(vec.get(i2))) {
                    isSame = false;
                }
                ++i2;
            }
            if (isSame) {
                return iter.next();
            }
            iter.next();
            if (!iter.hasNext()) continue;
            boolean allMax = true;
            int i3 = f.getVariables().length - 1;
            while (i3 >= 0 && allMax) {
                if (index[i3] < f.getVariables()[i3].getDomain().length - 1) {
                    int n = i3;
                    index[n] = index[n] + 1;
                    int j = i3 + 1;
                    while (j < f.getVariables().length) {
                        index[j] = 0;
                        ++j;
                    }
                    allMax = false;
                }
                --i3;
            }
        }
        return 0.0;
    }

    public void rearrangeValues(EltsIterator iter, String[] headerArray) {
        String headers = "";
        int[] headerSizes = new int[headerArray.length];
        int i = 0;
        while (i < headerArray.length) {
            headers = String.valueOf(headers) + "         " + headerArray[i];
            headerSizes[i] = headerArray[i].length();
            ++i;
        }
        this.headerLabels.setText(headers);
        int counter = 0;
        while (iter.hasNext()) {
            Double prob = new Double(iter.next());
            Double roundProb = new Double((double)Math.round(prob * 10000.0) / 10000.0);
            this.probButtons.get(counter++).setText(roundProb.toString());
        }
    }

    @Override
    public boolean ok() {
        if (this.isEditable) {
            int i = 0;
            while (i < this.factor.size()) {
                if (((Boolean)this.table.getValueAt(i, this.table.getColumnCount() - 1)).booleanValue()) {
                    this.factor.update(i, 1.0);
                } else {
                    this.factor.update(i, 0.0);
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void cancel() {
    }

    class LogicalTableModel
    extends AbstractTableModel {
        final String[] columnNames = this.getCols();
        final Object[][] data = this.getRows();
        private int numrows;

        LogicalTableModel() {
        }

        private String[] getCols() {
            String[] cols = new String[FactorPanel.this.heads.length + 1];
            int i = 0;
            while (i < FactorPanel.this.heads.length) {
                cols[i] = FactorPanel.this.heads[i];
                ++i;
            }
            cols[i] = "True";
            return cols;
        }

        private Object[][] getRows() {
            this.numrows = 1;
            int k = 0;
            while (k < FactorPanel.this.factor.getVariables().length) {
                this.numrows *= FactorPanel.this.factor.getVariables()[k].getDomain().length;
                ++k;
            }
            Object[][] rows = new Object[this.numrows][FactorPanel.this.factor.getVariables().length + 2];
            int[] index = new int[FactorPanel.this.factor.getVariables().length];
            EltsIterator iter = FactorPanel.this.factor.iterator();
            int rowcounter = 0;
            ArrayList<Object> v = new ArrayList<Object>(FactorPanel.this.factor.getVariables().length);
            int counter = 0;
            while (iter.hasNext()) {
                ++counter;
                int i = 0;
                while (i < FactorPanel.this.factor.getVariables().length) {
                    String temp = FactorPanel.this.factor.getVariables()[i].getDomain()[index[i]];
                    if (!temp.equals("Val")) {
                        v.add(temp);
                    }
                    ++i;
                }
                Double prob = new Double(iter.next());
                if (rowcounter < this.numrows) {
                    if (prob == 0.0) {
                        v.add(new Boolean(false));
                        v.add(new Boolean(true));
                    } else {
                        v.add(new Boolean(true));
                        v.add(new Boolean(false));
                    }
                    rows[rowcounter++] = v.toArray();
                }
                counter = 0;
                boolean allMax = true;
                FactorPanel.this.context.add(v);
                v = new ArrayList(FactorPanel.this.factor.getVariables().length);
                int i2 = FactorPanel.this.factor.getVariables().length - 1;
                while (i2 >= 0 && allMax) {
                    if (index[i2] < FactorPanel.this.factor.getVariables()[i2].getDomain().length - 1) {
                        int n = i2;
                        index[n] = index[n] + 1;
                        int j = i2 + 1;
                        while (j < FactorPanel.this.factor.getVariables().length) {
                            index[j] = 0;
                            ++j;
                        }
                        allMax = false;
                    }
                    --i2;
                }
            }
            return rows;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.numrows;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return FactorPanel.this.isEditable && col >= FactorPanel.this.heads.length;
        }

        public void setValueAt(Object value, int row, int col) {
            if (this.data[0][col] instanceof Boolean) {
                this.data[row][col] = value;
            }
            FactorPanel.this.table.repaint();
        }
    }
}

