/*
 * Decompiled with CFR 0.152.
 */
package CIspace.cspTools.relations;

import CIspace.cspTools.Domain;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.cspTools.domains.DomainInteger;
import CIspace.cspTools.elements.CSPVariable;
import CIspace.cspTools.relations.RelationRegular;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationEquality
extends RelationRegular {
    protected abstract boolean testString(String[] var1);

    protected abstract boolean testNumber(float[] var1);

    @Override
    protected boolean testFunction(int[] args, DomainDiscrete[] domains) {
        boolean val = true;
        int vLength = this.factor.getVariables().length;
        String[] vals = new String[vLength];
        int i = 0;
        while (i < vLength) {
            vals[i] = domains[i].getElementString(args[i]);
            ++i;
        }
        try {
            float[] numvals = new float[vals.length];
            int i2 = 0;
            while (i2 < vLength) {
                if (domains[i2] instanceof DomainInteger) {
                    numvals[i2] = ((Integer)domains[i2].getObject(args[i2])).floatValue();
                } else {
                    Float tfloat = new Float(domains[i2].getElementString(args[i2]));
                    numvals[i2] = tfloat.floatValue();
                }
                ++i2;
            }
            val = this.testNumber(numvals);
        }
        catch (NumberFormatException e) {
            val = this.testString(vals);
        }
        return val;
    }

    @Override
    public boolean testDomains(Domain[] domains) {
        int i = 0;
        while (i < domains.length) {
            if (!(domains[i] instanceof DomainInteger)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean testVar(CSPVariable var) {
        return var.getDomain() instanceof DomainInteger;
    }

    public abstract String symbol();

    @Override
    public String getDescription(ArrayList<CSPVariable> variables) {
        if (variables.size() <= 1) {
            return this.getTypeString();
        }
        StringBuffer label = new StringBuffer();
        Iterator<CSPVariable> itr = variables.iterator();
        while (itr.hasNext()) {
            label.append(itr.next().getName());
            if (!itr.hasNext()) continue;
            label.append(this.symbol());
        }
        return label.toString();
    }
}

