/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPgraph;
import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.cspTools.elements.CSPVariable;
import CIspace.cspTools.elements.Constraint;
import CIspace.graphToolKit.elements.Point;
import CIspace.hill.HillHeap;
import CIspace.hill.elements.HillConstraint;
import CIspace.hill.elements.HillVariable;
import CIspace.hill.elements.NodeVal;
import CIspace.hill.elements.NodeVector;
import CIspace.hill.intList.IntList;
import CIspace.hill.intList.IntVector;
import java.awt.Container;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HillCSP
extends CSP {
    public static final int LOW = 0;
    public static final int RAND = 1;
    public static final int PREV = 2;
    public NodeVector redNodes = new NodeVector();
    private HillVariable currNode;
    public int numRedEdges = 0;
    private IntVector xVals = new IntVector();
    private IntVector yVals = new IntVector();
    private IntList vLines;
    public boolean started = false;
    public boolean nodeAndVal = false;
    private HillHeap heap;

    public HillCSP(Container parent, boolean inline) {
        super(parent, inline);
    }

    @Override
    public Constraint newConstraint(CSPgraph graph, Point p, ArrayList<CSPVariable> variables, int draw, CSP csp) {
        HillConstraint cns = new HillConstraint(graph, p, variables, draw, csp);
        return cns;
    }

    @Override
    public CSPVariable newVariable(DomainDiscrete dom, CSPgraph graph, Point p) {
        return new HillVariable(dom, graph, p, this.getName(), this);
    }

    public void turnStruct(boolean on) {
        this.heap = on ? new HillHeap(this) : null;
        this.nodeAndVal = on;
    }

    public HillVariable getRandNode() {
        return (HillVariable)this.variables.get((int)Math.floor(Math.random() * (double)this.variables.size()));
    }

    public int getRandVal(HillVariable node) {
        return (int)Math.floor(Math.random() * (double)node.getDomain().getSize());
    }

    public NodeVal getRandNdVal() {
        return this.heap.getRandNdVal();
    }

    public HillVariable getBestNode() {
        int max = -1;
        ArrayList<HillVariable> nodeVec = new ArrayList<HillVariable>();
        int i = 0;
        while (i < this.redNodes.size()) {
            HillVariable node = this.redNodes.nodeAt(i);
            if (node.getNumRedEdges() > max) {
                nodeVec = new ArrayList();
                max = node.getNumRedEdges();
                nodeVec.add(node);
            } else if (node.getNumRedEdges() == max) {
                nodeVec.add(node);
            }
            ++i;
        }
        HillVariable node = nodeVec.size() == 0 ? null : (HillVariable)nodeVec.get((int)Math.floor(Math.random() * (double)nodeVec.size()));
        return node;
    }

    public int getBestVal(HillVariable node, boolean maintain) {
        int numVals = node.getDomain().getSize();
        ArrayList[] changes = new ArrayList[numVals];
        ArrayList<Integer> candidates = new ArrayList<Integer>(numVals);
        int max = -1;
        int l = 0;
        while (l < numVals) {
            if (maintain || l != node.getCurrIndex()) {
                int numGreen = this.tryValue(l, node, changes);
                if (numGreen > max) {
                    max = numGreen;
                    candidates.clear();
                    candidates.add(new Integer(l));
                } else if (numGreen == max) {
                    candidates.add(new Integer(l));
                }
            }
            ++l;
        }
        int index = (int)Math.floor(Math.random() * (double)candidates.size());
        int newIndex = (Integer)candidates.get(index);
        return newIndex;
    }

    public NodeVal getBestNdVal() {
        return this.heap.getBest();
    }

    public HillVariable getRandRedNode() {
        return this.redNodes.nodeAt((int)Math.floor(Math.random() * (double)this.redNodes.size()));
    }

    public NodeVal getRandRedNdVal() {
        return new NodeVal();
    }

    public void setNode(NodeVal ndvl) {
        HillVariable node = ndvl.getNode();
        int numVals = node.getDomain().getSize();
        ArrayList[] changes = new ArrayList[numVals];
        this.tryValue(ndvl.getValue(), node, changes);
        node.setCurrIndex(ndvl.getValue());
        this.updateNode(node, changes[ndvl.getValue()]);
        if (this.nodeAndVal) {
            this.heap.initHeap();
        }
    }

    public int getBenefit(NodeVal choice) {
        return this.heap.getBenefit(choice);
    }

    private int tryValue(int l, HillVariable node, ArrayList<Integer>[] changes) {
        int numGreen = 0;
        ArrayList<Constraint> cons = node.getConstraints();
        changes[l] = new ArrayList(cons.size());
        int i = 0;
        while (i < cons.size()) {
            HillConstraint cns = (HillConstraint)cons.get(i);
            boolean viable = cns.viable(cns.variableIndex(node), l);
            if (viable) {
                ++numGreen;
            }
            if (cns.isConsistent() != viable) {
                changes[l].add(new Integer(i));
            }
            ++i;
        }
        return numGreen;
    }

    public boolean isCurrent(HillVariable node) {
        if (this.currNode == null) {
            return false;
        }
        return node.equals(this.currNode);
    }

    public void setCurrent(HillVariable node) {
        this.currNode = node;
        if (this.currNode != null) {
            this.currNode.setBold(true);
        }
    }

    public HillVariable getCurrent() {
        return this.currNode;
    }

    public void addToRedNodes(HillVariable node) {
        node.setArrayIndex(this.redNodes.add(node));
    }

    public void removeFromRedNodes(HillVariable node) {
        this.redNodes.remove(node);
    }

    public void checkConsistency(HillConstraint cns) {
        if (!cns.isConsistent()) {
            for (CSPVariable v : cns.getVariables()) {
                HillVariable var = (HillVariable)v;
                var.addNumRedEdges(1);
                if (var.getArrayIndex() != -1) continue;
                this.addToRedNodes(var);
            }
            ++this.numRedEdges;
        }
        if (this.heap != null) {
            this.heap.initHeap();
        }
    }

    public void checkConsistency() {
        this.numRedEdges = 0;
        int i = 0;
        while (i < this.constraints.size()) {
            this.checkConsistency((HillConstraint)this.constraints.get(i));
            ++i;
        }
    }

    public void updateNode(HillVariable node, ArrayList<Integer> changes) {
        int i = 0;
        while (i < changes.size()) {
            HillConstraint cns = (HillConstraint)node.getConstraints().get(changes.get(i));
            ArrayList<CSPVariable> others = new ArrayList<CSPVariable>(cns.getVariables());
            others.remove(node);
            if (cns.isConsistent()) {
                for (CSPVariable v : others) {
                    ((HillVariable)v).addNumRedEdges(-1);
                    ((HillVariable)v).checkColor();
                }
                node.addNumRedEdges(-1);
                --this.numRedEdges;
            } else {
                for (CSPVariable v : others) {
                    ((HillVariable)v).addNumRedEdges(1);
                    ((HillVariable)v).checkColor();
                }
                node.addNumRedEdges(1);
                ++this.numRedEdges;
            }
            cns.checkColor(true);
            ++i;
        }
        node.setLabel();
        node.checkColor();
    }

    public void reset(int init) {
        this.preInitNodes();
        if (init == 1) {
            this.initRandIndices();
        } else if (init == 0) {
            this.initLowIndices();
        }
        this.checkConsistency();
        if (this.nodeAndVal) {
            this.heap = new HillHeap(this);
        }
        this.resetLabels();
        this.checkNodeColors();
    }

    public void preInitNodes() {
        this.started = true;
        int i = 0;
        while (i < this.variables.size()) {
            HillVariable node = (HillVariable)this.variables.get(i);
            node.setArrayIndex(-1);
            node.setNumRedEdges(0);
            ++i;
        }
        this.setCurrBold(false);
        this.currNode = null;
        this.redNodes = new NodeVector();
    }

    public void setCurrBold(boolean isBold) {
        if (this.currNode != null) {
            this.currNode.setBold(isBold);
        }
    }

    public void checkNodeColors() {
        int i = 0;
        while (i < this.variables.size()) {
            ((HillVariable)this.variables.get(i)).checkColor();
            ++i;
        }
        i = 0;
        while (i < this.constraints.size()) {
            ((HillConstraint)this.constraints.get(i)).checkColor(this.started);
            ++i;
        }
    }

    public void initRandIndices() {
        int i = 0;
        while (i < this.variables.size()) {
            ((HillVariable)this.variables.get(i)).getDomain().setRand(1);
            ++i;
        }
    }

    public void initLowIndices() {
        int i = 0;
        while (i < this.variables.size()) {
            ((HillVariable)this.variables.get(i)).getDomain().set(new int[1]);
            ++i;
        }
    }

    public IntVector[] getPlotVals() {
        IntVector[] tmp = new IntVector[]{this.xVals, this.yVals};
        return tmp;
    }

    public void addPoint(int x, int y) {
        this.xVals.add(x);
        this.yVals.add(y);
    }

    public void addLine(int x) {
        if (x != 0) {
            this.vLines.add(x);
        }
    }

    public void addPlotPoint(int step) {
        this.addPoint(step, this.numRedEdges);
    }

    public void removePlotPoints(int step) {
        int length = this.xVals.size();
        int i = length - 1;
        while (i > step) {
            this.xVals.removeElementAt(i);
            this.yVals.removeElementAt(i);
            --i;
        }
    }

    public void resetPlotVals() {
        this.xVals = new IntVector();
        this.yVals = new IntVector();
    }
}

