/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPcanvas;
import CIspace.graphToolKit.elements.Entity;
import CIspace.graphToolKit.elements.Node;
import CIspace.graphToolKit.elements.Point;
import CIspace.hill.HillCSP;
import CIspace.hill.HillEngine;
import CIspace.hill.HillWindow;
import CIspace.hill.NodeDetailFrame;
import CIspace.hill.elements.HillConstraint;
import CIspace.hill.elements.HillVariable;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;

public class HillCanvas
extends CSPcanvas {
    protected JMenuItem showTrace;
    protected JMenuItem initialize;
    protected NodeDetailFrame cFrame;
    protected JMenuItem step;
    protected JMenuItem finestep;
    protected JMenuItem auto;
    protected JMenuItem stop;
    protected JMenuItem showPlot;
    protected JMenuItem batch;
    public HillEngine engine;

    public HillCanvas(Container parent, boolean inline, CSP csp) {
        super(parent, inline, csp);
        this.engine = new HillEngine((HillCSP)csp, this);
        this.initialize = new JMenuItem("Initialize");
        this.initialize.setActionCommand(this.initialize.getText());
        this.initialize.addActionListener(this);
        this.step = new JMenuItem("Step");
        this.step.setActionCommand(this.step.getText());
        this.step.addActionListener(this);
        this.finestep = new JMenuItem("Fine Step");
        this.finestep.setActionCommand(this.finestep.getText());
        this.finestep.addActionListener(this);
        this.auto = new JMenuItem("Auto Solve");
        this.auto.setActionCommand(this.auto.getText());
        this.auto.addActionListener(this);
        this.batch = new JMenuItem("Batch Run");
        this.batch.setActionCommand(this.batch.getText());
        this.batch.addActionListener(this);
        this.stop = new JMenuItem("Stop");
        this.stop.setActionCommand(this.stop.getText());
        this.stop.addActionListener(this);
        this.showPlot = new JMenuItem("Show Plot");
        this.showPlot.setActionCommand(this.showPlot.getText());
        this.showPlot.addActionListener(this);
        this.showTrace = new JMenuItem("Show Trace");
        this.showTrace.setActionCommand(this.showTrace.getText());
        this.showTrace.addActionListener(this);
    }

    protected void aSolvePerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Initialize")) {
            ((HillWindow)this.parent).initializeGraph();
        } else if (arg.equals("Step")) {
            ((HillWindow)this.parent).step();
        } else if (arg.equals("Fine Step")) {
            ((HillWindow)this.parent).fineStep();
        } else if (arg.equals("Auto Solve")) {
            ((HillWindow)this.parent).autoSolveStart();
        } else if (arg.equals("Stop")) {
            ((HillWindow)this.parent).autoSolveStop();
        } else if (arg.equals("Batch Run")) {
            ((HillWindow)this.parent).batchRunStart();
        } else if (arg.equals("Show Plot")) {
            ((HillWindow)this.parent).showPlot();
        } else if (arg.equals("Show Trace")) {
            ((HillWindow)this.parent).showTrace();
        } else {
            super.aSolvePerformed(e);
        }
    }

    protected void popupSCanv() {
        this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
        this.pop.add(this.initialize);
        this.pop.add(this.finestep);
        this.pop.add(this.step);
        this.pop.add(this.auto);
        this.pop.add(this.batch);
        this.pop.add(this.stop);
        this.pop.add(this.showPlot);
        this.pop.add(this.showTrace);
        this.pop.addSeparator();
        this.popupStands();
    }

    public void enableButtons(boolean bool) {
        this.step.setEnabled(bool);
        this.finestep.setEnabled(bool);
        this.auto.setEnabled(bool);
        this.stop.setEnabled(!bool);
        this.showPlot.setEnabled(bool);
        this.batch.setEnabled(bool);
    }

    public void enableInit(boolean bool) {
        this.step.setEnabled(bool);
        this.finestep.setEnabled(bool);
        this.auto.setEnabled(bool);
        this.stop.setEnabled(false);
        this.showPlot.setEnabled(bool);
        this.batch.setEnabled(!bool);
    }

    public void setButtonsSolved(boolean boolSolved) {
        this.step.setEnabled(!boolSolved);
        if (!this.engine.fineStepAllowed()) {
            this.finestep.setEnabled(false);
        } else {
            this.finestep.setEnabled(!boolSolved);
        }
        this.auto.setEnabled(!boolSolved);
        this.stop.setEnabled(!boolSolved);
    }

    public void reset() {
        super.reset();
        this.engine.resetCSP((HillCSP)this.csp);
    }

    public void setSpeed(int speed) {
        this.engine.dt = speed;
    }

    public int getSpeed() {
        return this.engine.dt;
    }

    public void hideConflictFrame() {
        if (this.cFrame != null) {
            this.cFrame.dispose();
        }
    }

    public void disposeWindows() {
        super.disposeWindows();
        if (this.cFrame != null) {
            this.cFrame.dispose();
        }
    }

    public void updateConflicts() {
        if (this.cFrame != null) {
            this.cFrame.repaint();
        }
    }

    public void changeFont(int size) {
        super.changeFont(size);
        if (this.engine.trace != null) {
            this.engine.trace.getDisplay().setFont(new Font("Monospaced", 0, size));
            this.engine.trace.getDisplay().repaint();
        }
        this.updateNodeDetailFrame();
    }

    public void changeLineWidth() {
        super.changeLineWidth();
        this.updateNodeDetailFrame();
    }

    public void updateNodeDetailFrame() {
        if (this.cFrame != null) {
            this.cFrame.update();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.engine.autoSolveAlive() || this.engine.batchRunAlive()) {
            return;
        }
        super.mouseClicked(e);
        if (e.getModifiers() == 4) {
            return;
        }
        this.openConflictFrame(this.graph.searchEntities(new Point(e.getX(), e.getY())));
    }

    private void openConflictFrame(Entity ent) {
        if (this.mode == 2221 && ent != null && ent instanceof Node && ((HillCSP)this.csp).started) {
            if (ent instanceof HillVariable) {
                if (this.cFrame == null) {
                    this.cFrame = new NodeDetailFrame(this.parent, (HillCSP)this.csp, this);
                }
                this.cFrame.open((HillVariable)ent);
                this.repaint();
            } else if (ent instanceof HillConstraint) {
                this.inspectConstraint((HillConstraint)ent);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.engine.autoSolveAlive() || this.engine.batchRunAlive()) {
            return;
        }
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (this.engine.autoSolveAlive() || this.engine.batchRunAlive()) {
            return;
        }
        super.mouseReleased(e);
    }

    public void mouseEntered(MouseEvent e) {
        if (this.engine.autoSolveAlive() || this.engine.batchRunAlive()) {
            return;
        }
        super.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        if (this.engine.autoSolveAlive() || this.engine.batchRunAlive()) {
            return;
        }
        super.mouseExited(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (this.engine.autoSolveAlive() || this.engine.batchRunAlive()) {
            return;
        }
        super.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.engine.autoSolveAlive() || this.engine.batchRunAlive()) {
            return;
        }
        super.mouseDragged(e);
    }
}

