/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.cspTools.CSPWindow;
import CIspace.cspTools.elements.CSPVariable;
import CIspace.graphToolKit.GraphConsts;
import CIspace.hill.HillCSP;
import CIspace.hill.HillCanvas;
import CIspace.hill.HillWindow;
import CIspace.hill.InlineHillApplet;
import CIspace.hill.PlotFrame;
import CIspace.hill.SolveCanvas;
import CIspace.hill.batch.BatchCanvas;
import CIspace.hill.batch.BatchRun;
import CIspace.hill.batch.BatchStep;
import CIspace.hill.dialogs.OptionsDialog;
import CIspace.hill.dialogs.TraceFrame;
import CIspace.hill.intList.IntVector;
import CIspace.hill.search.AutoSolve;
import CIspace.hill.search.GreedyRandomRestartSearch;
import CIspace.hill.search.GreedyRandomWalkSearch;
import CIspace.hill.search.GreedySearch;
import CIspace.hill.search.MinConflictHeuristicSearch;
import CIspace.hill.search.RandomSearch;
import CIspace.hill.search.RandomWalkSearch;
import CIspace.hill.search.Search;
import CIspace.hill.search.SimpleRandomSearch;
import CIspace.hill.search.SimulatedAnnealingSearch;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HillEngine {
    public HillCanvas canvas;
    private HillCSP csp;
    private PlotFrame pFrame;
    private PlotFrame bFrame;
    private int stepsCurrentlyTaken;
    private int stepsTotalTaken;
    private int stepsForBatchRunPlotting;
    private Search[] searchAlgs;
    private int currSearch;
    public int dt = 500;
    public AutoSolve auto;
    private BatchRun batchRun;
    public TraceFrame trace;
    private int batchRunCount;
    private ArrayList<BatchStep> batchSteps;
    private boolean completed;
    private long startTime;
    private long time;
    private boolean successful;
    private int maxSteps;
    public int maxBatchCount = 100;
    public int giveUp = 100;
    public int init = 1;

    public HillEngine(HillCSP csp, HillCanvas canvas) {
        this.csp = csp;
        this.canvas = canvas;
        this.stepsTotalTaken = 0;
        this.stepsCurrentlyTaken = 0;
        this.searchAlgs = new Search[8];
        this.searchAlgs[0] = new RandomSearch(this);
        this.searchAlgs[1] = new RandomWalkSearch(this);
        this.searchAlgs[2] = new GreedySearch(this);
        this.searchAlgs[3] = new MinConflictHeuristicSearch(this);
        this.searchAlgs[4] = new GreedyRandomWalkSearch(this);
        this.searchAlgs[5] = new GreedyRandomRestartSearch(this);
        this.searchAlgs[6] = new SimpleRandomSearch(this);
        this.searchAlgs[7] = new SimulatedAnnealingSearch(this);
        this.currSearch = 2;
        this.batchSteps = new ArrayList();
    }

    public void resetStepCount() {
        this.stepsTotalTaken = 0;
        this.stepsCurrentlyTaken = 0;
    }

    public HillCSP getCSP() {
        return this.csp;
    }

    public void resetCSP(HillCSP csp) {
        this.csp = csp;
    }

    public boolean highLight() {
        return !this.batchRunAlive();
    }

    public void step() {
        if (!this.isStoppingCriteriaMet()) {
            this.searchAlgs[this.currSearch].step();
            if (!(this.pFrame == null || this.dt == 0 && this.auto != null && this.auto.running)) {
                this.pFrame.repaint(false);
            }
            if (!this.batchRunAlive()) {
                if (this.trace != null) {
                    this.trace.addAssig(this.csp);
                }
                if (!this.isStoppingCriteriaMet()) {
                    this.setPromptLabel("Step Performed, step = " + this.stepsTotalTaken);
                } else {
                    this.setPromptLabel("Solution reached after " + this.stepsTotalTaken + " steps");
                    if (!this.canvas.inline) {
                        ((HillWindow)this.canvas.parent).setButtonsSolved(true);
                    } else {
                        ((InlineHillApplet)this.canvas.parent).setButtonsSolved(true);
                    }
                    if (this.pFrame != null) {
                        this.pFrame.setButtonsSolved(true);
                    }
                }
            }
        } else {
            this.setPromptLabel("Solution reached after " + this.stepsTotalTaken + " steps");
        }
        if (!this.batchRunAlive()) {
            this.canvas.repaint();
        }
    }

    public void finestep() {
        if (!this.isStoppingCriteriaMet()) {
            this.searchAlgs[this.currSearch].finestep();
            if (this.pFrame != null && this.dt != 0) {
                this.pFrame.repaint(false);
            }
            if (!this.isStoppingCriteriaMet()) {
                this.setPromptLabel("Fine Step Performed, step = " + this.stepsTotalTaken);
            } else {
                this.setPromptLabel("Solution reached after " + this.stepsTotalTaken + " steps");
                if (!this.canvas.inline) {
                    ((HillWindow)this.canvas.parent).setButtonsSolved(true);
                } else {
                    ((InlineHillApplet)this.canvas.parent).setButtonsSolved(true);
                }
                if (this.pFrame != null) {
                    this.pFrame.setButtonsSolved(true);
                }
            }
        } else {
            this.setPromptLabel("Solution reached after " + this.stepsTotalTaken + " steps");
        }
    }

    public void addTraceEntry() {
        if (this.trace != null) {
            this.trace.addAssig(this.csp);
        }
    }

    public void restart() {
        this.setPromptLabel("Step 1 - Initialized");
        this.resetStepCount();
        this.incrementCount();
        this.csp.resetPlotVals();
        this.reset();
        if (this.trace == null) {
            this.trace = !this.canvas.inline ? new TraceFrame((Container)((HillWindow)this.canvas.parent), this) : new TraceFrame((InlineHillApplet)this.canvas.parent, this);
        }
        this.trace.init(this.csp);
        if (this.pFrame != null) {
            this.pFrame.setButtonsSolved(this.isStoppingCriteriaMet());
        }
        if (!this.canvas.inline) {
            ((HillWindow)this.canvas.parent).setButtonsSolved(this.isStoppingCriteriaMet());
        } else {
            ((InlineHillApplet)this.canvas.parent).setButtonsSolved(this.isStoppingCriteriaMet());
        }
        this.csp.checkNodeColors();
    }

    public void openTrace() {
        this.trace.open(true);
    }

    public void reset() {
        this.searchAlgs[this.currSearch].reset();
        this.csp.reset(this.init);
        this.csp.addPlotPoint(this.stepsTotalTaken);
        if (this.pFrame != null) {
            this.pFrame.repaint(false);
        }
    }

    public void setSteps(int step) {
        this.stepsTotalTaken = step;
        this.stepsCurrentlyTaken = 0;
        this.csp.removePlotPoints(step);
        if (this.pFrame != null) {
            this.pFrame.repaint(false);
        }
        this.csp.checkConsistency();
        this.canvas.repaint();
        if (!this.canvas.inline) {
            ((HillWindow)this.canvas.parent).setButtonsSolved(this.isStoppingCriteriaMet());
        } else {
            ((InlineHillApplet)this.canvas.parent).setButtonsSolved(this.isStoppingCriteriaMet());
        }
        if (this.pFrame != null) {
            this.pFrame.setButtonsSolved(this.isStoppingCriteriaMet());
        }
    }

    public int getSteps() {
        return this.stepsTotalTaken;
    }

    public Search[] getSearchAlgs() {
        return this.searchAlgs;
    }

    public Search getCurrSearch() {
        return this.searchAlgs[this.currSearch];
    }

    public void setSearchAlg(int i) {
        this.currSearch = i;
        this.searchAlgs[this.currSearch].turnOnStruct();
    }

    public int getSearchIndex() {
        return this.currSearch;
    }

    public int getSearchAlg() {
        return this.currSearch;
    }

    public void setMaxSteps(int steps) {
        this.maxSteps = steps;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public boolean fineStepAllowed() {
        return this.searchAlgs[this.currSearch].fineStep();
    }

    public void autoSolveStart() {
        if (!this.batchRunAlive()) {
            this.maxSteps = this.searchAlgs[this.currSearch].getMaxSteps();
            if (!this.canvas.inline) {
                ((HillWindow)this.canvas.parent).enableAuto(false);
            } else {
                ((InlineHillApplet)this.canvas.parent).enableAuto(false);
            }
        } else {
            this.startTime = System.nanoTime();
        }
        if (this.pFrame != null) {
            this.pFrame.enableButtons(false);
        }
        if (this.bFrame != null) {
            this.bFrame.enableButtons(false);
        }
        if (this.stepsTotalTaken <= 0) {
            if (this.pFrame != null) {
                this.pFrame.clear();
            }
            this.csp.addPlotPoint(0);
        }
        this.auto = new AutoSolve(this);
        this.auto.start();
    }

    public void resetAutoSolve() {
        this.stopAutoSolve();
        this.auto = null;
    }

    public void stopAutoSolve() {
        if (this.auto == null) {
            return;
        }
        if (this.auto.isAlive()) {
            this.auto.quit();
        }
        this.stopBatchRun();
        if (!this.canvas.inline) {
            ((HillWindow)this.canvas.parent).enableBatch(true);
        } else {
            ((InlineHillApplet)this.canvas.parent).enableBatch(true);
        }
        if (this.pFrame != null) {
            this.pFrame.enableButtons(true);
        }
        if (this.bFrame != null) {
            this.bFrame.enableButtons(true);
        }
    }

    public boolean autoSolveContinue() {
        if (this.stepsCurrentlyTaken >= this.giveUp) {
            this.stepsForBatchRunPlotting = this.stepsCurrentlyTaken;
            if (!this.batchRunAlive()) {
                this.setPromptLabel("No solution found after " + this.stepsTotalTaken + " steps.");
            } else {
                this.time = (System.nanoTime() - this.startTime) / 1000000L;
            }
            return false;
        }
        if (this.isStoppingCriteriaMet()) {
            if (!this.batchRunAlive()) {
                if (this.stepsCurrentlyTaken <= 0) {
                    this.stepsTotalTaken = 0;
                    this.stepsCurrentlyTaken = 0;
                    this.setPromptLabel("Solution Reached after 0 steps.");
                } else {
                    this.setPromptLabel("Solution Reached after " + this.stepsTotalTaken + " steps.\n Solution found:\t " + this.getSolutions());
                }
            } else {
                this.successful = true;
                this.time = (System.nanoTime() - this.startTime) / 1000000L;
            }
            this.stepsForBatchRunPlotting = this.stepsCurrentlyTaken;
            return false;
        }
        return true;
    }

    public void autoSolveStep() {
        this.step();
    }

    public void autoSolveEnd() {
        if (!this.batchRunAlive()) {
            if (!this.canvas.inline) {
                ((HillWindow)this.canvas.parent).enableBatch(true);
                if (this.isStoppingCriteriaMet()) {
                    ((HillWindow)this.canvas.parent).setButtonsSolved(true);
                }
            } else {
                ((InlineHillApplet)this.canvas.parent).enableBatch(true);
                if (this.isStoppingCriteriaMet()) {
                    ((InlineHillApplet)this.canvas.parent).setButtonsSolved(true);
                }
            }
            if (this.pFrame != null) {
                this.pFrame.setButtonsSolved(this.isStoppingCriteriaMet());
            }
            if (this.bFrame != null) {
                this.bFrame.enableButtons(this.isStoppingCriteriaMet());
            }
        }
        if (this.pFrame != null && !this.batchRunAlive()) {
            this.pFrame.redraw();
        }
        this.canvas.parent.setCursor(GraphConsts.DEFAULT_CURSOR);
        this.stepsCurrentlyTaken = 0;
    }

    public boolean autoSolveAlive() {
        if (this.auto == null) {
            return false;
        }
        return this.auto.isAlive();
    }

    public String getSolutions() {
        StringBuffer solBuffer = new StringBuffer();
        Iterator<CSPVariable> itr = !this.canvas.inline ? ((HillWindow)this.canvas.parent).returnCSP().getVariables().iterator() : ((InlineHillApplet)this.canvas.parent).returnCSP().getVariables().iterator();
        while (itr.hasNext()) {
            CSPVariable curVar = itr.next();
            solBuffer.append(" ").append(curVar.getName()).append(" = ").append(curVar.getDomain().getSplitRep());
            if (!itr.hasNext()) continue;
            solBuffer.append(",");
        }
        return solBuffer.toString();
    }

    public boolean isStoppingCriteriaMet() {
        return this.csp.numRedEdges == 0;
    }

    public void setPromptLabel(String s) {
        if (this.canvas.inline) {
            ((InlineHillApplet)this.canvas.parent).setPromptLabel(s);
        } else {
            ((CSPWindow)this.canvas.parent).setPromptLabel(s);
        }
    }

    public void showPlot() {
        if (this.pFrame != null) {
            if (this.pFrame.isVisible()) {
                this.pFrame.setVisible(true);
                return;
            }
            this.pFrame.dispose();
            this.pFrame = null;
        }
        this.pFrame = !this.canvas.inline ? new PlotFrame((HillWindow)this.canvas.parent, this, false) : new PlotFrame((InlineHillApplet)this.canvas.parent, this, false);
        if (this.auto != null && this.auto.isAlive()) {
            this.pFrame.enableButtons(false);
        }
        this.pFrame.open();
    }

    public IntVector[] getPlotVals() {
        return this.csp.getPlotVals();
    }

    public int getCurrentStepCount() {
        return this.stepsTotalTaken;
    }

    public void incrementCount() {
        ++this.stepsCurrentlyTaken;
        ++this.stepsTotalTaken;
    }

    public void clearPlotPts(boolean batch) {
        if (batch) {
            this.batchSteps = new ArrayList();
        } else {
            this.csp.resetPlotVals();
        }
    }

    public void batchRun() {
        if (!this.canvas.inline) {
            ((HillWindow)this.canvas.parent).closeTrace();
            ((HillWindow)this.canvas.parent).closePlot();
            ((HillWindow)this.canvas.parent).enableBatch(false);
        } else {
            ((InlineHillApplet)this.canvas.parent).closeTrace();
            ((InlineHillApplet)this.canvas.parent).closePlot();
            ((InlineHillApplet)this.canvas.parent).enableBatch(false);
        }
        if (this.pFrame != null) {
            this.pFrame.enableButtons(false);
        }
        if (this.bFrame != null) {
            this.bFrame.enableButtons(false);
        } else {
            this.bFrame = !this.canvas.inline ? new PlotFrame((HillWindow)this.canvas.parent, this, true) : new PlotFrame((InlineHillApplet)this.canvas.parent, this, true);
        }
        this.bFrame.open();
        this.batchRunCount = 0;
        this.maxSteps = this.searchAlgs[this.currSearch].getMaxSteps();
        this.successful = false;
        this.completed = false;
        this.batchSteps.add(new BatchStep(this.searchAlgs[this.currSearch].getSettings(), this.getSettings()));
        this.setPromptLabel("Batch Run ...");
        this.csp.setCurrent(null);
        this.batchRun = new BatchRun(this);
        this.batchRun.start();
    }

    public boolean batchRunContinue() {
        return this.batchRunCount < this.maxBatchCount;
    }

    public int getMaxBatchCount() {
        return this.maxBatchCount;
    }

    public PlotFrame getBatchFrame() {
        if (this.bFrame != null) {
            return this.bFrame;
        }
        return null;
    }

    public PlotFrame getPlotFrame() {
        if (this.pFrame != null) {
            return this.pFrame;
        }
        return null;
    }

    public void closePlotFrame() {
        if (this.pFrame != null) {
            this.pFrame.setVisible(false);
            this.resetAutoSolve();
            this.pFrame.dispose();
            this.pFrame = null;
        }
    }

    public BatchCanvas getBatchCanvas() {
        if (this.bFrame != null) {
            return this.bFrame.getBatchCanvas();
        }
        return null;
    }

    public SolveCanvas getSolveCanvas() {
        if (this.pFrame != null) {
            return this.pFrame.getSolveCanvas();
        }
        return null;
    }

    public void batchRunStep() {
        this.successful = false;
        this.csp.resetPlotVals();
        this.reset();
        this.resetStepCount();
        this.autoSolveStart();
        while (this.autoSolveAlive()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                System.out.println(e);
            }
        }
        ++this.batchRunCount;
        try {
            this.batchSteps.get(this.batchSteps.size() - 1).add(this.stepsForBatchRunPlotting, (int)this.time, this.successful);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.bFrame.repaint(true);
    }

    public void stopBatchRun() {
        if (this.batchRun == null) {
            return;
        }
        if (this.batchRun.isAlive()) {
            this.batchRun.quit();
        }
    }

    public void batchRunEnd() {
        this.completed = true;
        try {
            this.batchSteps.get(this.batchSteps.size() - 1).endRun();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.bFrame.repaint(true);
        this.bFrame.redraw();
        if (!this.canvas.inline) {
            ((HillWindow)this.canvas.parent).enableBatch(true);
            if (this.isStoppingCriteriaMet()) {
                ((HillWindow)this.canvas.parent).setButtonsSolved(true);
            }
        } else {
            ((InlineHillApplet)this.canvas.parent).enableBatch(true);
            if (this.isStoppingCriteriaMet()) {
                ((InlineHillApplet)this.canvas.parent).setButtonsSolved(true);
            }
        }
        if (this.bFrame != null) {
            this.bFrame.enableButtons(true);
        }
        if (this.pFrame != null) {
            this.pFrame.enableButtons(true);
        }
        if (!this.canvas.inline) {
            ((HillWindow)this.canvas.parent).setPromptLabel("Batch Run ended.");
        }
        this.canvas.repaint();
    }

    public void repaintCanvas() {
        this.canvas.updateNodeDetailFrame();
        this.canvas.repaint();
    }

    public boolean batchRunAlive() {
        if (this.batchRun == null) {
            return false;
        }
        return this.batchRun.isAlive();
    }

    public ArrayList<BatchStep> getBatchSteps() {
        return this.batchSteps;
    }

    public boolean getCompleted() {
        return this.completed;
    }

    public void openHeurOptions(HillWindow window) {
        new OptionsDialog(this, window).open();
    }

    public String[][] getSettings() {
        String[][] settings = new String[2][3];
        settings[0][0] = "Algorithm:";
        settings[0][1] = "Steps before giving up:";
        settings[1][0] = this.searchAlgs[this.currSearch].getName();
        settings[1][1] = "" + this.giveUp;
        settings[1][2] = "";
        settings[0][2] = "";
        return settings;
    }

    public void turnStruct(boolean on) {
        this.csp.turnStruct(on);
    }
}

