/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.cspTools.elements.CSPVariable;
import CIspace.cspTools.elements.Constraint;
import CIspace.hill.HillCSP;
import CIspace.hill.elements.HillConstraint;
import CIspace.hill.elements.HillVariable;
import CIspace.hill.elements.NodeVal;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HillHeap {
    private HillCSP csp;
    private int numVals;
    private int heapSize;
    private NodeVal[] heap;
    private ArrayList<NodeVal> candidates;
    private int maxImprovement;

    public HillHeap(HillCSP csp) {
        this.csp = csp;
        this.initHeap();
    }

    public void initHeap() {
        this.initElements();
        this.heapSize = this.initNumVals();
        this.startHeap();
    }

    private int initNumVals() {
        this.numVals = 0;
        for (CSPVariable v : this.csp.getVariables()) {
            this.numVals += ((HillVariable)v).getDomain().getSize();
        }
        return this.numVals;
    }

    private void initElements() {
        for (CSPVariable v : this.csp.getVariables()) {
            ((HillVariable)v).initHeapIndices();
        }
    }

    private void startHeap() {
        this.heap = new NodeVal[this.numVals];
        int heapIndex = 0;
        for (Constraint c : this.csp.getConstraints()) {
            HillConstraint cns = (HillConstraint)c;
            boolean consistent = cns.isConsistent();
            ArrayList<CSPVariable> vars = cns.getVariables();
            int j = 0;
            while (j < vars.size()) {
                HillVariable curr = (HillVariable)vars.get(j);
                int i = 0;
                while (i < curr.getDomain().getSize()) {
                    boolean currConsistent = cns.viable(j, i);
                    int change = currConsistent == consistent ? 0 : (currConsistent ? 1 : -1);
                    if (curr.getHeapIndex(i) == -1) {
                        this.heap[heapIndex] = new NodeVal(curr, i, change);
                        curr.setHeapIndex(i, heapIndex++);
                    } else {
                        int currHeapIndex = curr.getHeapIndex(i);
                        this.heap[currHeapIndex].setNumGreenEdges(this.heap[currHeapIndex].getNumGreenEdges() + change);
                    }
                    ++i;
                }
                ++j;
            }
        }
        this.heapify();
    }

    private void heapify() {
        int i = 0;
        while (i < this.numVals) {
            this.percolate(i);
            ++i;
        }
    }

    private void percolate(int i) {
        int pos = i;
        int parent = (pos - 1) / 2;
        while (pos != 0 && this.heap[pos].getNumGreenEdges() >= this.heap[parent].getNumGreenEdges()) {
            if (this.heap[pos].getNumGreenEdges() == this.heap[parent].getNumGreenEdges() && Math.random() >= 0.5) break;
            NodeVal tmp = this.heap[parent];
            this.heap[parent] = this.heap[pos];
            this.heap[pos] = tmp;
            this.heap[parent].getNode().setHeapIndex(this.heap[parent].getValue(), parent);
            this.heap[pos].getNode().setHeapIndex(this.heap[pos].getValue(), pos);
            pos = parent;
            parent = (pos - 1) / 2;
        }
    }

    private void percolateDown(int i) {
        int pos = i;
        int children = pos * 2 + 1;
        while (children < this.heapSize && (this.heap[pos].getNumGreenEdges() < this.heap[children].getNumGreenEdges() || children + 1 < this.heapSize && this.heap[pos].getNumGreenEdges() < this.heap[children + 1].getNumGreenEdges())) {
            NodeVal tmp = this.heap[pos];
            int child = this.heap[pos].getNumGreenEdges() < this.heap[children].getNumGreenEdges() ? children : children + 1;
            this.heap[pos] = this.heap[child];
            this.heap[child] = tmp;
            this.heap[child].getNode().setHeapIndex(this.heap[child].getValue(), child);
            this.heap[pos].getNode().setHeapIndex(this.heap[pos].getValue(), pos);
            pos = child;
            children = pos * 2 + 1;
        }
    }

    public NodeVal getRandNdVal() {
        return this.getRandNdVal(Math.random());
    }

    public NodeVal getRandNdVal(double rand) {
        return this.heap[(int)(rand * (double)this.heapSize)];
    }

    public NodeVal getBest() {
        this.candidates = new ArrayList();
        this.heapify();
        this.maxImprovement = -10000000;
        this.getMaxImprovement(this.heap, 0);
        this.getCandidates(this.heap, 0, this.maxImprovement);
        int index = (int)Math.floor(Math.random() * (double)this.candidates.size());
        return this.candidates.get(index);
    }

    private void getMaxImprovement(NodeVal[] heap, int position) {
        if (position > this.heapSize - 1) {
            return;
        }
        if (heap[position].getValue() != heap[position].getNode().getCurrIndex() && this.getBenefit(heap[position]) > this.maxImprovement) {
            this.maxImprovement = this.getBenefit(heap[position]);
        }
        this.getMaxImprovement(heap, position * 2 + 1);
        this.getMaxImprovement(heap, position * 2 + 2);
    }

    private void getCandidates(NodeVal[] heap, int position, int maxImprovement) {
        if (position > this.heapSize - 1) {
            return;
        }
        if (this.getBenefit(heap[position]) < maxImprovement) {
            return;
        }
        if (heap[position].getValue() != heap[position].getNode().getCurrIndex()) {
            this.candidates.add(heap[position]);
        }
        this.getCandidates(heap, position * 2 + 1, maxImprovement);
        this.getCandidates(heap, position * 2 + 2, maxImprovement);
    }

    public int getBenefit(NodeVal ndvl) {
        return this.heap[ndvl.getNode().getHeapIndex(ndvl.getValue())].getNumGreenEdges();
    }

    public void change(HillVariable node, int value) {
        this.initHeap();
        ArrayList[] changes = this.adjustVals(node, value);
        this.adjustHeap(changes);
        changes = this.adjustConnectedVals(node, value);
        this.adjustHeap(changes);
    }

    private ArrayList<NodeVal>[] adjustVals(HillVariable node, int value) {
        int index;
        ArrayList[] changes = new ArrayList[]{new ArrayList(), new ArrayList()};
        ArrayList<Constraint> edges = node.getConstraints();
        int sizeNode = node.getDomain().getSize();
        int[] elmChanges = new int[sizeNode];
        int[] elmCurrent = new int[sizeNode];
        int i = 0;
        while (i < sizeNode) {
            elmChanges[i] = 0;
            index = node.getHeapIndex(i);
            elmCurrent[i] = this.heap[index].getNumGreenEdges();
            ++i;
        }
        i = 0;
        while (i < edges.size()) {
            HillConstraint cns = (HillConstraint)edges.get(i);
            int index2 = cns.index(node);
            boolean now = cns.viable(index2, value);
            int j = 0;
            while (j < sizeNode) {
                boolean after = cns.viable(index2, j);
                if (now) {
                    if (!after) {
                        int n = j;
                        elmChanges[n] = elmChanges[n] - 1;
                    }
                } else if (after) {
                    int n = j;
                    elmChanges[n] = elmChanges[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sizeNode) {
            index = node.getHeapIndex(i);
            this.heap[index].setNumGreenEdges(elmChanges[i]);
            if (elmChanges[i] - elmCurrent[i] > 0) {
                changes[0].add(this.heap[index]);
            }
            ++i;
        }
        return changes;
    }

    private ArrayList<NodeVal>[] adjustConnectedVals(HillVariable node, int value) {
        ArrayList[] changes = new ArrayList[]{new ArrayList(), new ArrayList()};
        ArrayList<Constraint> edges = node.getConstraints();
        int i = 0;
        while (i < edges.size()) {
            HillConstraint edge = (HillConstraint)edges.get(i);
            int[] oldAssig = edge.getAssig();
            int ndIndex = edge.index(node);
            boolean then = edge.isConsistent();
            boolean now = edge.viable(ndIndex, value);
            for (CSPVariable v : edge.getVariables()) {
                HillVariable curr = (HillVariable)v;
                int sizeNode = curr.getDomain().getSize();
                int j = 0;
                while (j < sizeNode) {
                    int index = curr.getHeapIndex(j);
                    NodeVal otherNdVl = this.heap[index];
                    int currIndex = edge.index(curr);
                    int[] assig = new int[oldAssig.length];
                    int z = 0;
                    while (i < assig.length) {
                        assig[z] = oldAssig[z];
                        ++i;
                    }
                    assig[currIndex] = j;
                    boolean before = edge.getAllowed(assig);
                    assig[ndIndex] = value;
                    boolean after = edge.getAllowed(assig);
                    int change = 0;
                    if (then == before) {
                        if (now != after) {
                            change = after ? ++change : --change;
                        }
                    } else if (!before) {
                        if (now == after) {
                            ++change;
                        } else if (after) {
                            change += 2;
                        }
                    } else if (now == after) {
                        --change;
                    } else if (now) {
                        change -= 2;
                    }
                    otherNdVl.setNumGreenEdges(otherNdVl.getNumGreenEdges() + change);
                    if (change > 0) {
                        changes[0].add(otherNdVl);
                    } else if (change < 0) {
                        changes[1].add(otherNdVl);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return changes;
    }

    private void adjustHeap(ArrayList[] changes) {
        NodeVal curr;
        int i = 0;
        while (i < changes[0].size()) {
            curr = (NodeVal)changes[0].get(i);
            this.percolate(curr.getNode().getHeapIndex(curr.getValue()));
            ++i;
        }
        i = 0;
        while (i < changes[1].size()) {
            curr = (NodeVal)changes[1].get(i);
            this.percolateDown(curr.getNode().getHeapIndex(curr.getValue()));
            ++i;
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer("Heap =\n");
        int j = 1;
        int i = 0;
        while (i < this.numVals) {
            if (i == j) {
                j = j * 2 + 1;
                output.append("\n");
            }
            output.append(" Item ").append(i).append(" node ").append(this.heap[i].getNode().getName());
            output.append(" val ").append(this.heap[i].getValue()).append(" #green ");
            output.append(this.heap[i].getNumGreenEdges()).append(", ");
            ++i;
        }
        return output.toString();
    }
}

