/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.cspTools.CSP;
import CIspace.cspTools.CSPcanvas;
import CIspace.cspTools.IO;
import CIspace.graphToolKit.GraphCanvas;
import CIspace.graphToolKit.InlineApplet;
import CIspace.hill.HillCSP;
import CIspace.hill.HillCanvas;
import CIspace.hill.InlineCanvas;
import CIspace.hill.SolveCanvas;
import CIspace.hill.batch.BatchCanvas;
import CIspace.hill.dialogs.TraceFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class InlineHillApplet
extends InlineApplet {
    private static final long serialVersionUID = 1L;
    public JTextPane algorithmPane;
    private CSP csp;
    public int domainHistoryIndent;
    public int numSplitsOnStack;
    public boolean domainSplit;
    private boolean isFineStepEnabled;
    public JToggleButton initializeButton;
    public JToggleButton fineStepButton;
    public JToggleButton stepButton;
    public JToggleButton autoSolveButton;
    public JToggleButton batchRunButton;
    public JToggleButton stopButton;
    public JToggleButton showPlotButton;
    public JToggleButton showTraceButton;
    public JToggleButton fakeButton;
    private boolean initializeButtonOn = false;
    private boolean fineStepButtonOn = false;
    private boolean stepButtonOn = false;
    private boolean autoSolveButtonOn = false;
    private boolean batchRunButtonOn = false;
    private boolean stopButtonOn = false;
    private boolean showPlotButtonOn = false;
    private boolean showTraceButtonOn = false;
    public boolean initializePopupOn = false;
    public boolean fineStepPopupOn = false;
    public boolean stepPopupOn = false;
    public boolean autoSolvePopupOn = false;
    public boolean batchRunPopupOn = false;
    public boolean stopPopupOn = false;
    public boolean showPlotPopupOn = false;
    public boolean showTracePopupOn = false;
    private boolean showAlgorithm = false;
    public boolean showAlgorithmOptions = false;
    public boolean showBatchRunOptions = false;

    public void init() {
        super.init();
        this.makeCanvas();
        this.loadParams();
        if (this.incorrectParameter) {
            return;
        }
        ((InlineCanvas)this.canvas).initializePopup();
        this.csp.setMode(true);
        this.createToolBar();
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.canvas, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.canvas.setMinimumSize(new Dimension(10, 100));
        if (!this.showMessagePanel) {
            this.messageCanvas.setVisible(false);
        } else {
            this.messageCanvas.setMinimumSize(new Dimension(10, 50));
            this.setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to reorder its variables.\nClick on an arc to make it arc-consistent.");
        }
        this.algorithmPane = new JTextPane();
        this.algorithmPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.algorithmPane.setEditable(false);
        this.algorithmPane.setMinimumSize(new Dimension(100, 17));
        StyledDocument doc = this.algorithmPane.getStyledDocument();
        SimpleAttributeSet standard = new SimpleAttributeSet();
        StyleConstants.setAlignment(standard, 1);
        StyleConstants.setFontFamily(standard, "arial");
        StyleConstants.setBold(standard, true);
        doc.setParagraphAttributes(0, 0, standard, true);
        this.canvas.add(this.algorithmPane);
        this.setTA(true);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.canvasPanel);
        this.canvasPanel.addComponentListener(this);
        splitPane.setBottomComponent(this.algorithmPane);
        splitPane.setResizeWeight(1.0);
        splitPane.setDividerSize(0);
        if (!this.showAlgorithm) {
            this.algorithmPane.setVisible(false);
        }
        if (this.showButtons) {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 75));
        } else {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 10));
            this.toolBarPanel.setVisible(false);
        }
        this.algorithmPane.setBorder(null);
        if (this.showBorder) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.black));
            splitPane.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.canvas.setBorder(null);
            splitPane.setBorder(null);
        }
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.domainHistoryIndent = 0;
        this.domainSplit = false;
        this.numSplitsOnStack = 0;
        this.setPromptLabel("Click on \"Initialize\" to start.");
        this.csp.setPosition();
        this.setVisible(true);
    }

    protected CSP getCSP() {
        return new HillCSP(this, false);
    }

    protected void makeCanvas() {
        this.csp = this.getCSP();
        InlineCanvas newcanvas = new InlineCanvas((Container)this, this.csp);
        this.canvas = newcanvas;
        this.csp.init((CSPcanvas)this.canvas);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.canvas.addComponentListener(this);
    }

    public GraphCanvas returnCanvas() {
        return this.canvas;
    }

    protected void loadParams() {
        super.loadParams();
        String param = this.getParameter("initializeButton");
        if (param != null) {
            if (param.equals("on")) {
                this.initializeButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("initializeButton", param);
            }
        }
        if ((param = this.getParameter("finestepButton")) != null) {
            if (param.equals("on")) {
                this.fineStepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("finestepButton", param);
            }
        }
        if ((param = this.getParameter("stepButton")) != null) {
            if (param.equals("on")) {
                this.stepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepButton", param);
            }
        }
        if ((param = this.getParameter("autoSolveButton")) != null) {
            if (param.equals("on")) {
                this.autoSolveButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSolveButton", param);
            }
        }
        if ((param = this.getParameter("batchRunButton")) != null) {
            if (param.equals("on")) {
                this.batchRunButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("batchRunButton", param);
            }
        }
        if ((param = this.getParameter("stopButton")) != null) {
            if (param.equals("on")) {
                this.stopButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopButton", param);
            }
        }
        if ((param = this.getParameter("showPlotButton")) != null) {
            if (param.equals("on")) {
                this.showPlotButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showPlotButton", param);
            }
        }
        if ((param = this.getParameter("showTraceButton")) != null) {
            if (param.equals("on")) {
                this.showTraceButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showTraceButton", param);
            }
        }
        if ((param = this.getParameter("initializePopup")) != null) {
            if (param.equals("on")) {
                this.initializePopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("initializePopup", param);
            }
        }
        if ((param = this.getParameter("fineStepPopup")) != null) {
            if (param.equals("on")) {
                this.fineStepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("fineStepPopup", param);
            }
        }
        if ((param = this.getParameter("stepPopup")) != null) {
            if (param.equals("on")) {
                this.stepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepPopup", param);
            }
        }
        if ((param = this.getParameter("autoSolvePopup")) != null) {
            if (param.equals("on")) {
                this.autoSolvePopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("autoSolvePopup", param);
            }
        }
        if ((param = this.getParameter("batchRunPopup")) != null) {
            if (param.equals("on")) {
                this.batchRunPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("batchRunPopup", param);
            }
        }
        if ((param = this.getParameter("stopPopup")) != null) {
            if (param.equals("on")) {
                this.stopPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopPopup", param);
            }
        }
        if ((param = this.getParameter("showPlotPopup")) != null) {
            if (param.equals("on")) {
                this.showPlotPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showPlotPopup", param);
            }
        }
        if ((param = this.getParameter("showTracePopup")) != null) {
            if (param.equals("on")) {
                this.showTracePopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showTracePopup", param);
            }
        }
        if ((param = this.getParameter("showAlgorithm")) != null) {
            if (param.equals("on")) {
                this.showAlgorithm = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showAlgorithm", param);
            }
        }
        if ((param = this.getParameter("algorithmOptions")) != null) {
            if (param.equals("on")) {
                this.showAlgorithmOptions = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("algorithmOptions", param);
            }
        }
        if ((param = this.getParameter("batchRunOptions")) != null) {
            if (param.equals("on")) {
                this.showBatchRunOptions = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("batchRunOptions", param);
            }
        }
        if ((param = this.getParameter("showAlgorithm")) != null) {
            if (param.equals("on")) {
                this.showAlgorithm = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showAlgorithm", param);
            }
        }
        if ((param = this.getParameter("speed")) != null) {
            if (param.equals("veryFast")) {
                ((InlineCanvas)this.canvas).setSpeed(0);
            } else if (param.equals("fast")) {
                ((InlineCanvas)this.canvas).setSpeed(100);
            } else if (param.equals("medium")) {
                ((InlineCanvas)this.canvas).setSpeed(500);
            } else if (param.equals("slow")) {
                ((InlineCanvas)this.canvas).setSpeed(1000);
            } else {
                this.incorrectParameter("speed", param);
            }
        } else {
            ((InlineCanvas)this.canvas).setSpeed(500);
        }
        param = this.getParameter("algorithm");
        if (param != null) {
            if (param.equals("randomSampling")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(0);
            } else if (param.equals("randomWalk")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(1);
            } else if (param.equals("greedyDescent")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(2);
            } else if (param.equals("GDMinConflictHeuristic")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(3);
            } else if (param.equals("GDRandomWalk")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(4);
            } else if (param.equals("GDRandomRestart")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(5);
            } else if (param.equals("GDAll")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(6);
            } else if (param.equals("simulatedAnnealing")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(7);
            } else {
                this.incorrectParameter("algorithm", param);
            }
        }
    }

    public void createToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[9];
        int index = 0;
        this.setSolveButtonsWithText(index, "Initialize", InlineHillApplet.createImageIcon("images/initialize.png"), "Initialize");
        this.initializeButton = this.buttons[index++];
        if (!this.initializeButtonOn) {
            this.initializeButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, " Fine Step ", InlineHillApplet.createImageIcon("images/finestep.png"), "Fine Step");
        this.fineStepButton = this.buttons[index++];
        this.fineStepButton.setEnabled(false);
        if (!this.fineStepButtonOn) {
            this.fineStepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Step    ", InlineHillApplet.createImageIcon("images/step.png"), "Step");
        this.stepButton = this.buttons[index++];
        this.stepButton.setEnabled(false);
        if (!this.stepButtonOn) {
            this.stepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "AutoSolve", InlineHillApplet.createImageIcon("images/gear.png"), "AutoSolve");
        this.autoSolveButton = this.buttons[index++];
        this.autoSolveButton.setEnabled(false);
        if (!this.autoSolveButtonOn) {
            this.autoSolveButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Batch Run", InlineHillApplet.createImageIcon("images/batchrunner.png"), "Batch Run");
        this.batchRunButton = this.buttons[index++];
        if (!this.batchRunButtonOn) {
            this.batchRunButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Stop    ", InlineHillApplet.createImageIcon("images/stop.gif"), "Stop");
        this.stopButton = this.buttons[index++];
        this.stopButton.setEnabled(false);
        if (!this.stopButtonOn) {
            this.stopButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Show Plot", InlineHillApplet.createImageIcon("images/showPlot.png"), "Show Plot");
        this.showPlotButton = this.buttons[index++];
        if (!this.showPlotButtonOn) {
            this.showPlotButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Show Trace", InlineHillApplet.createImageIcon("images/viewCurrentPlan.png"), "Show Trace");
        this.showTraceButton = this.buttons[index++];
        if (!this.showTraceButtonOn) {
            this.showTraceButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Fake", InlineHillApplet.createImageIcon("images/finestep.png"), "Fake");
        this.fakeButton = this.buttons[index++];
        Font toolFont = new Font("arial", 0, 10);
        int i = 0;
        while (i < index) {
            buttonGroup.add(this.buttons[i]);
            toolBar.add(this.buttons[i]);
            this.buttons[i].setFont(toolFont);
            ++i;
        }
        this.buttons[index - 1].setVisible(false);
        this.toolBarPanel.add((Component)toolBar, "Center");
        this.mainPanel.add((Component)this.toolBarPanel, "North");
    }

    public boolean updateCSPFromText(String text) {
        if (IO.parseXML(text, this.csp)) {
            this.csp.setPosition();
            this.canvas.autoscale();
            this.canvas.repaint();
            return true;
        }
        return false;
    }

    public void load(String filename) {
        try {
            boolean xml;
            URL url = new URL(filename);
            InputStream iStream = url.openStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(iStream));
            ArrayList<String> lines = new ArrayList<String>();
            String all = "";
            String line = in.readLine();
            while (line != null) {
                all = String.valueOf(all) + line + "\n";
                lines.add(line);
                line = in.readLine();
            }
            in.close();
            String ext = filename.substring(filename.lastIndexOf(".") + 1);
            boolean bl = xml = !ext.equals("txt");
            if (!xml) {
                all = IO.parseOld2XML(lines);
            }
            this.updateCSPFromText(all);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    protected BatchCanvas getBatchCanvas() {
        return ((InlineCanvas)this.canvas).engine.getBatchCanvas();
    }

    protected SolveCanvas getSolveCanvas() {
        return ((InlineCanvas)this.canvas).engine.getSolveCanvas();
    }

    protected CSP returnCSP() {
        return this.csp;
    }

    public void enableButtons(boolean bool) {
        ((InlineCanvas)this.canvas).enableButtons(bool);
        this.stepButton.setEnabled(bool);
        this.enableFineStep(bool);
        this.autoSolveButton.setEnabled(bool);
        this.stopButton.setEnabled(false);
        this.showPlotButton.setEnabled(bool);
        this.batchRunButton.setEnabled(bool);
    }

    public void enableInit(boolean bool) {
        ((InlineCanvas)this.canvas).enableInit(bool);
        this.stepButton.setEnabled(bool);
        this.enableFineStep(bool);
        this.autoSolveButton.setEnabled(bool);
        this.stopButton.setEnabled(false);
        this.showPlotButton.setEnabled(bool);
        this.batchRunButton.setEnabled(!bool);
    }

    public void enableBatch(boolean bool) {
        this.batchRunButton.setEnabled(bool);
        this.stepButton.setEnabled(bool);
        this.enableFineStep(bool);
        this.autoSolveButton.setEnabled(bool);
        this.stopButton.setEnabled(!bool);
        this.showPlotButton.setEnabled(bool);
        this.initializeButton.setEnabled(bool);
    }

    public void enableAuto(boolean bool) {
        this.batchRunButton.setEnabled(bool);
        this.stepButton.setEnabled(bool);
        this.enableFineStep(bool);
        this.autoSolveButton.setEnabled(bool);
        this.stopButton.setEnabled(!bool);
        this.showPlotButton.setEnabled(!bool);
        this.initializeButton.setEnabled(bool);
    }

    public void enableFineStep(boolean bool) {
        this.isFineStepEnabled = bool;
        if (!bool) {
            this.fineStepButton.setEnabled(bool);
            ((InlineCanvas)this.canvas).finestep.setEnabled(bool);
        } else if (((InlineCanvas)this.canvas).engine.fineStepAllowed() && !((InlineCanvas)this.canvas).engine.isStoppingCriteriaMet()) {
            this.fineStepButton.setEnabled(bool);
            ((InlineCanvas)this.canvas).finestep.setEnabled(bool);
        } else {
            this.fineStepButton.setEnabled(false);
            ((InlineCanvas)this.canvas).finestep.setEnabled(false);
        }
    }

    public void disableFineStep() {
        if (!((InlineCanvas)this.canvas).engine.fineStepAllowed()) {
            if (this.fineStepButton != null) {
                this.fineStepButton.setEnabled(false);
                ((InlineCanvas)this.canvas).finestep.setEnabled(false);
            }
        } else if (!((InlineCanvas)this.canvas).engine.isStoppingCriteriaMet() && this.fineStepButton != null) {
            this.fineStepButton.setEnabled(this.isFineStepEnabled);
            ((InlineCanvas)this.canvas).finestep.setEnabled(this.isFineStepEnabled);
        }
    }

    protected void setTA(boolean t) {
        if (t) {
            this.setAlgoText(((InlineCanvas)this.canvas).engine.getCurrSearch().getName());
        } else {
            this.algorithmPane.setText("");
        }
    }

    public void setAlgoText(String algName) {
        this.algorithmPane.setText("Algorithm Selected:  " + algName);
    }

    public void fineStep() {
        if (!this.fineStepButton.isEnabled()) {
            return;
        }
        this.setPromptLabel("");
        ((InlineCanvas)this.canvas).engine.finestep();
        this.canvas.repaint();
        this.fakeButton.setSelected(true);
        ((InlineCanvas)this.canvas).updateNodeDetailFrame();
    }

    public void showTrace() {
        if (!this.showTraceButton.isEnabled()) {
            return;
        }
        if (((InlineCanvas)this.canvas).engine.trace == null) {
            ((InlineCanvas)this.canvas).engine.trace = new TraceFrame(this, ((InlineCanvas)this.canvas).engine);
        }
        ((InlineCanvas)this.canvas).engine.openTrace();
        this.fakeButton.setSelected(true);
    }

    public void showPlot() {
        if (!this.showPlotButton.isEnabled()) {
            return;
        }
        ((InlineCanvas)this.canvas).engine.showPlot();
        this.fakeButton.setSelected(true);
    }

    public void step() {
        if (!this.stepButton.isEnabled()) {
            return;
        }
        this.setPromptLabel("");
        ((InlineCanvas)this.canvas).engine.step();
        this.fakeButton.setSelected(true);
        ((InlineCanvas)this.canvas).updateNodeDetailFrame();
    }

    protected void autoSolveStart() {
        this.setPromptLabel("Running Auto Solve...");
        this.fakeButton.setSelected(true);
        ((InlineCanvas)this.canvas).engine.autoSolveStart();
    }

    protected void autoSolveStop() {
        this.setPromptLabel("Click on a node to change its value");
        ((InlineCanvas)this.canvas).engine.stopBatchRun();
        ((InlineCanvas)this.canvas).engine.resetAutoSolve();
        this.canvas.repaint();
    }

    protected void batchRunStart() {
        this.fakeButton.setSelected(true);
        ((HillCSP)this.csp).setCurrBold(false);
        ((InlineCanvas)this.canvas).hideConflictFrame();
        ((InlineCanvas)this.canvas).engine.batchRun();
    }

    protected void closeTrace() {
        if (((InlineCanvas)this.canvas).engine.trace != null) {
            ((InlineCanvas)this.canvas).engine.trace.setVisible(false);
            ((InlineCanvas)this.canvas).engine.trace.dispose();
        }
    }

    protected void closePlot() {
        if (((InlineCanvas)this.canvas).engine.getPlotFrame() != null) {
            ((InlineCanvas)this.canvas).engine.closePlotFrame();
        }
    }

    protected void closeBatch() {
        if (((InlineCanvas)this.canvas).engine.getBatchFrame() != null) {
            ((InlineCanvas)this.canvas).engine.getBatchFrame().setVisible(false);
            ((InlineCanvas)this.canvas).engine.getBatchFrame().dispose();
        }
    }

    public void setButtonsSolved(boolean boolSolved) {
        this.initializeButton.setEnabled(true);
        this.stepButton.setEnabled(!boolSolved);
        if (!((HillCanvas)this.canvas).engine.fineStepAllowed()) {
            this.fineStepButton.setEnabled(false);
        } else {
            this.fineStepButton.setEnabled(!boolSolved);
        }
        this.autoSolveButton.setEnabled(!boolSolved);
        this.stopButton.setEnabled(false);
        ((InlineCanvas)this.returnCanvas()).setButtonsSolved(boolSolved);
    }

    protected void initializeGraph() {
        ((InlineCanvas)this.canvas).engine.restart();
        this.canvas.repaint();
        this.enableButtons(true);
        this.setPromptLabel("Step 1 - Initialized.\nClick on a variable to change its value.\nClick on a constraint to reorder its variables.");
        this.fakeButton.setSelected(true);
        ((InlineCanvas)this.canvas).updateNodeDetailFrame();
    }

    public void initialize() {
        if (this.initializeButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.initializeButton, 0, "Initialize"));
        }
    }

    public void autoSolve() {
        if (this.autoSolveButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.autoSolveButton, 0, "AutoSolve"));
        }
    }

    public void batchRun() {
        if (this.batchRunButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.batchRunButton, 0, "Batch Run"));
        }
    }

    public void stop() {
        if (this.stopButton.isEnabled()) {
            ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.stopButton, 0, "Stop"));
        }
    }

    public void algorithmOptions() {
        ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.fakeButton, 0, "Algorithm Options"));
    }

    public void batchRunOptions() {
        ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.fakeButton, 0, "Batch Run Options"));
    }

    public void autoscale() {
        ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.fakeButton, 0, "Autoscale"));
    }

    public void arrangeConstraints() {
        ((InlineCanvas)this.canvas).aSolvePerformed(new ActionEvent(this.fakeButton, 0, "Arrange Constraints"));
    }

    public void setAlgorithm(String algorithm) {
        if (algorithm != null) {
            if (algorithm.equals("randomSampling")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(0);
                this.setAlgoText("Random Sampling");
            } else if (algorithm.equals("randomWalk")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(1);
                this.setAlgoText("Random Walk");
            } else if (algorithm.equals("greedyDescent")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(2);
                this.setAlgoText("Greedy Descent");
            } else if (algorithm.equals("GDMinConflictHeuristic")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(3);
                this.setAlgoText("Greedy Descent with Min Conflict Heuristic");
            } else if (algorithm.equals("GDRandomWalk")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(4);
                this.setAlgoText("Greedy Descent with Random Walk");
            } else if (algorithm.equals("GDRandomRestart")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(5);
                this.setAlgoText("Greedy Descent with Random Restart");
            } else if (algorithm.equals("GDAll")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(6);
                this.setAlgoText("Greedy Descent with All Options");
            } else if (algorithm.equals("simulatedAnnealing")) {
                ((InlineCanvas)this.canvas).engine.setSearchAlg(7);
                this.setAlgoText("Simulated Annealing");
            }
        }
    }
}

