/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.graphToolKit.dialogs.BasicFrame;
import CIspace.hill.HillCSP;
import CIspace.hill.HillCanvas;
import CIspace.hill.NodeDetailCanvas;
import CIspace.hill.elements.HillVariable;
import CIspace.hill.elements.NodeVal;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class NodeDetailFrame
extends BasicFrame {
    private NodeDetailCanvas canvas;
    private HillCSP csp;
    private HillVariable node;
    private Container parent;
    private HillCanvas graphCanvas;

    public NodeDetailFrame(Container parent, HillCSP csp, HillCanvas graphCanvas) {
        super("Node Details");
        this.parent = parent;
        this.graphCanvas = graphCanvas;
        this.csp = csp;
        this.getContentPane().setLayout(new BorderLayout());
        this.canvas = new NodeDetailCanvas(this);
        this.canvas.addActionListener(this);
        this.getContentPane().add((Component)this.canvas, "Center");
        JButton okayButton = new JButton("OK");
        okayButton.addActionListener(this);
        this.getContentPane().add((Component)okayButton, "South");
    }

    public void open(HillVariable node) {
        this.node = node;
        this.setTitle("Node Details for " + node.getName());
        this.update();
        this.toFront();
        if (!this.isVisible()) {
            this.centerWindow();
            this.setVisible(true);
        }
    }

    public void update() {
        this.canvas.setFontSize(this.graphCanvas.getFontSize());
        this.canvas.setEdgeProperties(this.graphCanvas.graph.getLineWidth(), this.graphCanvas.graph.getArrowHeight(), this.graphCanvas.graph.getArrowWidth());
        int[] dim = this.canvas.setNode(this.node);
        this.setSize(dim[0], dim[1]);
        this.canvas.repaint();
        this.validate();
    }

    private void updateNode() {
        this.csp.setNode(new NodeVal(this.node, this.canvas.getCurrIndex()));
        this.csp.setCurrent(this.node);
        this.node.checkColor();
    }

    public void repaint() {
        if (this.canvas != null) {
            this.canvas.repaint();
        }
        super.repaint();
    }

    public void repaintGraph() {
        if (this.parent != null) {
            this.graphCanvas.repaint();
        }
    }

    protected boolean actionOK() {
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("select")) {
            this.updateNode();
            this.csp.resetLabels();
        } else {
            super.actionPerformed(e);
        }
    }
}

