/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.hill.intList.IntVector;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JPanel;

public abstract class PlotCanvas
extends JPanel
implements MouseListener,
Printable {
    protected Font font;
    protected FontMetrics fm;
    protected int width;
    protected int height;
    protected float xStep;
    protected float yStep;
    protected IntVector xVals;
    protected IntVector yVals;
    protected IntVector vLines;
    protected int maxY;
    protected int maxX;
    protected int skipX;
    protected int skipY;
    protected static final int LEFT_PAD = 50;
    protected static final int RIGHT_PAD = 20;
    protected static final int TOP_PAD = 50;
    protected static final int BOTTOM_PAD = 50;
    protected boolean useLogScale = false;
    protected boolean drawingBatch;
    protected int mouseX;
    protected int mouseY;
    protected String coords;
    protected static final Color c0 = Color.blue;
    protected static final Color c1 = Color.red;
    protected static final Color c2 = Color.cyan;
    protected static final Color c3 = Color.magenta;
    protected static final Color c4 = Color.green;
    protected static final Color c5 = Color.orange;
    protected static final Color c6 = Color.pink;
    protected static final Color c7 = Color.yellow;
    protected boolean drawSteps = true;

    public void initCanvas() {
        this.addMouseListener(this);
        this.setBackground(Color.white);
        this.font = new Font("SansSerif", 0, 12);
        this.fm = this.getFontMetrics(this.font);
        this.xStep = 5.0f;
        this.maxX = 1;
        this.mouseX = -100;
        this.mouseY = -100;
        this.coords = "";
    }

    public void clear(int n) {
        System.out.println("MUST be implemented by subclass");
    }

    public void setGraphics() {
        this.updateSize();
    }

    public void resetSteps(int maxY) {
        this.updateSize();
        this.maxY = maxY;
        if (maxY <= 0) {
            maxY = 1;
            this.yStep = 50.0f;
        } else {
            this.yStep = (float)this.height / (float)maxY;
        }
        if (this.xStep < 0.0f) {
            this.xStep = 1.0f;
        }
        if (this.yStep < 0.0f) {
            this.yStep = 1.0f;
        }
        this.skipX = this.round(50.0 / (double)this.xStep);
        this.skipY = this.round(20.0 / (double)this.yStep);
    }

    public void resetSteps() {
        this.resetSteps(this.maxY);
    }

    protected int round(double d) {
        int mult;
        int digits = 0;
        double tmp = d;
        while (tmp >= 1.0) {
            tmp /= 10.0;
            ++digits;
        }
        if (digits <= 0) {
            digits = 1;
        }
        if (d / (double)(mult = (int)Math.pow(10.0, digits)) < 0.1) {
            return (int)(0.1 * (double)mult);
        }
        if (d / (double)mult < 0.25) {
            return (int)(0.25 * (double)mult);
        }
        if (d / (double)mult < 0.5) {
            return (int)(0.5 * (double)mult);
        }
        return mult;
    }

    public void updateSize() {
        this.width = this.getWidth() - 50 - 20;
        this.height = this.getHeight() - 50 - 50;
    }

    public void useLogScale(boolean bool) {
        this.useLogScale = bool;
        this.redrawCoords();
        this.repaint();
    }

    protected void drawGrid(Graphics graphics) {
        int xStart = 50;
        if (xStart < 0) {
            xStart = 0;
        }
        int xEnd = this.getWidth() - 20;
        this.drawAxes(graphics, xStart, xEnd);
        this.drawGridLines(graphics, xStart);
    }

    protected void drawAxes(Graphics graphics, int xStart, int xEnd) {
        graphics.setColor(Color.black);
        graphics.drawLine(xStart, this.getHeight() - 50, xEnd, this.getHeight() - 50);
        graphics.drawLine(50, this.getHeight() - 50, 50, 50);
    }

    public void setFont(Font f) {
        this.font = f;
        this.fm = this.getFontMetrics(this.font);
        super.setFont(f);
    }

    protected void drawGridLines(Graphics graphics, int xStart) {
        graphics.setColor(Color.lightGray);
        graphics.setFont(this.font);
        int i = 0;
        float x2 = 1.0f;
        if (!this.useLogScale) {
            float x = this.xStep * (float)this.skipX;
            while ((double)x <= (double)this.width + 0.05) {
                x2 = x;
                graphics.drawLine((int)x2 + 50, 50, (int)x2 + 50, this.getHeight() - 50);
                graphics.drawString(String.valueOf(i += this.skipX), (int)x2 + 50 - this.fm.stringWidth(String.valueOf(i)) / 2, this.getHeight() - 50 + this.fm.getHeight());
                x += this.xStep * (float)this.skipX;
            }
        } else if (this.drawingBatch) {
            int base = this.maxX < 100 ? 2 : 10;
            i = base;
            float step = (float)this.width / (float)(Math.log(this.maxX) / Math.log(base));
            if (step <= 0.0f) {
                step = this.width;
            }
            x2 = step;
            while ((double)x2 <= (double)this.width + 0.05) {
                graphics.drawLine((int)x2 + 50, 50, (int)x2 + 50, this.getHeight() - 50);
                graphics.drawString(String.valueOf(i), (int)x2 + 50 + this.fm.stringWidth(String.valueOf(i)) / 2, this.getHeight() - 50 + this.fm.getHeight());
                i *= base;
                x2 += step;
            }
        } else {
            float x = this.xStep * (float)this.skipX;
            while ((double)x <= (double)this.width + 0.05) {
                x2 = x;
                float percent = x2 / (float)this.width;
                graphics.drawLine((int)(x2 *= percent * percent) + 50, 50, (int)x2 + 50, -48);
                graphics.drawLine((int)x2 + 50, 50, (int)x2 + 50, this.getHeight() - 50);
                graphics.drawString(String.valueOf(i += this.skipX), (int)x2 + 50 - this.fm.stringWidth(String.valueOf(i)) / 2, -48 + this.fm.getHeight());
                graphics.drawString(String.valueOf(i), (int)x2 + 50 - this.fm.stringWidth(String.valueOf(i)) / 2, this.getHeight() - 50 + this.fm.getHeight());
                x += this.xStep * (float)this.skipX;
            }
        }
        i = 0;
        float y = (float)(this.getHeight() - 50) - this.yStep * (float)this.skipY;
        while ((double)y >= 49.95) {
            xStart = 50;
            graphics.drawLine(xStart, (int)y, this.getWidth() - 20, (int)y);
            xStart = xStart == 0 ? this.getWidth() - 20 + this.fm.stringWidth(" ") : (xStart -= this.fm.stringWidth(String.valueOf(i += this.skipY) + " "));
            graphics.drawString(String.valueOf(i), xStart, (int)y + this.fm.getHeight() / 2);
            y -= this.yStep * (float)this.skipY;
        }
    }

    public String title() {
        return "Hill-Climbing Plot";
    }

    protected float percent(int x) {
        float percent = this.maxX == 0 ? 0.0f : (this.drawingBatch ? (float)x / (float)this.maxX : (float)x / (float)this.xVals.last());
        return percent;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        return 0;
    }

    public void mousePressed(MouseEvent e) {
        this.testCoords(e);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void testCoords(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.redrawCoords();
    }

    public void redrawCoords() {
        int x = this.mouseX - 50;
        x = this.useLogScale ? (int)Math.pow(this.maxX, (double)x / (double)this.width) : (int)((float)x / this.xStep);
        this.coords = String.valueOf(x) + ", " + (int)((float)(this.getHeight() - 50 - this.mouseY) / this.yStep);
        this.repaint();
    }
}

