/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill;

import CIspace.hill.HillEngine;
import CIspace.hill.HillWindow;
import CIspace.hill.InlineHillApplet;
import CIspace.hill.PlotInterface;
import CIspace.hill.SolveCanvas;
import CIspace.hill.batch.BatchCanvas;
import CIspace.hill.batch.BatchPanel;
import CIspace.hill.dialogs.BatchDialog;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PlotFrame
extends JFrame
implements ActionListener,
WindowListener,
ComponentListener,
ItemListener {
    public HillEngine engine;
    private Container window;
    private JComponent plot;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private JCheckBox log;
    private boolean drawingBatch;
    private JButton run;
    private JButton step;
    private JButton random;
    private JButton stop;
    private JButton runOptions;
    private JButton algorithmOptions;
    private JRadioButton drawSteps;
    private JRadioButton drawTimes;
    private ButtonGroup draw;
    private JButton statistics;

    public PlotFrame(Container window, HillEngine engine, boolean drawingBatch) {
        super("Hill-Climbing Plot");
        if (drawingBatch) {
            this.setTitle("Batch Plot");
        }
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.engine = engine;
        this.window = window;
        this.drawingBatch = drawingBatch;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        if (drawingBatch) {
            this.plot = new BatchPanel(this);
            this.run = new JButton("Batch Run");
            this.run.setToolTipText("Perform a new batch run.");
        } else {
            this.plot = new SolveCanvas();
            this.run = new JButton("Auto Solve");
            this.run.setToolTipText("Auto Solve the CSP.");
        }
        if (engine.canvas.inline) {
            this.plot.setFont(((InlineHillApplet)window).returnCanvas().getFont());
        } else {
            this.plot.setFont(((HillWindow)window).returnCanvas().getFont());
        }
        this.run.addActionListener(this);
        this.step = new JButton("Step");
        this.step.setToolTipText("Step");
        this.step.addActionListener(this);
        this.random = new JButton("Initialize");
        this.random.setToolTipText("Clear the current trace and initialize the CSP.");
        this.random.addActionListener(this);
        this.stop = new JButton("Stop");
        this.stop.setToolTipText("Stop");
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
        this.log = new JCheckBox("Logarithmic Scale");
        this.log.addActionListener(this);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        JButton redraw = new JButton("Redraw");
        redraw.addActionListener(this);
        JButton clear = new JButton("Clear");
        clear.setToolTipText("Clear the plot graph.");
        clear.addActionListener(this);
        JButton print = new JButton("Print");
        print.addActionListener(this);
        this.statistics = new JButton("Statistics & Settings");
        this.statistics.setToolTipText("View Statistics and Settings information for all plots.");
        this.statistics.addActionListener(this);
        this.runOptions = new JButton("Batch Run Options");
        this.runOptions.setToolTipText("Modify the batch run options.");
        this.runOptions.addActionListener(this);
        this.algorithmOptions = new JButton("Algorithm Options");
        this.algorithmOptions.setToolTipText("Modify the algorithm options.");
        this.algorithmOptions.addActionListener(this);
        this.drawSteps = new JRadioButton("Draw Steps", true);
        this.drawSteps.addActionListener(this);
        this.drawTimes = new JRadioButton("Draw Times", false);
        this.drawTimes.addActionListener(this);
        this.draw = new ButtonGroup();
        this.draw.add(this.drawSteps);
        this.draw.add(this.drawTimes);
        JPanel top = new JPanel();
        if (!drawingBatch) {
            top.add(this.random);
            top.add(this.step);
        }
        top.add(this.run);
        top.add(this.stop);
        if (drawingBatch) {
            top.add(this.statistics);
            top.add(this.runOptions);
            top.add(this.algorithmOptions);
        }
        JPanel bottom = new JPanel();
        bottom.setLayout(this.gbl);
        if (drawingBatch) {
            this.addComponent(this.drawSteps, bottom, 0, 0, 1, 1, 0.0, 0.0);
        }
        if (drawingBatch) {
            this.addComponent(this.drawTimes, bottom, 1, 0, 1, 1, 0.0, 0.0);
        }
        this.addComponent(this.log, bottom, 0, 1, 1, 2, 0.0, 1.0);
        bottom.add(print);
        bottom.add(new JLabel("\t\t\t\t\t"));
        if (drawingBatch) {
            bottom.add(clear);
        }
        bottom.add(close);
        this.getContentPane().setLayout(this.gbl);
        this.addComponent(this.plot, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(top, this, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(bottom, this, 2, 0, 1, 1, 0.0, 0.0);
        this.setSize(650, 450);
        this.setVisible(true);
        ((PlotInterface)((Object)this.plot)).resetSteps(0);
    }

    private void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    public void open() {
        if (this.drawingBatch) {
            ((BatchPanel)this.plot).redraw(this.engine.getBatchSteps(), this.engine.getCompleted());
        } else {
            ((SolveCanvas)this.plot).redraw(this.engine.getPlotVals());
            this.setButtonsSolved(this.engine.isStoppingCriteriaMet());
        }
        this.setVisible(true);
    }

    public BatchCanvas getBatchCanvas() {
        if (this.drawingBatch) {
            return ((BatchPanel)this.plot).canvas;
        }
        return null;
    }

    public SolveCanvas getSolveCanvas() {
        if (!this.drawingBatch) {
            return (SolveCanvas)this.plot;
        }
        return null;
    }

    public void setButtonsSolved(boolean boolSolved) {
        if (!this.drawingBatch) {
            this.run.setEnabled(!boolSolved);
            this.step.setEnabled(!boolSolved);
            this.random.setEnabled(true);
            this.stop.setEnabled(false);
        }
    }

    public void enableButtons(boolean bool) {
        this.run.setEnabled(bool);
        this.stop.setEnabled(!bool);
        this.step.setEnabled(bool);
        this.random.setEnabled(bool);
        this.statistics.setEnabled(bool);
        this.runOptions.setEnabled(bool);
        this.algorithmOptions.setEnabled(bool);
    }

    public void clear() {
        while (this.engine.batchRunAlive()) {
        }
        this.engine.clearPlotPts(this.drawingBatch);
        ((PlotInterface)((Object)this.plot)).clear(1);
    }

    public void repaint(boolean drawBatch) {
        this.drawingBatch = drawBatch;
        ((PlotInterface)((Object)this.plot)).resetSteps();
        if (drawBatch) {
            ((BatchPanel)this.plot).paint(this.engine.getBatchSteps(), this.engine.getCompleted());
        } else {
            ((SolveCanvas)this.plot).paint(this.engine.getPlotVals());
        }
    }

    public void redraw() {
        ((PlotInterface)((Object)this.plot)).resetSteps();
        if (this.drawingBatch) {
            ((BatchPanel)this.plot).redraw(this.engine.getBatchSteps(), this.engine.getCompleted());
        } else {
            ((SolveCanvas)this.plot).redraw(this.engine.getPlotVals());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Logarithmic Scale")) {
            ((PlotInterface)((Object)this.plot)).useLogScale(this.log.isSelected());
        } else if (arg.equals("Redraw")) {
            this.redraw();
        } else if (arg.equals("Close")) {
            this.engine.resetAutoSolve();
            this.setVisible(false);
        } else if (arg.equals("Clear")) {
            this.engine.resetAutoSolve();
            if (this.drawingBatch) {
                this.statistics.setEnabled(false);
            }
            this.clear();
        } else if (arg.equals("Print")) {
            ((PlotInterface)((Object)this.plot)).print(this);
        } else if (arg.equals("Batch Run")) {
            this.engine.batchRun();
        } else if (arg.equals("Batch Run Options")) {
            new BatchDialog((JFrame)this, this.engine);
        } else if (arg.equals("Algorithm Options")) {
            if (this.engine.canvas.inline) {
                this.engine.openHeurOptions(null);
            } else {
                this.engine.openHeurOptions((HillWindow)this.window);
            }
        } else if (arg.equals("Auto Solve")) {
            this.engine.autoSolveStart();
        } else if (arg.equals("Step")) {
            this.engine.step();
            this.engine.getCSP().resetLabels();
        } else if (arg.equals("Initialize")) {
            this.engine.restart();
            this.engine.getCSP().resetLabels();
        } else if (arg.equals("Stop")) {
            this.engine.resetAutoSolve();
        } else if (arg.equals("Statistics & Settings")) {
            ((BatchPanel)this.plot).openStats(0);
        } else if (e.getSource() == this.drawSteps) {
            ((BatchPanel)this.plot).switchDrawSteps();
            this.redraw();
            this.drawSteps.setToolTipText("Plot Successes vs. Time");
        } else if (e.getSource() == this.drawTimes) {
            ((BatchPanel)this.plot).switchDrawTimes();
            this.redraw();
            this.drawTimes.setToolTipText("Plot Successes vs. Step Count");
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItem().toString().equals("Logarithmic Scale")) {
            ((PlotInterface)((Object)this.plot)).useLogScale(this.log.isSelected());
        }
    }

    public void windowClosing(WindowEvent e) {
        this.engine.resetAutoSolve();
        this.setVisible(false);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        ((PlotInterface)((Object)this.plot)).resetSteps();
        this.redraw();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }
}

