/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.batch;

import CIspace.hill.PlotFrame;
import CIspace.hill.PlotInterface;
import CIspace.hill.batch.BatchCanvas;
import CIspace.hill.batch.BatchStep;
import CIspace.hill.batch.LegendPanel;
import CIspace.hill.dialogs.StatsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPanel
extends JPanel
implements PlotInterface {
    public BatchCanvas canvas = new BatchCanvas(this);
    private LegendPanel legend = new LegendPanel(this);
    private PlotFrame pFrame;
    private StatsDialog sDialog;

    public BatchPanel(PlotFrame pFrame) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.add((Component)new JScrollPane(this.legend, 20, 30), "East");
        this.pFrame = pFrame;
        this.setSize(1000, 1000);
    }

    public int getMaxSteps() {
        return this.pFrame.engine.maxBatchCount;
    }

    public void switchDrawSteps() {
        this.canvas.switchDrawSteps();
    }

    public void switchDrawTimes() {
        this.canvas.switchDrawTimes();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.canvas != null) {
            this.canvas.setFont(f);
        }
    }

    @Override
    public void clear(int numEdges) {
        this.legend.update(new ArrayList<BatchStep>());
        this.canvas.clear(numEdges);
    }

    public void paint(ArrayList<BatchStep> batchSteps, boolean completed) {
        this.canvas.paint(batchSteps, completed);
        if (completed) {
            this.legend.update(batchSteps);
        }
    }

    public void redraw(ArrayList<BatchStep> batchSteps, boolean completed) {
        this.canvas.redraw(batchSteps, completed);
        if (completed) {
            this.legend.update(batchSteps);
        }
    }

    @Override
    public void resetSteps(int n) {
        this.canvas.resetSteps(n);
    }

    @Override
    public void resetSteps() {
        this.canvas.resetSteps();
    }

    @Override
    public void useLogScale(boolean bool) {
        this.canvas.useLogScale(bool);
    }

    public void highlight(int n) {
        this.canvas.highlight(n);
    }

    public void openStats(int n) {
        if (this.sDialog == null) {
            this.sDialog = new StatsDialog((JFrame)this.pFrame, this.canvas.getSteps(), n);
        } else {
            this.sDialog.reset(this.canvas.getSteps(), n);
        }
    }

    @Override
    public void print(JFrame parent) {
        this.canvas.print(parent);
    }
}

