/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.batch;

import CIspace.graphToolKit.dialogs.BasicPanel;
import CIspace.hill.batch.BatchPanel;
import CIspace.hill.batch.BatchStep;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LegendPanel
extends BasicPanel
implements MouseListener,
ActionListener {
    private BatchPanel batchPanel;
    private JPanel[] colors;

    LegendPanel(BatchPanel panel) {
        this.batchPanel = panel;
        this.setBackground(Color.white);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.setLayout(this.gbl);
        this.setSize(100, 300);
    }

    public void update(ArrayList<BatchStep> steps) {
        this.invalidate();
        if (steps.isEmpty()) {
            this.removeAll();
            this.validate();
            this.batchPanel.validate();
            return;
        }
        this.colors = new JPanel[steps.size()];
        this.addComponent(new JLabel("Plot    "), this, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel("Color  "), this, 0, 1, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(" Time (ms)"), this, 0, 2, 1, 1, 0.0, 0.0);
        int i = 0;
        for (BatchStep s : steps) {
            this.addStep(s, i++);
        }
        this.validate();
        this.batchPanel.validate();
    }

    private void addStep(BatchStep step, int number) {
        JButton name = new JButton("Plot #" + number);
        name.addActionListener(this);
        JPanel color = new JPanel();
        color.setBackground(step.color);
        color.addMouseListener(this);
        this.colors[number] = color;
        this.addComponent(name, this, number + 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(color, this, number + 1, 1, 1, 1, 0.0, 0.0);
        this.addComponent(new JLabel(this.round(step.getAvg(false)), 4), this, number + 1, 2, 1, 1, 0.0, 0.0);
    }

    private int findSource(Object object) {
        int i = 0;
        while (!((JPanel)object).getBackground().equals(this.colors[i].getBackground())) {
            ++i;
        }
        return i;
    }

    private String round(float f) {
        return String.valueOf((float)Math.round(f * 100.0f) / 100.0f);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.batchPanel.openStats(this.findSource(e.getSource()));
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.batchPanel.highlight(this.findSource(e.getSource()));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.batchPanel.highlight(-1);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        String num = arg.substring(arg.lastIndexOf("#") + 1);
        try {
            this.batchPanel.openStats(Integer.parseInt(num));
        }
        catch (NumberFormatException nfe) {
            System.out.println(num);
        }
    }
}

