/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.dialogs;

import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.hill.HillEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class BatchDialog
extends BasicDialog
implements CaretListener {
    private HillEngine engine;
    private JTextField numTrialsTextField;
    private JTextField terminateTextField;
    private JLabel errLabel;

    public BatchDialog(JFrame parent, HillEngine engine) {
        super(parent, "Batch Run Options", true);
        this.engine = engine;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.constructTopPanel(), "Center");
        this.getContentPane().add((Component)this.constructBottomPanel(), "South");
        this.open();
    }

    private JPanel constructTopPanel() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(3, 2));
        topPanel.add(new JLabel("Number of trials per run:"));
        this.numTrialsTextField = new JTextField(String.valueOf(this.engine.maxBatchCount));
        this.numTrialsTextField.addCaretListener(this);
        topPanel.add(this.numTrialsTextField);
        topPanel.add(new JLabel("Terminate after: "));
        this.terminateTextField = new JTextField(String.valueOf(this.engine.giveUp));
        this.terminateTextField.addCaretListener(this);
        topPanel.add(this.terminateTextField);
        JButton button = new JButton("OK");
        button.addActionListener(this);
        this.getRootPane().setDefaultButton(button);
        topPanel.add(button);
        button = new JButton("Cancel");
        button.addActionListener(this);
        topPanel.add(button);
        return topPanel;
    }

    private JPanel constructBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        this.errLabel = new JLabel("", 0);
        bottomPanel.add((Component)this.errLabel, "Center");
        return bottomPanel;
    }

    public void open() {
        this.numTrialsTextField.setText(String.valueOf(this.engine.maxBatchCount));
        this.terminateTextField.setText(String.valueOf(this.engine.giveUp));
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private boolean parse() {
        int num2;
        int num1;
        block5: {
            block4: {
                try {
                    num1 = Integer.parseInt(this.numTrialsTextField.getText());
                    if (num1 >= 10 && num1 <= 1000) break block4;
                    this.errLabel.setText("Trials per run must be between 10 and 1000.");
                    return false;
                }
                catch (NumberFormatException e) {
                    this.errLabel.setText("Please enter an integer.");
                    return false;
                }
            }
            num2 = Integer.parseInt(this.terminateTextField.getText());
            if (num2 >= 10) break block5;
            this.errLabel.setText("Please enter an integer >= 10.");
            return false;
        }
        this.engine.maxBatchCount = num1;
        this.engine.giveUp = num2;
        return true;
    }

    protected boolean actionOK() {
        return this.parse();
    }

    protected boolean actionCancel() {
        return true;
    }

    public void caretUpdate(CaretEvent arg0) {
        if (this.parse()) {
            this.errLabel.setText("");
        }
    }
}

