/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.dialogs;

import CIspace.graphToolKit.dialogs.BasicDialog;
import CIspace.hill.HillEngine;
import CIspace.hill.HillWindow;
import CIspace.hill.InlineHillApplet;
import CIspace.hill.Updateable;
import CIspace.hill.search.Search;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OptionsDialog
extends BasicDialog
implements ItemListener,
ChangeListener {
    private Component emptyPanel2;
    private JPanel emptyPanel;
    private JTabbedPane descOpsPane;
    private JRadioButton lowestval;
    private JRadioButton random;
    private JPanel initPanel;
    private HillEngine engine;
    private Search[] searches;
    private JPanel initialize;
    private JPanel terminate;
    private JPanel searchSteps;
    private JPanel searchAlgs;
    private JComponent stepsOptions;
    private JButton options;
    private boolean optORdesc;
    private JComboBox alg;
    private ButtonGroup init;
    private JTextField halt;

    public OptionsDialog(HillEngine engine, HillWindow window) {
        super((JFrame)window, "Algorithm Options", true);
        this.engine = engine;
        this.searches = engine.getSearchAlgs();
        this.setSize(450, 400);
        this.optORdesc = true;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.options = new JButton("Description");
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        this.options.addActionListener(this);
        ok.addActionListener(this);
        cancel.addActionListener(this);
        JPanel okcancel = new JPanel();
        okcancel.add(ok);
        okcancel.add(cancel);
        this.makeInit();
        this.makeTerm();
        this.makeSeAl();
        this.makeStOp(engine.getSearchIndex());
        this.makeSeSt();
        this.addComponent(this.initialize, this, 1, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.terminate, this, 2, 0, 1, 1, 1.0, 0.0);
        this.addComponent(new JLabel("   "), this, 3, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.searchSteps, this, 4, 0, 2, 1, 1.0, 2.0);
        this.addComponent(okcancel, this, 5, 0, 1, 1, 1.0, 0.0);
        this.centerWindow();
    }

    public void open() {
        this.setVisible(true);
    }

    private void makeInit() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel("Initialization:"));
        this.init = new ButtonGroup();
        this.random = new JRadioButton("Random        ");
        this.lowestval = new JRadioButton("Lowest Value");
        this.init.add(this.random);
        this.init.add(this.lowestval);
        this.initPanel = new JPanel();
        this.initPanel.setLayout(new FlowLayout());
        this.initPanel.add(this.random);
        this.initPanel.add(this.lowestval);
        if (this.engine.init == 1) {
            this.random.setSelected(true);
        } else {
            this.lowestval.setSelected(true);
        }
        panel.add(this.initPanel);
        this.initialize = panel;
    }

    private void makeTerm() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        this.halt = new JTextField(String.valueOf(this.engine.giveUp));
        panel.add(new JLabel("Termination:                   "));
        panel.add(new JLabel("Halt after "));
        panel.add(this.halt);
        panel.add(new JLabel(" steps.   "));
        this.terminate = panel;
    }

    private void makeStOp(int i) {
        this.stepsOptions = this.optORdesc ? this.searches[i].getOptionsPanel() : this.searches[i].getDescription();
        this.descOpsPane = new JTabbedPane();
        this.descOpsPane.addTab("Options", null, this.stepsOptions, "Click to set the options for the local search");
        this.emptyPanel = new JPanel();
        this.emptyPanel2 = new JPanel();
        this.descOpsPane.addTab("Description", null, this.emptyPanel, "Click to get a description of the local search");
        if (this.optORdesc) {
            this.descOpsPane.setSelectedIndex(0);
        } else {
            this.descOpsPane.setSelectedIndex(1);
        }
        this.descOpsPane.addChangeListener(this);
        this.descOpsPane.setBackground(Color.lightGray);
    }

    private void makeSeAl() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JLabel("Local Search Steps:        "));
        this.alg = new JComboBox();
        int i = 0;
        while (i < this.searches.length) {
            this.alg.addItem(this.searches[i].getName());
            ++i;
        }
        panel.add(this.alg);
        this.alg.setSelectedIndex(this.engine.getSearchIndex());
        this.alg.addItemListener(this);
        this.searchAlgs = panel;
    }

    private void makeSeSt() {
        JPanel panel = new JPanel();
        panel.setLayout(this.gbl);
        this.addComponent(this.searchAlgs, panel, 0, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.descOpsPane, panel, 2, 0, 1, 1, 1.0, 1.0);
        this.searchSteps = panel;
    }

    public void stateChanged(ChangeEvent e) {
        try {
            this.optORdesc = !this.optORdesc;
            this.descOpsPane.setComponentAt(0, this.emptyPanel2);
            this.descOpsPane.setComponentAt(1, this.emptyPanel);
            this.stepsOptions = this.optORdesc ? this.searches[this.alg.getSelectedIndex()].getOptionsPanel() : this.searches[this.alg.getSelectedIndex()].getDescription();
            this.descOpsPane.setComponentAt(this.descOpsPane.getSelectedIndex(), this.stepsOptions);
            this.descOpsPane.setSelectedIndex(this.descOpsPane.getSelectedIndex());
            this.validate();
            this.repaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected boolean actionOK() {
        this.engine.init = this.random.isSelected() ? 1 : 0;
        int n = 0;
        try {
            n = Integer.parseInt(this.halt.getText());
        }
        catch (NumberFormatException nfe) {
            n = 100;
            this.halt.setText(String.valueOf(n));
        }
        this.engine.giveUp = n;
        ((Updateable)((Object)this.searches[this.alg.getSelectedIndex()].getOptionsPanel())).update();
        this.engine.setSearchAlg(this.alg.getSelectedIndex());
        if (!this.engine.canvas.inline) {
            ((HillWindow)this.getParent()).setAlgoText(this.engine.getCurrSearch().getName());
            ((HillWindow)this.getParent()).disableFineStep();
        } else {
            ((InlineHillApplet)this.engine.canvas.parent).setAlgoText(this.engine.getCurrSearch().getName());
            ((InlineHillApplet)this.engine.canvas.parent).disableFineStep();
        }
        return true;
    }

    protected boolean actionCancel() {
        return true;
    }

    public void itemStateChanged(ItemEvent e) {
        this.invalidate();
        int i = ((JComboBox)e.getItemSelectable()).getSelectedIndex();
        this.stepsOptions = this.optORdesc ? this.searches[i].getOptionsPanel() : this.searches[i].getDescription();
        this.descOpsPane.setComponentAt(this.descOpsPane.getSelectedIndex(), this.stepsOptions);
        this.validate();
        this.repaint();
    }
}

