/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.dialogs;

import CIspace.graphToolKit.dialogs.BasicPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PercentPanel
extends BasicPanel
implements ActionListener,
MouseListener,
KeyListener {
    private JTextField[] fields;
    private JLabel[] names;
    private JLabel[] percent;
    private int size;
    private int count;

    public PercentPanel(int n, String title) {
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.setLayout(this.gbl);
        this.fields = new JTextField[n];
        this.names = new JLabel[n];
        this.percent = new JLabel[n];
        this.size = n;
        this.count = 0;
        int i = 0;
        while (i < n) {
            this.percent[i] = new JLabel("%");
            ++i;
        }
        this.addComponent(new JLabel(title), this, 0, 0, 3, 1, 0.0, 0.0);
    }

    public void addField(String name) {
        if (this.count == this.size) {
            return;
        }
        this.fields[this.count] = new JTextField("0", 3);
        this.names[this.count] = new JLabel(name);
        this.addComponent(this.names[this.count], this, this.count + 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.fields[this.count], this, this.count + 1, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.percent[this.count], this, this.count + 1, 2, 1, 1, 0.0, 0.0);
        this.fields[this.count].addActionListener(this);
        this.fields[this.count].addMouseListener(this);
        ++this.count;
    }

    public void addField(String name, int value) {
        if (this.count == this.size) {
            return;
        }
        this.fields[this.count] = new JTextField("0", 3);
        this.names[this.count] = new JLabel(name);
        this.addComponent(this.names[this.count], this, this.count + 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(this.fields[this.count], this, this.count + 1, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.percent[this.count], this, this.count + 1, 2, 1, 1, 0.0, 0.0);
        this.fields[this.count].addActionListener(this);
        this.fields[this.count].addMouseListener(this);
        this.fields[this.count].addKeyListener(this);
        this.fields[this.count].setText(String.valueOf(value));
        ++this.count;
    }

    public void adjust() {
        int n;
        int sum = 0;
        int i = 0;
        while (i < this.count) {
            try {
                n = Integer.parseInt(this.fields[i].getText());
            }
            catch (NumberFormatException nfe) {
                n = 0;
                this.fields[i].setText(String.valueOf(n));
            }
            if (n < 0) {
                n = 0;
                this.fields[i].setText(String.valueOf(n));
            }
            if (sum + n > 100) {
                n = 100 - sum;
                this.fields[i].setText(String.valueOf(n));
            }
            sum += n;
            ++i;
        }
        if (sum < 100) {
            try {
                n = Integer.parseInt(this.fields[this.count - 1].getText());
            }
            catch (NumberFormatException nfe) {
                n = 0;
            }
            this.fields[this.count - 1].setText(String.valueOf(n += 100 - sum));
        }
    }

    public int getValue(int index) {
        int n;
        try {
            n = Integer.parseInt(this.fields[index].getText());
        }
        catch (NumberFormatException nfe) {
            System.out.println(nfe);
            n = -1;
        }
        return n;
    }

    public void setValue(int index, int n) {
        this.fields[index].setText(String.valueOf(n));
    }

    public void actionPerformed(ActionEvent e) {
        this.adjust();
    }

    public void mouseClicked(MouseEvent e) {
        this.adjust();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            this.adjust();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

