/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.elements;

import CIspace.cspTools.domains.DomainDiscrete;
import CIspace.cspTools.elements.CSPVariable;
import CIspace.cspTools.elements.Constraint;
import CIspace.graphToolKit.Graph;
import CIspace.graphToolKit.elements.Point;
import CIspace.hill.HillCSP;
import CIspace.hill.elements.HillConstraint;
import java.util.ArrayList;
import java.util.Arrays;

public class HillVariable
extends CSPVariable {
    private int arrayIndex;
    private int numRedEdges;
    private HillCSP csp;
    protected int[] heapIndices;

    public HillVariable(DomainDiscrete domain, Graph graph, Point point, String string, HillCSP csp) {
        super(domain, graph, point, string);
        this.csp = csp;
        this.arrayIndex = -1;
        this.numRedEdges = 0;
    }

    public void setCurrIndex(int value) {
        this.domain.setSplitElements(new int[]{value});
    }

    public int getCurrIndex() {
        int[] split = this.domain.getSplitElements();
        if (split.length > 0) {
            return split[0];
        }
        return -1;
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public void setArrayIndex(int index) {
        this.arrayIndex = index;
    }

    public void setBold(boolean isBold) {
        this.isBold = isBold;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public int getNumRedEdges() {
        return this.numRedEdges;
    }

    public void setNumRedEdges(int num) {
        this.numRedEdges = num;
    }

    public void addNumRedEdges(int incr) {
        this.numRedEdges += incr;
    }

    public void checkColor() {
        if (this.solve && this.csp.started) {
            ArrayList<Constraint> constraints = this.getConstraints();
            int i = 0;
            while (i < constraints.size()) {
                if (!((HillConstraint)constraints.get(i)).isConsistent()) {
                    if (this.arrayIndex == -1) {
                        this.csp.addToRedNodes(this);
                    }
                    this.color = HillConstraint.COLOR_FALSE;
                    return;
                }
                ++i;
            }
            if (this.arrayIndex != -1) {
                this.csp.removeFromRedNodes(this);
            }
            this.color = HillConstraint.COLOR_TRUE;
        } else {
            this.color = HillConstraint.COLOR_NEUTRAL;
        }
    }

    public void lowIndex() {
        if (this.domain.getSize() == 0) {
            return;
        }
        this.domain.set(new int[0]);
    }

    public void initHeapIndices() {
        if (this.heapIndices == null || this.heapIndices.length != this.domain.getSize()) {
            this.heapIndices = new int[this.domain.getSize()];
        }
        Arrays.fill(this.heapIndices, -1);
    }

    public void setHeapIndex(int i, int newHeapIndex) {
        this.heapIndices[i] = newHeapIndex;
    }

    public int getHeapIndex(int i) {
        return this.heapIndices[i];
    }

    public void setMode(boolean mode) {
        super.setMode(mode);
        this.checkColor();
    }
}

