/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.search;

import CIspace.hill.HillEngine;
import CIspace.hill.elements.NodeVal;
import CIspace.hill.search.Heuristics;
import CIspace.hill.search.LessFullPanel;
import CIspace.hill.search.Search;

public class GreedyRandomRestartSearch
extends Search {
    public int restart;

    public GreedyRandomRestartSearch(HillEngine engine) {
        this.engine = engine;
        this.initHeuristics();
        this.name = "Greedy Descent with Random Restart";
        this.descriptionFile = "GreedyRandomRestartSearch.txt";
        this.restart = 50;
        this.panel = new LessFullPanel(this);
    }

    private void initHeuristics() {
        int[] varHeurs = new int[]{101};
        int[] varValHeurs = new int[]{201};
        int[] secHeurs = new int[]{301};
        this.heuristics = new Heuristics(varHeurs, varValHeurs, secHeurs);
    }

    public boolean fineStep() {
        return this.heuristics.getStages() == 2;
    }

    public void step() {
        if (this.node != null) {
            this.finestep();
            return;
        }
        this.deHighLight();
        if (this.engine.getCurrentStepCount() % this.restart == 0) {
            this.engine.getCSP().reset(1);
        } else {
            NodeVal nodeAndVal;
            if (this.heuristics.getStages() == 1) {
                nodeAndVal = this.getNextNdVal(this.heuristics.getSingleStage());
                this.node = nodeAndVal.getNode();
            } else {
                this.node = this.getNextNode(this.heuristics.getFirstHeur());
                if (this.node == null) {
                    return;
                }
                nodeAndVal = new NodeVal(this.node, this.getNextVal(this.heuristics.getSecHeur(), this.node));
            }
            this.engine.getCSP().setNode(nodeAndVal);
            this.highLight(this.node);
        }
        this.engine.incrementCount();
        this.engine.getCSP().addPlotPoint(this.engine.getCurrentStepCount());
        this.node = null;
    }

    public void finestep() {
        if (this.node != null) {
            NodeVal nodeAndVal = new NodeVal(this.node, this.getNextVal(this.heuristics.getSecHeur(), this.node));
            this.engine.getCSP().setNode(nodeAndVal);
            this.deHighLight();
            this.engine.incrementCount();
            this.engine.getCSP().addPlotPoint(this.engine.getCurrentStepCount());
            this.node = null;
        } else {
            if (this.heuristics.getStages() == 1) {
                return;
            }
            this.node = this.getNextNode(this.heuristics.getFirstHeur());
            if (this.node == null) {
                return;
            }
            this.highLight(this.node);
        }
    }

    public String[][] getSettings() {
        String[][] settings = new String[2][2];
        settings[0][0] = this.heuristics.getStages() == 2 ? "Choose Variable before Value" : "Choose Variable and Value together";
        settings[1][0] = "True";
        settings[1][0] = "Random Restart after ";
        settings[1][1] = String.valueOf(this.restart) + " steps.";
        return settings;
    }
}

