/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.search;

import CIspace.hill.search.NeighbourPanel;
import CIspace.hill.search.VarSettingsPanel;
import CIspace.hill.search.VarValSettingsPanel;
import java.awt.event.ItemListener;
import javax.swing.JPanel;

public class Heuristics {
    public static final int RAND_NODE = 100;
    public static final int BEST_NODE = 101;
    public static final int RAND_RED_NODE = 102;
    public static final int RAND_VAL = 300;
    public static final int BEST_VAL = 301;
    public static final int RAND_ND_VAL = 200;
    public static final int BEST_ND_VAL = 201;
    public static final int RAND_RED_ND_VAL = 202;
    private int maxSteps;
    private float[] varHeursProb;
    private float[] varValHeursProb;
    private float[] secHeursProb;
    private boolean varFirst = true;
    public int[] varHeurs;
    public int[] varValHeurs;
    public int[] secHeurs;

    public Heuristics(int[] varHeurs, int[] varValHeurs, int[] secHeurs) {
        this.varHeurs = varHeurs;
        this.varValHeurs = varValHeurs;
        this.secHeurs = secHeurs;
        if (varHeurs != null) {
            this.varHeursProb = new float[varHeurs.length];
            this.setInitProbs(this.varHeursProb);
        }
        if (varValHeurs != null) {
            this.varValHeursProb = new float[varValHeurs.length];
            this.setInitProbs(this.varValHeursProb);
        }
        if (secHeurs != null) {
            this.secHeursProb = new float[secHeurs.length];
            this.setInitProbs(this.secHeursProb);
        }
        this.maxSteps = 50;
    }

    private void setInitProbs(float[] prob) {
        int i = 1;
        while (i < prob.length) {
            prob[i] = 0.0f;
            ++i;
        }
        prob[0] = 1.0f;
    }

    public void setInitProbs(float[] prob1, float[] prob2, float[] prob3) {
        this.varHeursProb = prob1;
        this.varValHeursProb = prob2;
        this.secHeursProb = prob3;
    }

    public String getName(int heur) {
        switch (heur) {
            case 100: {
                return "random node";
            }
            case 101: {
                return "best node";
            }
            case 102: {
                return "random red node";
            }
            case 200: {
                return "random node and value";
            }
            case 201: {
                return "best node and value";
            }
            case 300: {
                return "random value";
            }
            case 301: {
                return "best value";
            }
        }
        return "heuristic undefined";
    }

    public boolean requiresHeap() {
        return !this.varFirst;
    }

    public int getStages() {
        if (this.varFirst) {
            return 2;
        }
        return 1;
    }

    public int getSingleStage() {
        float rand = (float)Math.random();
        int i = 0;
        float sum = this.varValHeursProb[i];
        while (rand > sum) {
            sum += this.varValHeursProb[++i];
        }
        return this.varValHeurs[i];
    }

    public int getFirstHeur() {
        float rand = (float)Math.random();
        int i = 0;
        float sum = this.varHeursProb[i];
        while (rand > sum) {
            sum += this.varHeursProb[++i];
        }
        return this.varHeurs[i];
    }

    public int getSecHeur() {
        float rand = (float)Math.random();
        int i = 0;
        float sum = this.secHeursProb[i];
        while (rand > sum) {
            sum += this.secHeursProb[++i];
        }
        return this.secHeurs[i];
    }

    public void setVarFirst(boolean bool) {
        this.varFirst = bool;
    }

    public boolean getVarFirst() {
        return this.varFirst;
    }

    public float[] getVarHeursProb() {
        return this.varHeursProb;
    }

    public float[] getVarValHeursProb() {
        return this.varValHeursProb;
    }

    public float[] getSecHeursProb() {
        return this.secHeursProb;
    }

    public void setVarHeursProb(int index, float heur) {
        this.varHeursProb[index] = heur;
    }

    public void setVarValHeursProb(int index, float heur) {
        this.varValHeursProb[index] = heur;
    }

    public void setSecHeursProb(int index, float heur) {
        this.secHeursProb[index] = heur;
    }

    public int getMaxSteps() {
        return this.maxSteps;
    }

    public void setMaxSteps(int max) {
        this.maxSteps = max;
    }

    public JPanel getNeighbourPanel(ItemListener l) {
        return new NeighbourPanel(this, l);
    }

    public JPanel getSettingsPanel(boolean varFirst) {
        if (varFirst) {
            return new VarSettingsPanel(this);
        }
        return new VarValSettingsPanel(this);
    }

    public String[][] getSettings() {
        String[][] settings;
        if (this.varFirst) {
            settings = new String[2][this.varHeurs.length + this.secHeurs.length + 1];
            settings[0][0] = "Choose Variable before Value";
            settings[1][0] = "True";
            int i = 0;
            while (i < this.varHeurs.length) {
                settings[0][i + 1] = "Choose " + this.getName(this.varHeurs[i]) + ":";
                settings[1][i + 1] = String.valueOf((int)(this.varHeursProb[i] * 100.0f)) + "%";
                ++i;
            }
            i = 0;
            while (i < this.secHeurs.length) {
                settings[0][i + 1 + this.varHeurs.length] = "Choose " + this.getName(this.secHeurs[i]) + ":";
                settings[1][i + 1 + this.varHeurs.length] = String.valueOf((int)(this.secHeursProb[i] * 100.0f)) + "%";
                ++i;
            }
        } else {
            settings = new String[2][this.varValHeurs.length + 1];
            settings[0][0] = "Choose Variable and Value together";
            settings[1][0] = "True";
            int i = 0;
            while (i < this.varValHeurs.length) {
                settings[0][i + 1] = "Choose " + this.getName(this.varValHeurs[i]) + ":";
                settings[1][i + 1] = String.valueOf((int)(this.varValHeursProb[i] * 100.0f)) + "%";
                ++i;
            }
        }
        return settings;
    }
}

