/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.search;

import CIspace.hill.HillEngine;
import CIspace.hill.elements.NodeVal;
import CIspace.hill.search.Heuristics;
import CIspace.hill.search.Search;
import CIspace.hill.search.VeryFullPanel;

public class SimpleRandomSearch
extends Search {
    public int restart;

    public SimpleRandomSearch(HillEngine engine) {
        this.engine = engine;
        this.initHeuristics();
        this.name = "Greedy Descent with All Options";
        this.descriptionFile = "SimpleRandomSearch.txt";
        this.restart = 50;
        this.panel = new VeryFullPanel(this);
    }

    private void initHeuristics() {
        this.heuristics = new Heuristics(this.varHeurs, this.varValHeurs, this.secHeurs);
        this.heuristics.setInitProbs(new float[]{0.9f, 0.1f, 0.0f}, new float[]{0.9f, 0.1f}, new float[]{0.9f, 0.1f});
    }

    public boolean fineStep() {
        return this.heuristics.getStages() == 2;
    }

    public void step() {
        if (this.node != null) {
            this.finestep();
            return;
        }
        if (this.engine.getCurrentStepCount() % this.restart == 0) {
            this.engine.getCSP().reset(1);
        } else if (this.heuristics.getStages() == 1) {
            int heur = this.heuristics.getSingleStage();
            NodeVal nodeAndVal = this.getNextNdVal(heur);
            this.engine.getCSP().setNode(nodeAndVal);
        } else {
            int heur = this.heuristics.getFirstHeur();
            int heurB = this.heuristics.getSecHeur();
            this.node = this.getNextNode(heur);
            if (this.node == null) {
                return;
            }
            NodeVal nodeAndVal = new NodeVal(this.node, this.getNextVal(heurB, this.node));
            this.engine.getCSP().setNode(nodeAndVal);
        }
        this.deHighLight();
        this.highLight(this.node);
        this.engine.incrementCount();
        this.engine.getCSP().addPlotPoint(this.engine.getCurrentStepCount());
        this.node = null;
    }

    public void finestep() {
        if (this.node != null) {
            this.engine.getCSP().setNode(new NodeVal(this.node, this.getNextVal(this.heuristics.getSecHeur(), this.node)));
            this.deHighLight();
            this.engine.incrementCount();
            this.engine.getCSP().addPlotPoint(this.engine.getCurrentStepCount());
            this.node = null;
        } else {
            if (this.heuristics.getStages() == 1) {
                return;
            }
            this.node = this.getNextNode(this.heuristics.getFirstHeur());
            if (this.node == null) {
                return;
            }
            this.highLight(this.node);
        }
    }

    public String[][] getSettings() {
        String[][] settings = this.heuristics.getSettings();
        String[][] newSettings = new String[2][settings[0].length + 1];
        int i = 1;
        while (i < newSettings[0].length) {
            newSettings[0][i] = settings[0][i - 1];
            newSettings[1][i] = settings[1][i - 1];
            ++i;
        }
        newSettings[0][0] = "restart after";
        newSettings[1][0] = String.valueOf(this.restart);
        return newSettings;
    }
}

