/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.search;

import CIspace.cspTools.elements.Constraint;
import CIspace.graphToolKit.dialogs.BasicPanel;
import CIspace.hill.HillEngine;
import CIspace.hill.Updateable;
import CIspace.hill.elements.HillConstraint;
import CIspace.hill.elements.HillVariable;
import CIspace.hill.elements.NodeVal;
import CIspace.hill.search.Heuristics;
import CIspace.hill.search.Search;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SimulatedAnnealingSearch
extends Search {
    public static final int CONSTANT = 0;
    public static final int LOGARITHMIC = 2;
    public static final int LINEAR = 1;
    private float curTemp;
    private float time;
    private float startTemp;
    private int descentFunction;
    private float descentAmount;
    private int descentHoldTime;

    public SimulatedAnnealingSearch(HillEngine engine) {
        this.engine = engine;
        this.curTemp = 1000.0f;
        this.startTemp = 1000.0f;
        this.time = 0.0f;
        this.descentFunction = 1;
        this.descentHoldTime = 10;
        this.descentAmount = 10;
        this.varHeurs = new int[]{100};
        this.varValHeurs = new int[]{200};
        this.secHeurs = new int[]{300};
        this.descriptionFile = "SimulatedAnnealSearch.txt";
        this.heuristics = new Heuristics(this.varHeurs, this.varValHeurs, this.secHeurs);
        this.name = "Simulated Annealing";
        this.panel = new SimPanel(this);
    }

    public int getDescentHoldTime() {
        return this.descentHoldTime;
    }

    public void setDescentHoldTime(int time) {
        this.descentHoldTime = time;
    }

    public int getDescentFunction() {
        return this.descentFunction;
    }

    public void setDescentFunction(int fcn) {
        this.descentFunction = fcn;
    }

    public float getDescentAmount() {
        return this.descentAmount;
    }

    public void setDescentAmount(float amount) {
        this.descentAmount = amount;
    }

    public float getStartTemperature() {
        return this.startTemp;
    }

    public void setStartTemperature(float temp) {
        this.startTemp = temp;
    }

    public float getCurrentTemperature() {
        return this.curTemp;
    }

    public float getTime() {
        return this.time;
    }

    public boolean fineStep() {
        return false;
    }

    private int getBenefit(HillVariable var, int choice) {
        int change = 0;
        for (Constraint c : var.getConstraints()) {
            HillConstraint cns = (HillConstraint)c;
            boolean consistent = cns.isConsistent();
            int varIndex = cns.getVariables().indexOf(var);
            boolean currConsistent = cns.viable(varIndex, choice);
            if (currConsistent == consistent) continue;
            if (currConsistent) {
                ++change;
                continue;
            }
            --change;
        }
        return change;
    }

    public void step() {
        int choice;
        HillVariable var = (HillVariable)this.engine.getCSP().getVariables().get((int)(Math.random() * (double)this.engine.getCSP().getVariables().size()));
        int benefit = this.getBenefit(var, choice = (int)(Math.random() * (double)var.getDomain().getSize()));
        if (benefit >= 0 || Math.exp((float)benefit / this.curTemp) > Math.random()) {
            this.engine.getCSP().setNode(new NodeVal(var, choice, benefit));
        }
        if (this.descentFunction != 0 && (this.time += 1.0f) % (float)this.descentHoldTime == 0.0f) {
            this.adjustTemp();
        }
        this.engine.incrementCount();
        this.engine.getCSP().addPlotPoint(this.engine.getCurrentStepCount());
    }

    private void adjustTemp() {
        switch (this.descentFunction) {
            case 1: {
                this.adjustLinear();
                break;
            }
            case 2: {
                this.adjustLogarithmic();
                break;
            }
        }
    }

    private void adjustLogarithmic() {
        this.curTemp *= 1.0f - this.descentAmount;
    }

    private void adjustLinear() {
        this.curTemp -= this.descentAmount;
        if (this.curTemp <= 0.0f) {
            this.curTemp = 0.1f;
        }
    }

    public void reset() {
        this.curTemp = this.startTemp;
        this.time = 0.0f;
    }

    public String[][] getSettings() {
        String[][] settings = new String[2][4];
        settings[0][0] = "Starting Temperature";
        settings[1][0] = String.valueOf(this.startTemp);
        settings[0][1] = "Descent Function";
        switch (this.descentFunction) {
            case 1: {
                settings[1][1] = "Linear";
                break;
            }
            case 2: {
                settings[1][1] = "Logarithmic";
                break;
            }
            case 0: {
                settings[1][1] = "Constant";
            }
        }
        settings[0][2] = "Descent Rate";
        settings[1][2] = String.valueOf(this.descentAmount);
        settings[0][3] = "Maintain Temperature";
        settings[1][3] = String.valueOf(this.descentHoldTime) + " Attempts";
        return settings;
    }

    private class SimPanel
    extends BasicPanel
    implements Updateable,
    ItemListener {
        private JTextField startTempTextField;
        private JTextField descentRateTextField;
        private JTextField descentHoldTimeTextField;
        private JComboBox functionComboBox;
        private JLabel descentTypeLabel;
        private SimulatedAnnealingSearch search;

        public SimPanel(SimulatedAnnealingSearch search) {
            this.search = search;
            this.gbl = new GridBagLayout();
            this.gbc = new GridBagConstraints();
            this.gbc.anchor = 18;
            this.gbc.fill = 1;
            this.setLayout(this.gbl);
            this.startTempTextField = new JTextField(String.valueOf(search.getStartTemperature()), 4);
            this.functionComboBox = new JComboBox();
            this.functionComboBox.addItem("Constant");
            this.functionComboBox.addItem("Linear");
            this.functionComboBox.addItem("Logarithmic");
            this.functionComboBox.setSelectedIndex(search.getDescentFunction());
            this.functionComboBox.addItemListener(this);
            this.descentRateTextField = new JTextField(String.valueOf(search.getDescentAmount()), 4);
            this.descentHoldTimeTextField = new JTextField(String.valueOf(search.getDescentHoldTime()), 4);
            this.descentTypeLabel = new JLabel("degrees");
            this.addComponent(new JLabel("Starting Temperature"), this, 0, 0, 1, 1, 0.0, 0.0);
            this.addComponent(this.startTempTextField, this, 0, 1, 1, 1, 0.0, 0.0);
            this.addComponent(new JLabel("degrees"), this, 0, 2, 1, 1, 0.0, 0.0);
            this.addComponent(new JLabel("Descent Function"), this, 1, 0, 1, 1, 0.0, 0.0);
            this.addComponent(this.functionComboBox, this, 1, 1, 2, 1, 0.0, 0.0);
            this.addComponent(new JLabel("Descent Rate"), this, 2, 0, 1, 1, 0.0, 0.0);
            this.addComponent(this.descentTypeLabel, this, 2, 2, 1, 1, 0.0, 0.0);
            this.addComponent(this.descentRateTextField, this, 2, 1, 1, 1, 0.0, 0.0);
            this.addComponent(new JLabel("Maintain Temperature for"), this, 3, 0, 1, 1, 0.0, 0.0);
            this.addComponent(this.descentHoldTimeTextField, this, 3, 1, 1, 1, 0.0, 0.0);
            this.addComponent(new JLabel("Attempts"), this, 3, 2, 1, 1, 0.0, 0.0);
        }

        public void update() {
            int i;
            float n;
            try {
                n = Float.parseFloat(this.startTempTextField.getText());
            }
            catch (NumberFormatException nfe) {
                n = 1.0f;
            }
            if (n < 0.0f) {
                n = 100.0f;
            }
            this.startTempTextField.setText(String.valueOf(n));
            this.search.setStartTemperature(n);
            try {
                n = Float.parseFloat(this.descentRateTextField.getText());
            }
            catch (NumberFormatException nfe) {
                n = 1.0f;
            }
            if (n < 0.0f) {
                n = -n;
            }
            this.descentRateTextField.setText(String.valueOf(n));
            this.search.setDescentAmount(n);
            try {
                i = Integer.parseInt(this.descentHoldTimeTextField.getText());
            }
            catch (NumberFormatException nfe) {
                i = 1;
            }
            this.search.setDescentHoldTime(i);
            this.descentHoldTimeTextField.setText(String.valueOf(i));
            this.search.setDescentFunction(this.functionComboBox.getSelectedIndex());
        }

        public void itemStateChanged(ItemEvent e) {
            this.invalidate();
            float descentRate = 10.0f;
            long descentHold = 10L;
            try {
                if (!this.descentRateTextField.getText().equals("")) {
                    descentRate = Float.parseFloat(this.descentRateTextField.getText());
                }
                if (!this.descentHoldTimeTextField.getText().equals("")) {
                    descentHold = Long.parseLong(this.descentHoldTimeTextField.getText());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (this.functionComboBox.getSelectedIndex()) {
                case 0: {
                    this.descentHoldTimeTextField.setEditable(false);
                    this.descentHoldTimeTextField.setText("");
                    this.descentRateTextField.setEditable(false);
                    this.descentTypeLabel.setText("");
                    this.descentRateTextField.setText("");
                    break;
                }
                case 2: {
                    this.descentHoldTimeTextField.setEditable(true);
                    this.descentRateTextField.setEditable(true);
                    this.descentTypeLabel.setText("%");
                    if (descentRate > 100.0f) {
                        descentRate = 100.0f;
                    } else if (descentRate < 0.0f) {
                        descentRate = 10.0f;
                    }
                    this.descentRateTextField.setText(String.valueOf(descentRate));
                    this.descentHoldTimeTextField.setText(String.valueOf(descentHold));
                    break;
                }
                case 1: {
                    this.descentHoldTimeTextField.setEditable(true);
                    this.descentRateTextField.setEditable(true);
                    this.descentTypeLabel.setText("degrees");
                    if (descentRate < 0.0f) {
                        descentRate = 10.0f;
                    }
                    this.descentRateTextField.setText(String.valueOf(descentRate));
                    this.descentHoldTimeTextField.setText(String.valueOf(descentHold));
                }
            }
            this.validate();
        }
    }
}

