/*
 * Decompiled with CFR 0.152.
 */
package CIspace.hill.search;

import CIspace.hill.Updateable;
import CIspace.hill.dialogs.PercentPanel;
import CIspace.hill.search.Heuristics;
import java.awt.FlowLayout;
import javax.swing.JPanel;

class VarSettingsPanel
extends JPanel
implements Updateable {
    public PercentPanel var;
    public PercentPanel val;
    private Heuristics heuristics;

    public VarSettingsPanel(Heuristics heuristics) {
        this.heuristics = heuristics;
        FlowLayout layout = new FlowLayout();
        this.setLayout(layout);
        this.var = new PercentPanel(heuristics.varHeurs.length, "Heuristics For Variable Choice");
        this.val = new PercentPanel(heuristics.varHeurs.length, "Heuristics For Value Choice");
        this.makePercent(this.var, heuristics.varHeurs, heuristics.getVarHeursProb());
        this.makePercent(this.val, heuristics.secHeurs, heuristics.getSecHeursProb());
        this.add(this.var);
        this.add(this.val);
    }

    private void makePercent(PercentPanel percent, int[] heurs, float[] probs) {
        int i = 0;
        while (i < heurs.length) {
            percent.addField(this.heuristics.getName(heurs[i]), (int)(100.0f * probs[i]));
            ++i;
        }
    }

    public void update() {
        this.var.adjust();
        this.val.adjust();
        int i = 0;
        while (i < this.heuristics.varHeurs.length) {
            this.heuristics.setVarHeursProb(i, (float)this.var.getValue(i) / 100.0f);
            ++i;
        }
        i = 0;
        while (i < this.heuristics.secHeurs.length) {
            this.heuristics.setSecHeursProb(i, (float)this.val.getValue(i) / 100.0f);
            ++i;
        }
    }
}

