/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools;

import AIspace.cspTools.CSPcanvas;
import AIspace.cspTools.CSPgraph;
import AIspace.cspTools.IO;
import AIspace.cspTools.domains.DomainDiscrete;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.cspTools.elements.VariableEdge;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Point;
import java.awt.Container;
import java.util.ArrayList;

public class CSP
implements Cloneable {
    private static int CHAR_LENGTH = 20;
    private String name = "Untitled";
    protected String shortDescription = "";
    protected String detailedDescription = "";
    protected ArrayList<Constraint> constraints;
    protected ArrayList<CSPVariable> variables;
    protected ArrayList<String> variableNames;
    public int varIndex = 0;
    protected CSPgraph graph;
    protected CSPcanvas canvas;
    protected Container parent;
    protected boolean inline;

    public CSP(Container parent, boolean inline) {
        this.parent = parent;
        this.inline = inline;
    }

    public void init(CSPcanvas canvas) {
        this.varIndex = 0;
        this.constraints = new ArrayList();
        this.variables = new ArrayList();
        this.variableNames = new ArrayList();
        this.shortDescription = new String();
        this.detailedDescription = new String();
        this.canvas = canvas;
        canvas.reset();
        this.graph = (CSPgraph)canvas.graph;
    }

    public void initFromText(CSPcanvas canvas, String xml) {
        this.init(canvas);
        IO.parseXML(xml, this);
    }

    public Constraint newConstraint(CSPgraph graph, Point p, ArrayList<CSPVariable> variables, int draw, CSP csp) {
        return new Constraint(graph, p, variables, draw, csp);
    }

    public CSPVariable newVariable(DomainDiscrete dom, CSPgraph graph, Point p) {
        return new CSPVariable(dom, graph, p, this.getName());
    }

    public ConstraintEdge newConstraintEdge(Constraint constraint, Graph graph, CSPVariable variable) {
        return new ConstraintEdge(constraint, graph, variable);
    }

    public VariableEdge newVariableEdge(Constraint constraint, Graph graph, CSPVariable node1, CSPVariable node2) {
        return new VariableEdge(constraint, graph, node1, node2);
    }

    public void resetVariables() {
        for (CSPVariable v : this.variables) {
            v.reset();
            v.setLabel();
        }
    }

    public void resetLabels() {
        for (CSPVariable v : this.variables) {
            v.setLabel();
        }
        for (Constraint c : this.constraints) {
            c.setLabel();
        }
    }

    public String getName() {
        int var = this.varIndex;
        while (this.variableNames.contains("N" + var)) {
            ++var;
        }
        return "N" + var;
    }

    public Point getPos() {
        Point p = new Point();
        p.y = 0.0f;
        p.x = this.varIndex * 20 - 100;
        return p;
    }

    public final boolean addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        return true;
    }

    public final boolean remConstraint(Constraint constraint) {
        return this.constraints.remove(constraint);
    }

    public final boolean addVariable(CSPVariable variable) {
        this.variables.add(variable);
        this.variableNames.add(variable.getName());
        this.graph.addNode(variable);
        return true;
    }

    public final boolean remVariable(CSPVariable variable) {
        this.variableNames.remove(variable.getName());
        this.graph.removeNode(variable);
        return this.variables.remove(variable);
    }

    public final CSPcanvas getCanvas() {
        return this.canvas;
    }

    public final void changeDisplayMode() {
        for (Constraint c : this.constraints) {
            c.changeDisplayMode();
        }
    }

    public final CSPVariable getRandVariable() {
        return this.variables.get((int)Math.floor(Math.random() * (double)this.variables.size()));
    }

    public final Constraint getRandConstraint() {
        return this.constraints.get((int)Math.floor(Math.random() * (double)this.constraints.size()));
    }

    public final int numVariables() {
        return this.variables.size();
    }

    public final int numConstraints() {
        return this.constraints.size();
    }

    public final boolean nameOK(String name) {
        if (this.variableNames.contains(name)) {
            this.canvas.showMessage("Error in Name", "Name has already been used.");
            return false;
        }
        if (name == "") {
            this.canvas.showMessage("Error in Name", "Must provide a name.");
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == ' ') {
                this.canvas.showMessage("Error in Name", "Name cannot have spaces.");
                return false;
            }
            ++i;
        }
        return true;
    }

    public final ArrayList<ConstraintEdge> getConstraintEdges() {
        ArrayList<ConstraintEdge> edges = new ArrayList<ConstraintEdge>();
        for (Constraint c : this.constraints) {
            for (ConstraintEdge e : c.getConstraintEdges()) {
                edges.add(e);
            }
        }
        return edges;
    }

    public final ArrayList<Constraint> getConstraints() {
        return new ArrayList<Constraint>(this.constraints);
    }

    public final ArrayList<CSPVariable> getVariables() {
        return new ArrayList<CSPVariable>(this.variables);
    }

    public final CSPVariable getVariable(int index) {
        return this.variables.get(index);
    }

    public final CSPVariable getVariable(String name) {
        for (CSPVariable v : this.variables) {
            if (!v.getName().equals(name)) continue;
            return v;
        }
        return null;
    }

    public void setMode(boolean solve) {
        for (Constraint c : this.constraints) {
            c.setMode(solve);
        }
        for (CSPVariable v : this.variables) {
            v.setMode(solve);
        }
        this.resetVariables();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortDesc(String description) {
        this.shortDescription = description;
        if (description.trim().equals("") || description == null) {
            this.shortDescription = "";
        }
    }

    public void setDetailedDesc(String description) {
        this.detailedDescription = description;
        if (description.trim().equals("") || description == null) {
            this.detailedDescription = "";
        }
    }

    public final String getShortDesc() {
        return this.shortDescription;
    }

    public final String getDetailedDesc() {
        return this.detailedDescription;
    }

    public void checkEditablity() {
        for (CSPVariable v : this.variables) {
            v.setEdit(true);
        }
        for (Constraint c : this.constraints) {
            ArrayList<CSPVariable> vars = c.getVariables();
            for (CSPVariable v : vars) {
                v.setEdit(false);
            }
        }
    }

    public void setPosition() {
        for (Constraint c : this.constraints) {
            c.setPosition();
        }
    }

    public static void intSort(int[] vars) {
        int i = 1;
        while (i < vars.length) {
            int var = vars[i];
            int j = i - 1;
            while (j >= 0 && vars[j] > var) {
                vars[j + 1] = vars[j];
                --j;
            }
            vars[j + 1] = var;
            ++i;
        }
    }

    public String toXML(String indent, boolean current) {
        StringBuffer rep = new StringBuffer();
        rep.append(indent).append("<").append("CSP").append(">\n");
        rep.append(indent).append("<").append("NAME").append(">");
        rep.append(this.name);
        rep.append(indent).append("</").append("NAME").append(">\n");
        if (this.shortDescription != null && this.detailedDescription != null) {
            rep.append(indent).append("<").append("DESCRIPTION").append(">\n");
            rep.append(indent).append("\t<").append("SHORT").append(">");
            rep.append(this.shortDescription);
            rep.append(indent).append(indent).append("</").append("SHORT").append(">\n");
            rep.append(indent).append("\t<").append("DETAILED").append(">");
            rep.append(this.detailedDescription);
            rep.append(indent).append("</").append("DETAILED").append(">\n");
            rep.append(indent).append("</").append("DESCRIPTION").append(">\n");
        }
        for (CSPVariable v : this.variables) {
            rep.append(v.toXML(indent, current));
        }
        for (Constraint c : this.constraints) {
            rep.append(c.toXML(indent));
        }
        rep.append(indent).append("</").append("CSP").append(">\n");
        return rep.toString();
    }

    public static String trim(String s) {
        if (s.length() < CHAR_LENGTH) {
            return s;
        }
        return String.valueOf(s.substring(0, 16)) + "...";
    }
}

