/*
 * Decompiled with CFR 0.152.
 */
package AIspace.cspTools;

import AIspace.cspTools.CSP;
import AIspace.cspTools.CSPcanvas;
import AIspace.cspTools.elements.CSPVariable;
import AIspace.cspTools.elements.Constraint;
import AIspace.cspTools.elements.ConstraintEdge;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Node;
import java.util.ArrayList;

public class CSPgraph
extends Graph {
    protected CSP csp;

    public CSPgraph(CSP csp, CSPcanvas canvas) {
        super(canvas);
        this.csp = csp;
    }

    public void remove(Entity ent) {
        if (ent instanceof Node) {
            this.nodes.remove(ent);
        }
        if (ent instanceof Edge) {
            this.edges.remove(ent);
        }
    }

    @Override
    public void deleteSelected() {
        for (Edge e : this.selectedEdges) {
            if (!(e instanceof ConstraintEdge)) continue;
            this.deleteConstraintEdge((ConstraintEdge)e);
        }
        for (Node n : this.selectedNodes) {
            if (n instanceof Constraint) {
                this.deleteConstraint((Constraint)n);
                continue;
            }
            if (!(n instanceof CSPVariable)) continue;
            this.deleteVariable((CSPVariable)n);
        }
        this.csp.checkEditablity();
        super.deleteSelected();
    }

    private void deleteConstraintEdge(ConstraintEdge edge) {
        CSPVariable var = edge.getVariable();
        Constraint cns = edge.getConstraint();
        if (cns != null && var != null) {
            cns.removeVariable(var);
        }
    }

    private void deleteConstraint(Constraint cns) {
        cns.delete();
        this.csp.remConstraint(cns);
    }

    private void deleteVariable(CSPVariable var) {
        ArrayList<Edge>[] varEdges = var.getAllEdges();
        int i = 0;
        while (i < 2) {
            int j = varEdges[i].size() - 1;
            while (j >= 0) {
                if (varEdges[i].get(j) instanceof ConstraintEdge) {
                    this.deleteConstraintEdge((ConstraintEdge)varEdges[i].get(j));
                }
                --j;
            }
            ++i;
        }
        this.nodes.remove(var);
        this.csp.remVariable(var);
    }
}

