/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit;

import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.LabelCanvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public abstract class InlineApplet
extends JApplet
implements ActionListener,
ComponentListener {
    private static final long serialVersionUID = 1L;
    protected GraphCanvas canvas;
    protected JToggleButton[] buttons;
    protected LabelCanvas messageCanvas;
    protected JPanel canvasPanel;
    protected GridBagConstraints gbc;
    protected GridBagLayout gbl;
    protected JPanel mainPanel;
    protected JPanel toolBarPanel;
    protected boolean showMessagePanel = false;
    protected boolean popupMenuOn = true;
    protected boolean autoscale = true;
    protected boolean showBorder = false;
    protected boolean showButtons = false;
    public boolean textRepresentationPopupOn = false;
    protected boolean incorrectParameter = false;

    public void init() {
        this.setBackground(GraphConsts.bg);
        this.setForeground(GraphConsts.fg);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.mainPanel = new JPanel();
        this.messageCanvas = new LabelCanvas();
        this.canvasPanel = new JPanel();
        this.canvasPanel.setBackground(Color.white);
        this.canvasPanel.setLayout(this.gbl);
    }

    public GraphCanvas getCanvas() {
        return this.canvas;
    }

    public boolean isPopupMenuOn() {
        return this.popupMenuOn;
    }

    protected void loadParams() {
        String param = this.getParameter("autoscale");
        if (param != null) {
            if (param.equals("off")) {
                this.autoscale = false;
            } else if (!param.equals("on")) {
                this.incorrectParameter("autoscale", param);
            }
        }
        if ((param = this.getParameter("filename")) != null) {
            this.load(param);
        }
        if ((param = this.getParameter("messagePanel")) != null) {
            if (param.equals("on")) {
                this.showMessagePanel = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("messagePanel", param);
            }
        }
        if ((param = this.getParameter("popMenu")) != null) {
            if (param.equals("off")) {
                this.popupMenuOn = false;
            } else if (!param.equals("on")) {
                this.incorrectParameter("popMenu", param);
            }
        }
        if ((param = this.getParameter("border")) != null) {
            if (param.equals("on")) {
                this.showBorder = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("border", param);
            }
        }
        if ((param = this.getParameter("textRepresentationPopup")) != null) {
            if (param.equals("on")) {
                this.textRepresentationPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("textRepresentationPopup", param);
            }
        }
    }

    protected void incorrectParameter(String param, String value) {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new FlowLayout());
        this.getContentPane().add(new JLabel("<html><font color=red>\"" + value + "\" is not a valid value for the " + "\"" + param + "\" parameter.</font></html>"));
        this.incorrectParameter = true;
    }

    public abstract void load(String var1);

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = GraphWindow.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    protected void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.add(c);
    }

    protected void setSolveButtonsWithText(int num, String buttonName, ImageIcon icon, String toolTip) {
        this.buttons[num] = new JToggleButton(buttonName, icon);
        this.buttons[num].addActionListener(this);
        this.buttons[num].setActionCommand(toolTip);
        this.buttons[num].setToolTipText(toolTip);
        this.buttons[num].setVerticalTextPosition(3);
        this.buttons[num].setHorizontalTextPosition(0);
    }

    public void setPromptLabel(String str) {
        this.messageCanvas.setText(str);
    }

    public String getPromptLabel() {
        return this.messageCanvas.getText();
    }

    public void actionPerformed(ActionEvent e) {
        this.canvas.actionPerformed(e);
    }

    public void componentResized(ComponentEvent e) {
        if (this.autoscale) {
            this.canvas.autoscale();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }
}

