/*
 * Decompiled with CFR 0.152.
 */
package AIspace.graphToolKit.help;

import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.dialogs.AboutDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class HelpMenu
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String aboutAIspaceURL = "http://www.aispace.org/";
    private String appletName;
    private JFrame parent;
    protected JEditorPane htmlPane;

    public HelpMenu(String name, JFrame parent) {
        super("Help");
        this.appletName = name;
        this.parent = parent;
        this.setMnemonic(72);
        JMenuItem mi = new JMenuItem("Legend for Nodes/Edges");
        mi.setMnemonic(76);
        mi.setActionCommand(mi.getText());
        mi.addActionListener((GraphWindow)parent);
        this.add(mi);
        mi = new JMenuItem("Online Help");
        mi.setMnemonic(72);
        mi.addActionListener(this);
        this.add(mi);
        mi = new JMenuItem("Online Tutorials");
        mi.setMnemonic(84);
        mi.addActionListener(this);
        this.add(mi);
        this.addSeparator();
        mi = new JMenuItem("About AIspace");
        mi.setMnemonic(67);
        mi.addActionListener(this);
        this.add(mi);
        mi = new JMenuItem("About this Tool");
        mi.setMnemonic(65);
        mi.addActionListener(this);
        this.add(mi);
    }

    public void openBrowserHelp(String helptype) {
        String url = aboutAIspaceURL + this.appletName + "/help/" + helptype;
        String errMsg = "Error attempting to launch a web browser";
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find a web browser.");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, String.valueOf(errMsg) + ":\n" + e.getLocalizedMessage(), "Error", 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Online Help") {
            if (((GraphWindow)this.parent).getTabIndex() == 0) {
                this.openBrowserHelp("general.shtml#create");
            } else {
                this.openBrowserHelp("general.shtml#solve");
            }
        } else if (e.getActionCommand() == "Online Tutorials") {
            this.openBrowserHelp("tutorials.shtml");
        } else if (e.getActionCommand() == "About AIspace") {
            new AboutDialog(this.parent, true);
        } else if (e.getActionCommand() == "About this Tool") {
            new AboutDialog(this.parent, false);
        }
    }
}

