/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill;

import AIspace.cspTools.elements.Constraint;
import AIspace.graphToolKit.elements.Point;
import AIspace.hill.NodeDetailFrame;
import AIspace.hill.elements.HillConstraint;
import AIspace.hill.elements.HillVariable;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class NodeDetailCanvas
extends JPanel
implements MouseListener,
MouseMotionListener {
    private HillVariable node;
    private int width;
    private int height;
    private Font font;
    private float lineWidth;
    private float arrowHeight;
    private float arrowWidth;
    private boolean sizeUpdated;
    private ArrayList<String> elements;
    private ArrayList<Point> positions;
    private ArrayList<Boolean> edgeGreen;
    private ArrayList<Constraint> neighbors;
    private ArrayList changes;
    private int numRedEdges;
    private int numNewRedEdges;
    private ArrayList<Integer> quadrants;
    private static final int NORTH = 440;
    private static final int WEST = 441;
    private static final int SOUTH = 442;
    private static final int EAST = 443;
    private int oldIndex;
    private int currIndex;
    private int elementWidth;
    private int elementHeight;
    private int elementAscent;
    private ActionListener actionListener = null;
    private ActionEvent event;
    private NodeDetailFrame parent;

    public NodeDetailCanvas(NodeDetailFrame frame) {
        this.parent = frame;
        this.setFont(new Font("SansSerif", 0, 12));
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.event = new ActionEvent(this, 1001, "select");
    }

    public int[] setNode(HillVariable node) {
        this.node = node;
        this.oldIndex = node.getCurrIndex();
        this.numRedEdges = 0;
        this.numNewRedEdges = 0;
        this.elements = new ArrayList();
        String[] array = node.getDomain().getDomain();
        int i = 0;
        while (i < array.length) {
            this.elements.add(array[i]);
            ++i;
        }
        this.currIndex = -1;
        this.elementAscent = 0;
        this.elementHeight = 0;
        this.elementWidth = 0;
        this.neighbors = node.getConstraints();
        this.findQuadrants();
        ArrayList<Constraint> edges = node.getConstraints();
        this.edgeGreen = new ArrayList(edges.size());
        int i2 = 0;
        while (i2 < edges.size()) {
            HillConstraint edge = (HillConstraint)edges.get(i2);
            boolean consistent = edge.isConsistent();
            this.edgeGreen.add(new Boolean(consistent));
            if (!consistent) {
                ++this.numRedEdges;
            }
            ++i2;
        }
        FontMetrics fm = this.getFontMetrics(this.font);
        int x = fm.stringWidth(", ");
        int y = fm.getHeight() + fm.getAscent();
        boolean wrapped = false;
        this.positions = new ArrayList();
        int i3 = 0;
        while (i3 < this.elements.size()) {
            Point p;
            int strW = fm.stringWidth(String.valueOf(this.elements.get(i3).toString()) + ", ");
            if ((x += strW) > 400) {
                wrapped = true;
                x = fm.stringWidth(", ");
                p = new Point(x, y += fm.getHeight() * 2 - fm.getDescent());
                x += strW;
            } else {
                p = new Point(x - strW, y);
            }
            this.positions.add(p);
            ++i3;
        }
        this.width = wrapped ? 400 : x;
        this.height = y + fm.getHeight();
        this.changes = new ArrayList(edges.size());
        i3 = 0;
        while (i3 < this.changes.size()) {
            this.changes.add(new Boolean(false));
            ++i3;
        }
        this.sizeUpdated = false;
        int[] dim = new int[]{this.width + 200, this.height + 200};
        return dim;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
    }

    public void setFontSize(int fontSize) {
        this.setFont(new Font("SansSerif", 0, fontSize));
    }

    public void setEdgeProperties(float lineWidth, float arrowHeight, float arrowWidth) {
        this.lineWidth = lineWidth;
        this.arrowHeight = arrowHeight;
        this.arrowWidth = arrowWidth;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.node == null) {
            return;
        }
        if (!this.sizeUpdated) {
            this.repaint();
            this.sizeUpdated = true;
        }
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.white);
        g.fillRoundRect(this.getWidth() / 2 - this.width / 2, this.getHeight() / 2 - this.height / 2, this.width, this.height, 5, 5);
        this.drawNeighbors(g);
        g.setColor(Color.black);
        g.drawRoundRect(this.getWidth() / 2 - this.width / 2, this.getHeight() / 2 - this.height / 2, this.width, this.height, 5, 5);
        this.drawElements(g);
        this.drawStats(g);
    }

    private void drawNeighbors(Graphics g) {
        int i = 0;
        while (i < this.neighbors.size()) {
            Point p = ((HillConstraint)this.neighbors.get((int)i)).pos;
            float dx = p.x - this.node.pos.x;
            float dy = p.y - this.node.pos.y;
            Point a = new Point(this.getWidth() / 2, this.getHeight() / 2);
            Point b = new Point(a.x + dx, a.y + dy);
            Point p1 = new Point(0.0f, 0.0f);
            Point p2 = new Point(0.0f, this.getHeight());
            Point p3 = new Point(this.getWidth(), this.getHeight());
            Point p4 = new Point(this.getWidth(), 0.0f);
            p1.move(20.0f, 20.0f);
            p2.move(20.0f, this.getHeight() - 20);
            p3.move(this.getWidth() - 20, this.getHeight() - 20);
            p4.move(this.getWidth() - 20, 20.0f);
            Point middle = this.findBorder(a, b, p1, p2, p3, p4);
            p1.move(this.getWidth() / 2 - this.width / 2, this.getHeight() / 2 - this.height / 2);
            p2.move(this.getWidth() / 2 - this.width / 2, this.getHeight() / 2 + this.height / 2);
            p3.move(this.getWidth() / 2 + this.width / 2, this.getHeight() / 2 + this.height / 2);
            p4.move(this.getWidth() / 2 + this.width / 2, this.getHeight() / 2 - this.height / 2);
            Point inner = this.findBorder(a, b, p1, p2, p3, p4);
            if (this.edgeGreen.get(i).booleanValue()) {
                g.setColor(Color.green);
            } else {
                g.setColor(Color.red);
            }
            this.drawEdge(g, inner, middle);
            ++i;
        }
    }

    private void drawEdge(Graphics g, Point inner, Point outer) {
        float lineLength = (float)Math.sqrt((outer.x - inner.x) * (outer.x - inner.x) + (outer.y - inner.y) * (outer.y - inner.y));
        float moveX = this.lineWidth / lineLength * (outer.x - inner.x);
        float moveY = this.lineWidth / lineLength * (outer.y - inner.y);
        Point p1 = new Point(inner);
        Point p2 = new Point(p1);
        Point p3 = new Point(outer);
        Point p4 = new Point(p3);
        p1.translate(-moveY + 3.0f * moveX, moveX + 3.0f * moveY);
        p2.translate(moveY + 3.0f * moveX, -moveX + 3.0f * moveY);
        p3.translate(moveY, -moveX);
        p4.translate(-moveY, moveX);
        int[] x = new int[]{(int)p1.x, (int)p2.x, (int)p3.x, (int)p4.x};
        int[] y = new int[]{(int)p1.y, (int)p2.y, (int)p3.y, (int)p4.y};
        g.fillPolygon(x, y, 4);
        float dx = inner.x - outer.x;
        float dy = inner.y - outer.y;
        p1 = new Point(inner);
        p1.translate(-this.arrowHeight / lineLength * dx, -this.arrowHeight / lineLength * dy);
        p2 = new Point(p1);
        p1.translate(-this.arrowWidth / lineLength * dy, this.arrowWidth / lineLength * dx);
        p2.translate(this.arrowWidth / lineLength * dy, -this.arrowWidth / lineLength * dx);
        int[] x2 = new int[]{(int)inner.x, (int)p1.x, (int)p2.x};
        int[] y2 = new int[]{(int)inner.y, (int)p1.y, (int)p2.y};
        g.fillPolygon(x2, y2, 3);
    }

    private void drawElements(Graphics g) {
        Point origin = new Point(this.getWidth() / 2 - this.width / 2, this.getHeight() / 2 - this.height / 2);
        int i = 0;
        while (i < this.elements.size()) {
            Point p = this.positions.get(i);
            if (i == this.oldIndex) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(Color.black);
                if (i == this.currIndex) {
                    g.fillRect((int)(p.x + origin.x), (int)(p.y + origin.y) - this.elementAscent, this.elementWidth, this.elementHeight);
                    g.setColor(Color.white);
                }
            }
            g.setFont(this.font);
            g.drawString(this.elements.get(i).toString(), (int)(p.x + origin.x), (int)(p.y + origin.y));
            ++i;
        }
    }

    private void drawStats(Graphics g) {
        int x0 = 10;
        int y0 = 15;
        FontMetrics fm = this.getFontMetrics(this.font);
        int h = fm.getHeight();
        switch (this.quadrants.size()) {
            case 1: {
                if (this.quadrants.get(0) == 440) {
                    y0 = this.getHeight() - 2 * h;
                    break;
                }
                y0 = h;
                break;
            }
            case 2: {
                int quad1 = this.quadrants.get(0);
                int quad2 = this.quadrants.get(1);
                if (quad1 == 440 || quad2 == 440) {
                    y0 = this.getHeight() - 2 * h;
                    break;
                }
                y0 = h;
                break;
            }
            case 3: {
                if (this.quadrants.contains(new Integer(440))) {
                    y0 = this.getHeight() - 2 * h;
                    break;
                }
                y0 = h;
                break;
            }
            case 4: {
                y0 = h;
            }
        }
        g.setColor(Color.black);
        g.drawString("# Red Edges: " + this.numRedEdges, x0, y0);
        g.drawString("# New Red Edges: " + this.numNewRedEdges, x0, y0 + h);
    }

    private void findQuadrants() {
        this.quadrants = new ArrayList(4);
        int i = 0;
        while (i < this.neighbors.size()) {
            Integer east;
            Integer south;
            Point a = new Point(this.node.pos);
            Point b = new Point(((HillConstraint)this.neighbors.get((int)i)).pos);
            if (b.y < a.y - 10.0f) {
                Integer north = new Integer(440);
                if (!this.quadrants.contains(north)) {
                    this.quadrants.add(north);
                }
            } else if (b.y > a.y + 10.0f && !this.quadrants.contains(south = new Integer(442))) {
                this.quadrants.add(south);
            }
            if (b.x < a.x - 10.0f) {
                Integer west = new Integer(441);
                if (!this.quadrants.contains(west)) {
                    this.quadrants.add(west);
                }
            } else if (b.x > a.x + 10.0f && !this.quadrants.contains(east = new Integer(443))) {
                this.quadrants.add(east);
            }
            if (this.quadrants.size() >= 4) {
                return;
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point findBorder(Point a, Point b, Point p1, Point p2, Point p3, Point p4) {
        float tmp2;
        Point c = new Point(0.0f, 0.0f);
        Point d = new Point(0.0f, 0.0f);
        float tmp1 = b.leftOf(p3, p1);
        if (tmp1 < 0.0f) {
            tmp2 = b.leftOf(p4, p2);
            if (tmp2 < 0.0f) {
                c.move(p2);
                d.move(p3);
            } else {
                if (!(tmp2 > 0.0f)) return p2;
                c.move(p1);
                d.move(p2);
            }
        } else if (tmp1 > 0.0f) {
            tmp2 = b.leftOf(p2, p4);
            if (tmp2 < 0.0f) {
                c.move(p4);
                d.move(p1);
            } else {
                if (!(tmp2 > 0.0f)) return p4;
                c.move(p3);
                d.move(p4);
            }
        } else {
            float tmp22 = b.leftOf(p2, p4);
            if (tmp22 < 0.0f) {
                return p1;
            }
            if (!(tmp22 > 0.0f)) return a;
            return p3;
        }
        float[][] A = new float[2][2];
        A[0][0] = b.y - a.y;
        A[0][1] = a.x - b.x;
        A[1][0] = d.y - c.y;
        A[1][1] = c.x - d.x;
        float[] B = new float[]{a.x * b.y - b.x * a.y, c.x * d.y - d.x * c.y};
        float denominator = A[0][0] * A[1][1] - A[0][1] * A[1][0];
        float[][] invA = new float[2][2];
        invA[0][0] = A[1][1] / denominator;
        invA[0][1] = -A[0][1] / denominator;
        invA[1][0] = -A[1][0] / denominator;
        invA[1][1] = A[0][0] / denominator;
        return new Point(invA[0][0] * B[0] + invA[0][1] * B[1], invA[1][0] * B[0] + invA[1][1] * B[1]);
    }

    private void tryIndex(int index) {
        this.revert();
        this.numRedEdges = 0;
        this.numNewRedEdges = 0;
        ArrayList<Constraint> edges = this.node.getConstraints();
        ArrayList<Boolean> oldGreen = new ArrayList<Boolean>(this.edgeGreen);
        this.edgeGreen = new ArrayList(edges.size());
        int i = 0;
        while (i < edges.size()) {
            HillConstraint edge = (HillConstraint)edges.get(i);
            Boolean green = new Boolean(edge.viable(edge.index(this.node), index));
            this.edgeGreen.add(green);
            if (!green.booleanValue()) {
                ++this.numRedEdges;
            }
            if (!oldGreen.get(i).equals(green)) {
                this.changes.add(new Integer(i));
                if (!green.booleanValue()) {
                    ++this.numNewRedEdges;
                }
            }
            ++i;
        }
    }

    public void revert() {
        this.changes.clear();
        this.numRedEdges = 0;
        this.numNewRedEdges = 0;
        this.node.setCurrIndex(this.oldIndex);
        ArrayList<Constraint> edges = this.node.getConstraints();
        this.edgeGreen = new ArrayList(edges.size());
        int i = 0;
        while (i < edges.size()) {
            HillConstraint edge = (HillConstraint)edges.get(i);
            this.edgeGreen.add(new Boolean(edge.isConsistent()));
            if (!edge.isConsistent()) {
                ++this.numRedEdges;
            }
            ++i;
        }
    }

    public int getCurrIndex() {
        return this.currIndex;
    }

    public ArrayList getChangedIndices() {
        return this.changes;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.currIndex != -1 && this.currIndex != this.oldIndex) {
            this.oldIndex = this.currIndex;
            this.processEvent(this.event);
            this.repaint();
            this.parent.repaintGraph();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX() - (this.getWidth() / 2 - this.width / 2);
        int y = e.getY() - (this.getHeight() / 2 - this.height / 2);
        int i = 0;
        while (i < this.elements.size()) {
            Point p = this.positions.get(i);
            FontMetrics fm = this.getFontMetrics(this.font);
            int w = fm.stringWidth(this.elements.get(i).toString());
            int h = fm.getHeight();
            int a = fm.getAscent();
            if (p.x < (float)x && (float)x < p.x + (float)w && p.y - (float)a < (float)y && (float)y < p.y && i != this.oldIndex) {
                if (this.currIndex == i) {
                    return;
                }
                this.currIndex = i;
                this.elementWidth = w;
                this.elementHeight = h;
                this.elementAscent = a;
                this.tryIndex(this.currIndex);
                this.repaint();
                return;
            }
            ++i;
        }
        this.elementAscent = 0;
        this.elementHeight = 0;
        this.elementWidth = 0;
        if (this.currIndex == -1) {
            return;
        }
        this.tryIndex(this.oldIndex);
        this.repaint();
        this.currIndex = -1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    @Override
    protected void processEvent(AWTEvent evt) {
        if (evt instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)evt);
            return;
        }
        super.processEvent(evt);
    }

    protected void processActionEvent(ActionEvent evt) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(evt);
        }
    }
}

