/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill.batch;

import AIspace.hill.batch.BatchTable;
import AIspace.hill.intList.IntVector;
import java.awt.Color;
import javax.swing.JPanel;

public class BatchStep {
    protected static final Color c0 = Color.blue;
    protected static final Color c1 = Color.red;
    protected static final Color c2 = Color.cyan;
    protected static final Color c3 = Color.magenta;
    protected static final Color c4 = Color.green;
    protected static final Color c5 = Color.orange;
    protected static final Color c6 = Color.pink;
    protected static final Color c7 = Color.yellow;
    protected static int count = 0;
    private boolean completed = false;
    private IntVector steps = new IntVector();
    private IntVector times = new IntVector();
    private long totalTime = 0L;
    private long totalSteps = 0L;
    private int successes = 0;
    public Color color = BatchStep.nextColor();
    private JPanel stats;
    private JPanel settings;
    private String[][] algSettings;
    private String[][] engSettings;

    private static Color nextColor() {
        switch (++count) {
            case 0: {
                return c0;
            }
            case 1: {
                return c1;
            }
            case 2: {
                return c2;
            }
            case 3: {
                return c3;
            }
            case 4: {
                return c4;
            }
            case 5: {
                return c5;
            }
            case 6: {
                return c6;
            }
            case 7: {
                return c7;
            }
        }
        return BatchStep.randColor();
    }

    private static Color randColor() {
        double r = Math.random();
        double g = Math.random();
        double b = Math.random();
        if (r < 0.1 && g < 0.1 && b < 0.1) {
            r += 0.5;
            g += 0.5;
            b += 0.5;
        }
        return new Color((float)r, (float)g, (float)b);
    }

    public BatchStep(String[][] algSettings, String[][] engSettings) {
        this.algSettings = algSettings;
        this.engSettings = engSettings;
    }

    public void add(int count, int time, boolean successful) {
        if (successful) {
            ++this.successes;
            this.times.add(time);
        }
        this.steps.add(count);
        this.totalSteps += (long)count;
        this.totalTime += (long)time;
    }

    public IntVector getSteps() {
        return this.steps;
    }

    public IntVector getTimes() {
        return this.times;
    }

    public int getSuccesses() {
        return this.successes;
    }

    public float getAvg(boolean useSteps) {
        if (!this.completed) {
            return -1.0f;
        }
        float total = 0.0f;
        if (useSteps) {
            int i = 0;
            while (i < this.steps.size()) {
                total += (float)this.steps.get(i);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.times.size()) {
                total += (float)this.times.get(i);
                ++i;
            }
        }
        return total / (float)this.steps.size();
    }

    public float getStandardDeviation(boolean useSteps) {
        if (!this.completed) {
            return -1.0f;
        }
        float avg = this.getAvg(useSteps);
        float variance = 0.0f;
        if (useSteps) {
            int i = 0;
            while (i < this.successes) {
                variance += (float)Math.pow((float)this.steps.get(i) - avg, 2.0);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.successes) {
                variance += (float)Math.pow((float)this.times.get(i) - avg, 2.0);
                ++i;
            }
        }
        return (float)Math.sqrt(variance / (float)this.successes);
    }

    public float[] getPercentiles(boolean useSteps, float n) {
        if (!this.completed) {
            return null;
        }
        if (n > 1.0f || n < 0.0f) {
            return null;
        }
        float[] percent = new float[3];
        IntVector subject = useSteps ? this.steps : this.times;
        float low = (float)this.successes * n;
        float high = (float)this.successes * (1.0f - n) - 1.0f;
        if (high < 0.0f) {
            high = 0.0f;
        }
        percent[0] = (float)(subject.get((int)Math.floor(low)) + subject.get((int)Math.ceil(low))) / 2.0f;
        percent[1] = (float)(subject.get((int)Math.floor(high)) + subject.get((int)Math.ceil(high))) / 2.0f;
        percent[2] = percent[1] / percent[0];
        return percent;
    }

    public float[] getMax() {
        float[] max = new float[]{this.steps.last(), this.times.last()};
        return max;
    }

    public float[] getMin() {
        float[] min = new float[]{this.steps.first(), this.times.first()};
        return min;
    }

    public void endRun() {
        this.times.sort();
        this.steps.sort();
        this.completed = true;
    }

    public JPanel getStatPanel(String title) {
        if (this.stats != null) {
            return this.stats;
        }
        BatchTable table = new BatchTable(String.valueOf(title) + " Statistics");
        table.add("Steps", 0, 1, 2);
        table.add("Time (ms)", 0, 2, 2);
        table.add("mean", 1, 0, 2);
        table.add(this.round(this.getAvg(true)), 1, 1);
        table.add(this.round(this.getAvg(false)), 1, 2);
        float[] per = new float[2];
        table.add("median", 2, 0, 2);
        per = this.getPercentiles(true, 0.5f);
        table.add(this.round(per[0]), 2, 1);
        per = this.getPercentiles(false, 0.5f);
        table.add(this.round(per[0]), 2, 2);
        table.add("standard dev", 3, 0, 2);
        table.add(this.round(this.getStandardDeviation(true)), 3, 1);
        table.add(this.round(this.getStandardDeviation(false)), 3, 2);
        table.add("successes", 4, 0, 2);
        table.add(String.valueOf((int)((float)this.successes / (float)this.steps.size() * 100.0f)) + "%", 4, 1);
        table.add("", 4, 2);
        table.add("Percentiles:", 5, 0, Color.white, 2);
        table.add("q10", 6, 0, 2);
        table.add("q90", 7, 0, 2);
        table.add("q90/q10", 8, 0, 2);
        per = this.getPercentiles(true, 0.1f);
        table.add(this.round(per[0]), 6, 1);
        table.add(this.round(per[1]), 7, 1);
        if (per[0] < 0.001f) {
            table.add("NA", 8, 1);
        } else {
            table.add(this.round(per[1] / per[0]), 8, 1);
        }
        per = this.getPercentiles(false, 0.1f);
        table.add(this.round(per[0]), 6, 2);
        table.add(this.round(per[1]), 7, 2);
        if (per[0] < 0.001f) {
            table.add("NA", 8, 2);
        } else {
            table.add(this.round(per[1] / per[0]), 8, 2);
        }
        table.add("q25", 9, 0, 2);
        table.add("q75", 10, 0, 2);
        table.add("q75/q25", 11, 0, 2);
        per = this.getPercentiles(true, 0.25f);
        table.add(this.round(per[0]), 9, 1);
        table.add(this.round(per[1]), 10, 1);
        if (per[0] < 0.001f) {
            table.add("NA", 11, 1);
        } else {
            table.add(this.round(per[1] / per[0]), 11, 1);
        }
        per = this.getPercentiles(false, 0.25f);
        table.add(this.round(per[0]), 9, 2);
        table.add(this.round(per[1]), 10, 2);
        if (per[0] < 0.001f) {
            table.add("NA", 11, 2);
        } else {
            table.add(this.round(per[1] / per[0]), 11, 2);
        }
        table.add("Min", 12, 0, 2);
        table.add("Max", 13, 0, 2);
        per = this.getMin();
        table.add(this.round(per[0]), 12, 1);
        table.add(this.round(per[1]), 12, 2);
        per = this.getMax();
        table.add(this.round(per[0]), 13, 1);
        table.add(this.round(per[1]), 13, 2);
        this.stats = table;
        return this.stats;
    }

    public JPanel getSettingsPanel(String title) {
        if (this.settings != null) {
            return this.settings;
        }
        BatchTable table = new BatchTable(String.valueOf(title) + " Settings");
        int lalg = this.algSettings == null ? 0 : this.algSettings[0].length;
        int leng = this.engSettings[0].length;
        int i = 0;
        while (i < leng) {
            table.add(this.engSettings[0][i], i + 1, 0);
            table.add(this.engSettings[1][i], i + 1, 1);
            ++i;
        }
        i = 0;
        while (i < lalg) {
            table.add(this.algSettings[0][i], i + 2 + leng, 0);
            table.add(this.algSettings[1][i], i + 2 + leng, 1);
            ++i;
        }
        if (lalg != 0) {
            table.add("", lalg, 0);
        }
        this.settings = table;
        return this.settings;
    }

    private String round(float f) {
        return String.valueOf((float)Math.round(f * 100.0f) / 100.0f);
    }
}

