/*
 * Decompiled with CFR 0.152.
 */
package AIspace.hill.search;

import AIspace.hill.HillEngine;
import AIspace.hill.elements.NodeVal;
import AIspace.hill.search.FullPanel;
import AIspace.hill.search.Heuristics;
import AIspace.hill.search.Search;

public class GreedyRandomWalkSearch
extends Search {
    public GreedyRandomWalkSearch(HillEngine engine) {
        this.engine = engine;
        this.initHeuristics();
        this.name = "Greedy Descent with Random Walk";
        this.descriptionFile = "GreedyRandomWalk.txt";
        this.panel = new FullPanel(this);
    }

    private void initHeuristics() {
        this.heuristics = new Heuristics(this.varHeurs, this.varValHeurs, this.secHeurs);
        this.heuristics.setInitProbs(new float[]{0.9f, 0.1f, 0.0f}, new float[]{0.9f, 0.1f}, new float[]{0.9f, 0.1f});
    }

    @Override
    public boolean fineStep() {
        return this.heuristics.getStages() == 2;
    }

    @Override
    public void step() {
        NodeVal nodeAndVal;
        if (this.node != null) {
            this.finestep();
            return;
        }
        if (this.heuristics.getStages() == 1) {
            nodeAndVal = this.getNextNdVal(this.heuristics.getSingleStage());
            this.node = nodeAndVal.getNode();
        } else {
            this.node = this.getNextNode(this.heuristics.getFirstHeur());
            if (this.node == null) {
                return;
            }
            nodeAndVal = new NodeVal(this.node, this.getNextVal(this.heuristics.getSecHeur(), this.node));
        }
        this.engine.getCSP().setNode(nodeAndVal);
        this.deHighLight();
        this.highLight(this.node);
        this.engine.incrementCount();
        this.engine.getCSP().addPlotPoint(this.engine.getCurrentStepCount());
        this.node = null;
    }

    @Override
    public void finestep() {
        if (this.node != null) {
            this.engine.getCSP().setNode(new NodeVal(this.node, this.getNextVal(this.heuristics.getSecHeur(), this.node)));
            this.deHighLight();
            this.engine.incrementCount();
            this.engine.getCSP().addPlotPoint(this.engine.getCurrentStepCount());
            this.engine.addTraceEntry();
            this.node = null;
        } else {
            if (this.heuristics.getStages() == 1) {
                return;
            }
            this.node = this.getNextNode(this.heuristics.getFirstHeur());
            if (this.node == null) {
                return;
            }
            this.highLight(this.node);
        }
    }
}

