/*
 * Decompiled with CFR 0.152.
 */
package CIspace.XMLReader;

import CIspace.XMLReader.Pair;
import CIspace.XMLReader.XMLBlock;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMLTree {
    protected XMLBlock headNode = new XMLBlock();

    public void readString(String input) {
        String noCommentInput = this.stripComments(input);
        this.readString(noCommentInput, this.headNode);
    }

    public XMLBlock findNetworkTree(String tag) {
        Vector<XMLBlock> thisTree = new Vector<XMLBlock>();
        thisTree.addElement(this.headNode);
        return this.findNetworkTree(thisTree, tag);
    }

    private XMLBlock findNetworkTree(Vector currLevel, String tag) {
        int i = 0;
        while (i < currLevel.size()) {
            XMLBlock currBlock = (XMLBlock)currLevel.elementAt(i);
            if (currBlock.getTag().equalsIgnoreCase(tag)) {
                return currBlock;
            }
            XMLBlock returnBlock = this.findNetworkTree(currBlock.childBlocks, tag);
            if (returnBlock != null) {
                return returnBlock;
            }
            ++i;
        }
        return null;
    }

    private String stripComments(String s) {
        String input = s;
        int commentStart = input.indexOf("<!--");
        int commentEnd = 0;
        while (commentStart != -1) {
            commentEnd = input.indexOf("-->");
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(commentEnd + 3);
            commentStart = input.indexOf("<!--");
        }
        commentStart = input.indexOf("<?");
        commentEnd = 0;
        while (commentStart != -1) {
            commentEnd = input.indexOf("?>");
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(commentEnd + 2);
            commentStart = input.indexOf("<?");
        }
        commentStart = input.indexOf("<!DOCTYPE");
        commentEnd = 0;
        while (commentStart != -1) {
            commentEnd = input.indexOf("]>");
            input = String.valueOf(input.substring(0, commentStart)) + input.substring(commentEnd + 2);
            commentStart = -1;
        }
        input = input.substring(input.indexOf("<"));
        return input;
    }

    private void readString(String input, XMLBlock currentNode) {
        int startOfTag = input.indexOf("<");
        int errorTag = input.indexOf("<-");
        while (startOfTag == errorTag) {
            if (startOfTag == -1) {
                return;
            }
            startOfTag = input.indexOf("<", errorTag);
            errorTag = input.indexOf("<-", errorTag);
        }
        int endOfTagName = input.indexOf(" ");
        endOfTagName = input.indexOf(" ") < input.indexOf(">") && input.indexOf(" ") > 0 ? input.indexOf(" ") : input.indexOf(">");
        int endOfStartTag = input.indexOf(">");
        String tag = input.substring(startOfTag + 1, endOfTagName);
        currentNode.setTag(tag);
        int endOfTag = input.indexOf("</" + tag + ">");
        if (input.indexOf("<", endOfStartTag + 1) == endOfTag || tag.equalsIgnoreCase("logicprogram")) {
            currentNode.setText(input.substring(endOfStartTag + 1, endOfTag));
        }
        if (endOfStartTag - endOfTagName > 0) {
            String propString = input.substring(endOfTagName + 1, endOfStartTag);
            propString.trim();
            StringTokenizer startTag = new StringTokenizer(propString, " \"=", true);
            String tok = startTag.nextToken();
            while (startTag.hasMoreTokens()) {
                String propertyName = "";
                String propertyValue = "";
                while (tok.equals(" ")) {
                    tok = startTag.nextToken();
                }
                propertyName = tok;
                tok = startTag.nextToken();
                while (tok.equals(" ") || tok.equals("=")) {
                    tok = startTag.nextToken();
                }
                if (!tok.equals("\"")) {
                    propertyValue = tok;
                    currentNode.addProperty(propertyName, propertyValue);
                } else {
                    propertyValue = startTag.nextToken();
                    tok = startTag.nextToken();
                    while (!tok.equals("\"")) {
                        propertyValue = String.valueOf(propertyValue) + tok;
                        tok = startTag.nextToken();
                    }
                    currentNode.addProperty(propertyName, propertyValue);
                }
                if (!startTag.hasMoreTokens()) break;
                tok = startTag.nextToken();
                while (tok.equals(" ") && startTag.hasMoreTokens()) {
                    tok = startTag.nextToken();
                }
                if (!startTag.hasMoreTokens()) break;
            }
        }
        String remainingString = input.substring(endOfStartTag + 1, endOfTag);
        while (remainingString.indexOf("<") != -1) {
            int startOfNewTag = remainingString.indexOf("<");
            if (!tag.equalsIgnoreCase("logicprogram")) {
                int endOfNewTagName = startOfNewTag;
                endOfNewTagName = remainingString.indexOf(" ", startOfNewTag) < remainingString.indexOf(">", startOfNewTag) && remainingString.indexOf(" ", startOfNewTag) > 0 ? remainingString.indexOf(" ", startOfNewTag) : remainingString.indexOf(">", startOfNewTag);
                String newTag = remainingString.substring(startOfNewTag + 1, endOfNewTagName);
                int endOfNewTag = remainingString.indexOf("</" + newTag + ">");
                XMLBlock newChildNode = new XMLBlock();
                String childString = String.valueOf(remainingString.substring(startOfNewTag, endOfNewTag)) + "</" + newTag + ">";
                remainingString = remainingString.substring(endOfNewTag + ("/" + newTag + ">").length() + 1);
                this.readString(childString, newChildNode);
                currentNode.addChild(newChildNode);
                continue;
            }
            String copyOfRemainingString = new String(remainingString);
            copyOfRemainingString.toLowerCase();
            int endOfNewTag = copyOfRemainingString.indexOf("</logicprogram>");
            remainingString = remainingString.substring(endOfNewTag + 15);
        }
    }

    public void print() {
        this.printAll(this.headNode, 0);
    }

    private void printAll(XMLBlock currNode, int spaces) {
        String s = "";
        int i = 0;
        while (i < spaces) {
            s = String.valueOf(s) + "\t ";
            ++i;
        }
        System.out.println(String.valueOf(s) + "node tag: " + currNode.getTag());
        i = 0;
        while (i < currNode.getProperties().size()) {
            System.out.println(String.valueOf(s) + "Property: " + ((Pair)currNode.getProperties().elementAt((int)i)).name);
            ++i;
        }
        System.out.println(String.valueOf(s) + "Text: " + currNode.getText());
        System.out.println(String.valueOf(s) + "Children: ");
        i = 0;
        while (i < currNode.childBlocks.size()) {
            this.printAll((XMLBlock)currNode.childBlocks.elementAt(i), spaces + 1);
            ++i;
        }
    }

    public XMLBlock getHead() {
        return this.headNode;
    }
}

