/*
 * Decompiled with CFR 0.152.
 */
package CIspace.graphToolKit;

import CIspace.graphToolKit.GraphConsts;
import CIspace.graphToolKit.Point;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class CanvasTab
extends Canvas
implements MouseListener {
    private Vector tabs;
    private int height;
    private int[] widths;
    private Color bg = GraphConsts.bg;
    private int selected;
    private Font font;
    private static final int PAD_LEFT = 15;
    private static final int PAD_BTW = 5;
    private static final int OFFSET_LEFT = 10;
    private static final int OFFSET_RIGHT = 10;
    private ActionListener actionListener = null;
    private ActionEvent event;

    public CanvasTab() {
        this.setBackground(this.bg.darker());
        this.tabs = new Vector(2, 2);
        this.setSize(120, 25);
        this.addMouseListener(this);
        this.font = new Font("SansSerif", 0, 12);
        this.event = new ActionEvent(this, 1001, "canvasTab");
    }

    public void addTab(String newTab) {
        this.selected = this.tabs.size();
        this.tabs.addElement(newTab);
    }

    public void selectTab(String newTab) {
        this.selected = this.tabs.indexOf(newTab);
    }

    public void paint(Graphics g) {
        int w;
        String str;
        g.setFont(this.font);
        int WIDTH = this.getSize().width;
        int HEIGHT = this.getSize().height;
        FontMetrics fm = g.getFontMetrics();
        g.clearRect(0, 0, WIDTH, HEIGHT);
        int[] x0 = new int[this.tabs.size()];
        x0[0] = 15;
        this.widths = new int[this.tabs.size()];
        int i = 0;
        while (i < this.tabs.size()) {
            str = (String)this.tabs.elementAt(i);
            this.widths[i] = w = fm.stringWidth(str);
            if (i != 0) {
                x0[i] = x0[i - 1] + this.widths[i - 1] + 5;
            }
            ++i;
        }
        i = this.tabs.size() - 1;
        while (i >= 0) {
            str = (String)this.tabs.elementAt(i);
            w = fm.stringWidth(str);
            if (i != this.selected) {
                this.drawTab(g, str, x0[i], w);
            }
            --i;
        }
        g.setColor(this.bg.darker());
        g.drawLine(0, HEIGHT - 2, WIDTH, HEIGHT - 2);
        g.setColor(this.bg.brighter());
        g.drawLine(0, HEIGHT - 1, WIDTH, HEIGHT - 1);
        String str2 = (String)this.tabs.elementAt(this.selected);
        int w2 = fm.stringWidth(str2);
        this.drawTab(g, str2, x0[this.selected], w2);
    }

    private void drawTab(Graphics g, String str, int x0, int w) {
        int[] x = new int[4];
        int[] y = new int[4];
        int WIDTH = this.getSize().width;
        int HEIGHT = this.getSize().height;
        x[0] = x0 - 10;
        y[0] = HEIGHT;
        x[1] = x0;
        y[1] = 5;
        x[2] = x0 + w;
        y[2] = 5;
        x[3] = x0 + w + 10;
        y[3] = HEIGHT;
        g.setColor(this.bg);
        g.fillPolygon(x, y, 4);
        g.setColor(this.bg.brighter());
        g.drawPolyline(x, y, 4);
        g.setColor(this.bg.darker());
        g.drawLine(x[0] - 1, y[0], x[1] - 1, y[1]);
        g.drawLine(x[1], y[1] - 1, x[2], y[2] - 1);
        g.drawLine(x[2] - 1, y[2], x[3] - 1, y[3]);
        g.setColor(GraphConsts.fg);
        g.drawString(str, x0, HEIGHT - 2);
    }

    private boolean inTab(Point p, int index) {
        int WIDTH = this.getSize().width;
        int HEIGHT = this.getSize().height;
        int x = 15;
        int i = 0;
        while (i < index) {
            x += this.widths[i] + 5;
            ++i;
        }
        Point p1 = new Point(x - 10, HEIGHT);
        Point p2 = new Point(x, 5.0f);
        Point p3 = new Point(x + this.widths[index], 5.0f);
        Point p4 = new Point(x + this.widths[index] + 10, HEIGHT);
        return p.checkSide(p1, p2) > 0.0f && p.checkSide(p2, p3) > 0.0f && p.checkSide(p3, p4) > 0.0f && p.checkSide(p4, p1) > 0.0f;
    }

    public String getSelectedTab() {
        return (String)this.tabs.elementAt(this.selected);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        if (this.inTab(p, this.selected)) {
            return;
        }
        int i = this.tabs.size() - 1;
        while (i >= 0) {
            if (i != this.selected && this.inTab(p, i)) {
                this.selected = i;
                this.processEvent(this.event);
                this.repaint();
            }
            --i;
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void processEvent(AWTEvent evt) {
        if (evt instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)evt);
            return;
        }
        super.processEvent(evt);
    }

    protected void processActionEvent(ActionEvent evt) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(evt);
        }
    }
}

